/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.debugger.jpda.evaluator.BodyParser;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.ParseException;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;
import org.netbeans.modules.debugger.jpda.evaluator.ThreadPool;
import org.netbeans.modules.debugger.jpda.evaluator.TimeoutException;
import org.netbeans.modules.debugger.jpda.evaluator.TokenMgrError;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;

public class Evaluator {
    private static final int DEFAULT_TIME_OUT = 4000;
    private static int timeout = 4000;
    private static RemoteValue result;
    private static Value toStringResult;
    private static Exception exception;
    private static boolean finished;

    public static synchronized Value evaluate(String expr, VirtualMachine vm, ThreadReference remoteThread, int frame, List imports) throws EvaluateException {
        VMEngine engine = new VMEngine(vm, remoteThread, frame, imports);
        if (expr == null) {
            expr = "";
        }
        StringReader reader = new StringReader(expr);
        BodyParser.Init(reader);
        PValue tree = null;
        try {
            tree = BodyParser.parseExpression();
        }
        catch (ParseException e) {
            throw new EvaluateException(e.getMessage());
        }
        catch (TokenMgrError e) {
            throw new EvaluateException(e.getMessage());
        }
        Thread evalThread = ThreadPool.createThread(new EvaluatingRunnable(Thread.currentThread(), engine, tree));
        result = null;
        exception = null;
        finished = false;
        evalThread.start();
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!finished) {
            evalThread.stop();
            throw new TimeoutException(PValue.getLocString("CTL_Time_out"));
        }
        if (exception != null) {
            if (exception instanceof EvaluateException) {
                throw (EvaluateException)exception;
            }
            PValue.error("CTL_Unexpected_exception", exception.toString());
        }
        return engine.mirrorOf(result);
    }

    public static synchronized Value toString(ObjectReference obj, Method method, ThreadReference remoteThread) throws EvaluateException {
        Thread evalThread = ThreadPool.createThread(new ToStringRunnable(Thread.currentThread(), obj, method, remoteThread));
        toStringResult = null;
        exception = null;
        finished = false;
        evalThread.start();
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!finished) {
            evalThread.stop();
            throw new TimeoutException(PValue.getLocString("CTL_Time_out"));
        }
        if (exception != null) {
            if (exception instanceof EvaluateException) {
                throw (EvaluateException)exception;
            }
            PValue.error("CTL_Unexpected_exception", exception.toString());
        }
        return toStringResult;
    }

    private static class ToStringRunnable
    implements Runnable {
        private Thread thread;
        private Method method;
        private ObjectReference obj;
        private ThreadReference remoteThread;

        ToStringRunnable(Thread thread, ObjectReference obj, Method method, ThreadReference remoteThread) {
            this.thread = thread;
            this.method = method;
            this.obj = obj;
            this.remoteThread = remoteThread;
        }

        public void run() {
            try {
                toStringResult = this.obj.invokeMethod(this.remoteThread, this.method, new LinkedList(), 1);
            }
            catch (Exception e) {
                exception = e;
            }
            finished = true;
            this.thread.interrupt();
        }
    }

    private static class EvaluatingRunnable
    implements Runnable {
        private Thread thread;
        private VMEngine engine;
        private PValue tree;

        EvaluatingRunnable(Thread thread, VMEngine engine, PValue tree) {
            this.thread = thread;
            this.engine = engine;
            this.tree = tree;
        }

        public void run() {
            try {
                result = this.tree.value(this.engine);
            }
            catch (Exception e) {
                exception = e;
            }
            finished = true;
            this.thread.interrupt();
        }
    }
}

