/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;
import org.netbeans.modules.debugger.jpda.evaluator.Token;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;

public class Node {

    static class BinaryConditionalOperator
    extends PValue {
        private PValue lVar;
        private PValue rVar;

        BinaryConditionalOperator(PValue lVariable, Token operator, PValue rVariable) {
            super(operator);
            this.lVar = lVariable;
            this.rVar = rVariable;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue operand = this.lVar.value(engine);
            if (operand instanceof RemoteValue.Boolean) {
                boolean res = ((RemoteValue.Boolean)operand).booleanValue();
                if (this.token.kind == 91 && !res) {
                    return new RemoteValue.Boolean(false);
                }
                if (this.token.kind == 90 && res) {
                    return new RemoteValue.Boolean(true);
                }
                RemoteValue operand2 = this.rVar.value(engine);
                if (operand2 instanceof RemoteValue.Boolean) {
                    res = ((RemoteValue.Boolean)operand2).booleanValue();
                    return new RemoteValue.Boolean(res);
                }
                PValue.error("CTL_Bin_cond_operator_cannot_be_performed", PValue.operatorName(this.token.kind), operand2.typeName());
            } else {
                PValue.error("CTL_Bin_cond_operator_cannot_be_performed", PValue.operatorName(this.token.kind), operand.typeName());
            }
            return null;
        }
    }

    static class UnaryOperator
    extends PValue {
        private PValue operand;

        UnaryOperator(PValue operand, Token operator) {
            super(operator);
            this.operand = operand;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue oper = this.operand.value(engine);
            switch (this.token.kind) {
                case 82: {
                    if (!(oper instanceof RemoteValue.Boolean)) break;
                    return new RemoteValue.Boolean(!((RemoteValue.Boolean)oper).booleanValue());
                }
                case 83: {
                    if (!(oper instanceof RemoteValue.Numeric) || oper instanceof RemoteValue.Double || oper instanceof RemoteValue.Float) break;
                    if (oper instanceof RemoteValue.Long) {
                        return new RemoteValue.Long(((RemoteValue.Numeric)oper).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    return new RemoteValue.Integer(~((RemoteValue.Numeric)oper).intValue());
                }
                case 94: {
                    if (oper instanceof RemoteValue.Numeric) {
                        if (oper instanceof RemoteValue.Double || oper instanceof RemoteValue.Float || oper instanceof RemoteValue.Long || oper instanceof RemoteValue.Integer) {
                            return oper;
                        }
                        return new RemoteValue.Integer(((RemoteValue.Numeric)oper).intValue());
                    }
                }
                case 95: {
                    if (!(oper instanceof RemoteValue.Numeric)) break;
                    RemoteValue.Numeric op = (RemoteValue.Numeric)oper;
                    if (oper instanceof RemoteValue.Double) {
                        return new RemoteValue.Double(-op.doubleValue());
                    }
                    if (oper instanceof RemoteValue.Float) {
                        return new RemoteValue.Float(-op.floatValue());
                    }
                    if (oper instanceof RemoteValue.Long) {
                        return new RemoteValue.Long(-op.longValue());
                    }
                    return new RemoteValue.Integer(-op.intValue());
                }
            }
            PValue.error("CTL_Unary_operator_cannot_be_used", PValue.operatorName(this.token.kind), oper.typeName());
            return null;
        }
    }

    static class BinaryOperator
    extends PValue {
        private PValue lVar;
        private PValue rVar;

        BinaryOperator(PValue lVariable, Token operator, PValue rVariable) {
            super(operator);
            this.lVar = lVariable;
            this.rVar = rVariable;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue lOperand = this.lVar.value(engine);
            RemoteValue rOperand = this.rVar.value(engine);
            return BinaryOperator.value(engine, lOperand, this.token.kind, rOperand);
        }

        static RemoteValue value(VMEngine engine, RemoteValue lOperand, int operator, RemoteValue rOperand) throws EvaluateException {
            if (lOperand instanceof RemoteValue.Boolean && rOperand instanceof RemoteValue.Boolean) {
                boolean op1 = ((RemoteValue.Boolean)lOperand).booleanValue();
                boolean op2 = ((RemoteValue.Boolean)rOperand).booleanValue();
                boolean res = false;
                switch (operator) {
                    case 86: {
                        res = op1 == op2;
                        break;
                    }
                    case 89: {
                        res = op1 != op2;
                        break;
                    }
                    case 99: {
                        res = op1 | op2;
                        break;
                    }
                    case 98: {
                        res = op1 & op2;
                        break;
                    }
                    case 100: {
                        res = op1 ^ op2;
                        break;
                    }
                    default: {
                        PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(operator), lOperand.typeName(), rOperand.typeName());
                    }
                }
                return new RemoteValue.Boolean(res);
            }
            if (lOperand instanceof RemoteValue.Numeric && rOperand instanceof RemoteValue.Numeric) {
                switch (operator) {
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 101: {
                        return BinaryOperator.evaluateAddOperator((RemoteValue.Numeric)lOperand, (RemoteValue.Numeric)rOperand, operator);
                    }
                    case 102: 
                    case 103: 
                    case 104: {
                        return BinaryOperator.evaluateShiftOperator((RemoteValue.Numeric)lOperand, (RemoteValue.Numeric)rOperand, operator);
                    }
                    case 98: 
                    case 99: 
                    case 100: {
                        return BinaryOperator.evaluateBitOperator((RemoteValue.Numeric)lOperand, (RemoteValue.Numeric)rOperand, operator);
                    }
                    case 80: 
                    case 81: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: {
                        return BinaryOperator.evaluateComparisonOperator((RemoteValue.Numeric)lOperand, (RemoteValue.Numeric)rOperand, operator);
                    }
                }
            }
            if (operator == 86 || operator == 89) {
                if (lOperand instanceof RemoteValue.Null) {
                    if (rOperand instanceof RemoteValue.Null) {
                        return new RemoteValue.Boolean(operator == 86);
                    }
                    if (rOperand instanceof RemoteValue.Object) {
                        return new RemoteValue.Boolean(operator == 89);
                    }
                }
                if (lOperand instanceof RemoteValue.Object) {
                    if (rOperand instanceof RemoteValue.Null) {
                        return new RemoteValue.Boolean(operator == 89);
                    }
                    if (rOperand instanceof RemoteValue.Object) {
                        return new RemoteValue.Boolean(engine.instancesEquals((RemoteValue.Object)lOperand, (RemoteValue.Object)rOperand));
                    }
                }
            }
            if ((lOperand instanceof RemoteValue.String || rOperand instanceof RemoteValue.String) && operator == 94) {
                String s2;
                String s1 = lOperand.toString(engine);
                if (s1 == null) {
                    s1 = "null";
                }
                if ((s2 = rOperand.toString(engine)) == null) {
                    s2 = "null";
                }
                return engine.stringToObject(s1 + s2);
            }
            PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(operator), lOperand.typeName(), rOperand.typeName());
            return null;
        }

        private static RemoteValue.Numeric evaluateAddOperator(RemoteValue.Numeric op1, RemoteValue.Numeric op2, int id) throws EvaluateException {
            if (op1 instanceof RemoteValue.Double || op2 instanceof RemoteValue.Double) {
                double d1 = op1.doubleValue();
                double d2 = op2.doubleValue();
                double res = 0.0;
                switch (id) {
                    case 94: {
                        res = d1 + d2;
                        break;
                    }
                    case 95: {
                        res = d1 - d2;
                        break;
                    }
                    case 101: {
                        res = d1 % d2;
                        break;
                    }
                    case 96: {
                        res = d1 * d2;
                        break;
                    }
                    case 97: {
                        res = d1 / d2;
                    }
                }
                return new RemoteValue.Double(res);
            }
            if (op1 instanceof RemoteValue.Float || op2 instanceof RemoteValue.Float) {
                float f1 = op1.floatValue();
                float f2 = op2.floatValue();
                float res_f = 0.0f;
                switch (id) {
                    case 94: {
                        res_f = f1 + f2;
                        break;
                    }
                    case 95: {
                        res_f = f1 - f2;
                        break;
                    }
                    case 101: {
                        res_f = f1 % f2;
                        break;
                    }
                    case 96: {
                        res_f = f1 * f2;
                        break;
                    }
                    case 97: {
                        res_f = f1 / f2;
                    }
                }
                return new RemoteValue.Float(res_f);
            }
            if (op1 instanceof RemoteValue.Long || op2 instanceof RemoteValue.Long) {
                long long1 = op1.longValue();
                long long2 = op2.longValue();
                long res_long = 0L;
                switch (id) {
                    case 94: {
                        res_long = long1 + long2;
                        break;
                    }
                    case 95: {
                        res_long = long1 - long2;
                        break;
                    }
                    case 101: {
                        res_long = long1 % long2;
                        break;
                    }
                    case 96: {
                        res_long = long1 * long2;
                        break;
                    }
                    case 97: {
                        res_long = long1 / long2;
                    }
                }
                return new RemoteValue.Long(res_long);
            }
            int i1 = op1.intValue();
            int i2 = op2.intValue();
            int res_i = 0;
            switch (id) {
                case 94: {
                    res_i = i1 + i2;
                    break;
                }
                case 95: {
                    res_i = i1 - i2;
                    break;
                }
                case 101: {
                    res_i = i1 % i2;
                    break;
                }
                case 96: {
                    res_i = i1 * i2;
                    break;
                }
                case 97: {
                    res_i = i1 / i2;
                }
            }
            return new RemoteValue.Integer(res_i);
        }

        private static RemoteValue.Numeric evaluateShiftOperator(RemoteValue.Numeric op1, RemoteValue.Numeric op2, int id) throws EvaluateException {
            if (op1 instanceof RemoteValue.Float || op1 instanceof RemoteValue.Double || op2 instanceof RemoteValue.Float || op2 instanceof RemoteValue.Double) {
                PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(id), op1.typeName(), op1.typeName());
                return null;
            }
            if (op1 instanceof RemoteValue.Long) {
                long n1 = op1.longValue();
                long n2 = op2.longValue();
                long res = 0L;
                switch (id) {
                    case 102: {
                        res = n1 << (int)n2;
                        break;
                    }
                    case 103: {
                        res = n1 >> (int)n2;
                        break;
                    }
                    case 104: {
                        res = n1 >>> (int)n2;
                    }
                }
                return new RemoteValue.Long(res);
            }
            int i1 = op1.intValue();
            long i2 = op2.longValue();
            int res_i = 0;
            switch (id) {
                case 102: {
                    res_i = i1 << (int)i2;
                    break;
                }
                case 103: {
                    res_i = i1 >> (int)i2;
                    break;
                }
                case 104: {
                    res_i = i1 >>> (int)i2;
                }
            }
            return new RemoteValue.Integer(res_i);
        }

        private static RemoteValue.Numeric evaluateBitOperator(RemoteValue.Numeric op1, RemoteValue.Numeric op2, int id) throws EvaluateException {
            if (op1 instanceof RemoteValue.Float || op1 instanceof RemoteValue.Double || op2 instanceof RemoteValue.Float || op2 instanceof RemoteValue.Double) {
                PValue.error("CTL_Binary_operator_cannot_be_used", PValue.operatorName(id), op1.typeName(), op1.typeName());
                return null;
            }
            if (op1 instanceof RemoteValue.Long || op2 instanceof RemoteValue.Long) {
                long n1 = op1.longValue();
                long n2 = op2.longValue();
                long res = 0L;
                switch (id) {
                    case 98: {
                        res = n1 & n2;
                        break;
                    }
                    case 99: {
                        res = n1 | n2;
                        break;
                    }
                    case 100: {
                        res = n1 ^ n2;
                    }
                }
                return new RemoteValue.Long(res);
            }
            int i1 = op1.intValue();
            int i2 = op2.intValue();
            int res_i = 0;
            switch (id) {
                case 98: {
                    res_i = i1 & i2;
                    break;
                }
                case 99: {
                    res_i = i1 | i2;
                    break;
                }
                case 100: {
                    res_i = i1 ^ i2;
                }
            }
            return new RemoteValue.Integer(res_i);
        }

        private static RemoteValue.Boolean evaluateComparisonOperator(RemoteValue.Numeric op1, RemoteValue.Numeric op2, int id) {
            boolean res = false;
            if (op1 instanceof RemoteValue.Double || op2 instanceof RemoteValue.Double) {
                double d1 = op1.doubleValue();
                double d2 = op2.doubleValue();
                switch (id) {
                    case 81: {
                        res = d1 < d2;
                        break;
                    }
                    case 80: {
                        res = d1 > d2;
                        break;
                    }
                    case 87: {
                        res = d1 <= d2;
                        break;
                    }
                    case 88: {
                        res = d1 >= d2;
                        break;
                    }
                    case 86: {
                        res = d1 == d2;
                        break;
                    }
                    case 89: {
                        boolean bl = res = d1 != d2;
                    }
                }
            }
            if (op1 instanceof RemoteValue.Float || op2 instanceof RemoteValue.Float) {
                float f1 = op1.floatValue();
                float f2 = op2.floatValue();
                switch (id) {
                    case 81: {
                        res = f1 < f2;
                        break;
                    }
                    case 80: {
                        res = f1 > f2;
                        break;
                    }
                    case 87: {
                        res = f1 <= f2;
                        break;
                    }
                    case 88: {
                        res = f1 >= f2;
                        break;
                    }
                    case 86: {
                        res = f1 == f2;
                        break;
                    }
                    case 89: {
                        boolean bl = res = f1 != f2;
                    }
                }
            }
            if (op1 instanceof RemoteValue.Long || op1 instanceof RemoteValue.Long) {
                long n1 = op1.longValue();
                long n2 = op2.longValue();
                switch (id) {
                    case 81: {
                        res = n1 < n2;
                        break;
                    }
                    case 80: {
                        res = n1 > n2;
                        break;
                    }
                    case 87: {
                        res = n1 <= n2;
                        break;
                    }
                    case 88: {
                        res = n1 >= n2;
                        break;
                    }
                    case 86: {
                        res = n1 == n2;
                        break;
                    }
                    case 89: {
                        res = n1 != n2;
                    }
                }
            }
            float i1 = op1.intValue();
            float i2 = op2.intValue();
            switch (id) {
                case 81: {
                    res = i1 < i2;
                    break;
                }
                case 80: {
                    res = i1 > i2;
                    break;
                }
                case 87: {
                    res = i1 <= i2;
                    break;
                }
                case 88: {
                    res = i1 >= i2;
                    break;
                }
                case 86: {
                    res = i1 == i2;
                    break;
                }
                case 89: {
                    res = i1 != i2;
                }
            }
            return new RemoteValue.Boolean(res);
        }
    }

    static class ConditionalExpression
    extends PValue {
        private PValue condition;
        private PValue leftOperand;
        private PValue rightOperand;

        ConditionalExpression(PValue condition, PValue leftOperand, PValue rightOperand) {
            super(null);
            this.condition = condition;
            this.leftOperand = leftOperand;
            this.rightOperand = rightOperand;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue condVal = this.condition.value(engine);
            if (!(condVal instanceof RemoteValue.Boolean)) {
                PValue.error("CTL_Condition_of_conditional_operator_not_boolean", condVal.typeName());
                return null;
            }
            if (((RemoteValue.Boolean)condVal).booleanValue()) {
                return this.leftOperand.value(engine);
            }
            return this.rightOperand.value(engine);
        }
    }

    static class AssignmentOperator
    extends PValue {
        private PValue lOperand;
        private PValue rOperand;

        AssignmentOperator(PValue lOperand, Token operation, PValue rOperand) {
            super(operation);
            this.lOperand = lOperand;
            this.rOperand = rOperand;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue lValue = this.lOperand.value(engine);
            if (!(lValue instanceof RemoteValue.Primitive) && !(lValue instanceof RemoteValue.String) && this.token.kind != 79) {
                PValue.error("CTL_Cannot_perform_compound_assignment", PValue.operatorName(this.token.kind), lValue.typeName());
                return null;
            }
            RemoteValue rValue = this.rOperand.value(engine);
            int op = this.token.kind;
            int resolvedOp = -1;
            switch (op) {
                case 105: {
                    resolvedOp = 94;
                    break;
                }
                case 106: {
                    resolvedOp = 95;
                    break;
                }
                case 107: {
                    resolvedOp = 96;
                    break;
                }
                case 108: {
                    resolvedOp = 97;
                    break;
                }
                case 109: {
                    resolvedOp = 98;
                    break;
                }
                case 110: {
                    resolvedOp = 99;
                    break;
                }
                case 111: {
                    resolvedOp = 100;
                    break;
                }
                case 112: {
                    resolvedOp = 101;
                    break;
                }
                case 113: {
                    resolvedOp = 102;
                    break;
                }
                case 114: {
                    resolvedOp = 103;
                    break;
                }
                case 115: {
                    resolvedOp = 104;
                }
            }
            if (resolvedOp != -1) {
                rValue = BinaryOperator.value(engine, lValue, resolvedOp, rValue);
            }
            if (lValue instanceof RemoteValue.String && !(rValue instanceof RemoteValue.String) && !(rValue instanceof RemoteValue.Null)) {
                PValue.error("CTL_Cannot_perform_assignment", rValue.typeName(), lValue.typeName());
                return null;
            }
            if (lValue instanceof RemoteValue.Boolean && !(rValue instanceof RemoteValue.Boolean)) {
                PValue.error("CTL_Cannot_perform_assignment", rValue.typeName(), lValue.typeName());
                return null;
            }
            if (lValue instanceof RemoteValue.Numeric) {
                if (!(rValue instanceof RemoteValue.Numeric)) {
                    PValue.error("CTL_Cannot_perform_assignment", rValue.typeName(), lValue.typeName());
                    return null;
                }
                RemoteValue.Numeric conv = null;
                RemoteValue.Numeric value = (RemoteValue.Numeric)rValue;
                if (lValue instanceof RemoteValue.Short) {
                    conv = new RemoteValue.Short(value.shortValue());
                } else if (lValue instanceof RemoteValue.Byte) {
                    conv = new RemoteValue.Byte(value.byteValue());
                } else if (lValue instanceof RemoteValue.Character) {
                    conv = new RemoteValue.Character(value.charValue());
                } else if (lValue instanceof RemoteValue.Integer) {
                    conv = new RemoteValue.Integer(value.intValue());
                } else if (lValue instanceof RemoteValue.Long) {
                    conv = new RemoteValue.Long(value.longValue());
                } else if (lValue instanceof RemoteValue.Float) {
                    conv = new RemoteValue.Float(value.floatValue());
                } else if (lValue instanceof RemoteValue.Double) {
                    conv = new RemoteValue.Double(value.doubleValue());
                }
                conv.setReference(value.getReference());
                rValue = conv;
            }
            if (!lValue.isLValue()) {
                PValue.error("CTL_Cannot_assign_to_non_lvalue", PValue.operatorName(op));
                return null;
            }
            lValue.setValue(rValue);
            return rValue;
        }
    }

    static class MMOperator
    extends PValue {
        private PValue operand;
        private boolean isPrefix;

        MMOperator(PValue operand, boolean isPrefix) {
            super(null);
            this.operand = operand;
            this.isPrefix = isPrefix;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue value = this.operand.value(engine);
            if (!(value instanceof RemoteValue.Numeric)) {
                PValue.error("CTL_Cannot_decrement_non_numeric_value", value.typeName());
                return null;
            }
            if (!value.isLValue()) {
                PValue.error("CTL_Cannot_decrement_non_lvalue");
                return null;
            }
            RemoteValue.Byte b = new RemoteValue.Byte(1);
            RemoteValue newValue = BinaryOperator.value(engine, value, 95, b);
            value.setValue(newValue);
            if (this.isPrefix) {
                return newValue;
            }
            value.setReference(null);
            return value;
        }
    }

    static class PPOperator
    extends PValue {
        private PValue operand;
        private boolean isPrefix;

        PPOperator(PValue operand, boolean isPrefix) {
            super(null);
            this.operand = operand;
            this.isPrefix = isPrefix;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue value = this.operand.value(engine);
            if (!(value instanceof RemoteValue.Numeric)) {
                PValue.error("CTL_Cannot_increment_non_numeric_value", value.typeName());
                return null;
            }
            if (!value.isLValue()) {
                PValue.error("CTL_Cannot_increment_non_lvalue");
                return null;
            }
            RemoteValue.Byte b = new RemoteValue.Byte(1);
            RemoteValue newValue = BinaryOperator.value(engine, value, 94, b);
            value.setValue(newValue);
            if (this.isPrefix) {
                return newValue;
            }
            value.setReference(null);
            return value;
        }
    }

    static class CastOperator
    extends PValue {
        private PValue operand;
        private String typeName;

        CastOperator(PValue operand, String typeName) {
            super(null);
            this.operand = operand;
            this.typeName = typeName;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue value = this.operand.value(engine);
            if (value instanceof RemoteValue.Object || value instanceof RemoteValue.Null) {
                if (engine.isInstanceOf(value, this.typeName)) {
                    return value;
                }
                PValue.error("CTL_Cast_operator_throws_exception", value.typeName(), this.typeName);
                return null;
            }
            if (value instanceof RemoteValue.Boolean) {
                if (this.typeName.equals("boolean")) {
                    return value;
                }
                PValue.error("CTL_Cast_operator_throws_exception", value.typeName(), this.typeName);
                return null;
            }
            if (value instanceof RemoteValue.Numeric) {
                RemoteValue.Numeric conv = null;
                if (this.typeName.equals("short")) {
                    conv = new RemoteValue.Short(((RemoteValue.Numeric)value).shortValue());
                } else if (this.typeName.equals("byte")) {
                    conv = new RemoteValue.Byte(((RemoteValue.Numeric)value).byteValue());
                } else if (this.typeName.equals("char")) {
                    conv = new RemoteValue.Character(((RemoteValue.Numeric)value).charValue());
                } else if (this.typeName.equals("int")) {
                    conv = new RemoteValue.Integer(((RemoteValue.Numeric)value).intValue());
                } else if (this.typeName.equals("long")) {
                    conv = new RemoteValue.Long(((RemoteValue.Numeric)value).longValue());
                } else if (this.typeName.equals("float")) {
                    conv = new RemoteValue.Float(((RemoteValue.Numeric)value).floatValue());
                } else if (this.typeName.equals("double")) {
                    conv = new RemoteValue.Double(((RemoteValue.Numeric)value).doubleValue());
                }
                if (conv != null) {
                    conv.setReference(value.getReference());
                    return conv;
                }
            }
            PValue.error("CTL_Cast_operator_throws_exception", value.typeName(), this.typeName);
            return null;
        }
    }

    static class InstanceofOperator
    extends PValue {
        private PValue variable;
        private String type;

        InstanceofOperator(PValue variable, String type) {
            super(null);
            this.variable = variable;
            this.type = type;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue variableValue = this.variable.value(engine);
            if (variableValue instanceof RemoteValue.Object || variableValue instanceof RemoteValue.Null) {
                return new RemoteValue.Boolean(engine.isInstanceOf(variableValue, this.type));
            }
            PValue.error("CTL_Instanceof_on_primitive_type", variableValue.typeName());
            return null;
        }
    }

    static class NewObjectOperator
    extends PValue {
        private String typeName;
        private List args;

        public NewObjectOperator(String typeName, List args) {
            super(null);
            this.typeName = typeName;
            this.args = args;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            ArrayList<RemoteValue> params = new ArrayList<RemoteValue>();
            int x = 0;
            while (x < this.args.size()) {
                params.add(((PValue)this.args.get(x)).value(engine));
                ++x;
            }
            return engine.createNewObject(this.typeName, params);
        }
    }

    static class MethodInvocation
    extends PValue {
        private PValue variable;
        private String methodName;
        private List args;

        public MethodInvocation(PValue variable, String methodName, List args) {
            super(null);
            this.variable = variable;
            this.methodName = methodName;
            this.args = args;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue object = null;
            boolean staticInvocation = false;
            if (this.variable != null) {
                try {
                    object = this.variable.value(engine);
                }
                catch (EvaluateException e) {
                    object = null;
                    if (this.variable instanceof Variable) {
                        staticInvocation = true;
                    }
                    throw e;
                }
                if (object != null) {
                    if (!(object instanceof RemoteValue.Object)) {
                        PValue.error("CTL_Method_invocation_on_non_object", this.methodName, object.typeName());
                        return null;
                    }
                    if (object instanceof RemoteValue.Array) {
                        PValue.error("CTL_Method_invocation_on_array", this.methodName);
                        return null;
                    }
                }
            }
            ArrayList<RemoteValue> params = new ArrayList<RemoteValue>();
            int x = 0;
            while (x < this.args.size()) {
                params.add(((PValue)this.args.get(x)).value(engine));
                ++x;
            }
            String typeName = null;
            if (staticInvocation) {
                typeName = ((Variable)this.variable).name;
            }
            return engine.invokeMethod((RemoteValue.Object)object, typeName, this.methodName, params);
        }
    }

    static class FieldOfVariable
    extends PValue {
        PValue variable;
        Token fieldName;

        FieldOfVariable(PValue variable, Token fieldName) {
            super(null);
            this.variable = variable;
            this.fieldName = fieldName;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue variableValue = this.variable.value(engine);
            if (!(variableValue instanceof RemoteValue.Object)) {
                PValue.error("CTL_Field_operator_on_primitive_type", variableValue.typeName());
                return null;
            }
            return engine.field((RemoteValue.Object)variableValue, this.fieldName.image);
        }
    }

    static class IndexedVariable
    extends PValue {
        private PValue variable;
        private PValue index;

        IndexedVariable(PValue variable, PValue index) {
            super(null);
            this.variable = variable;
            this.index = index;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            RemoteValue variableValue = this.variable.value(engine);
            if (!(variableValue instanceof RemoteValue.Array)) {
                PValue.error("CTL_Not_array", variableValue.typeName());
                return null;
            }
            RemoteValue indexValue = this.index.value(engine);
            if (!(indexValue instanceof RemoteValue.Numeric) || indexValue instanceof RemoteValue.Long || indexValue instanceof RemoteValue.Float || indexValue instanceof RemoteValue.Double) {
                PValue.error("CTL_Index_of_array", indexValue.typeName());
                return null;
            }
            return engine.itemOfArray((RemoteValue.Array)variableValue, ((RemoteValue.Numeric)indexValue).intValue());
        }
    }

    static class Variable
    extends PValue {
        String name;

        Variable(String name) {
            super(null);
            this.name = name;
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            return engine.resolveVariableName(this.name);
        }
    }

    static class StringLiteral
    extends PValue {
        StringLiteral(Token token) {
            super(token);
        }

        static String resolveString(String input) {
            String result = "";
            int index = 0;
            while (index < input.length()) {
                if (input.charAt(index) != '\\') {
                    result = result + input.charAt(index);
                } else {
                    char c;
                    switch (input.charAt(++index)) {
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case '\"': {
                            c = '\"';
                            break;
                        }
                        case '\'': {
                            c = '\'';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                        default: {
                            c = '\u0000';
                            while (index < input.length() && input.charAt(index) >= '0' && input.charAt(index) <= '7' && c * 8 + input.charAt(index) - 48 < 256) {
                                c = (char)(c * 8 + (input.charAt(index) - 48));
                                ++index;
                            }
                            --index;
                        }
                    }
                    result = result + c;
                }
                ++index;
            }
            return result;
        }

        public RemoteValue value(VMEngine engine) {
            String s = StringLiteral.resolveString(this.token.image.substring(1, this.token.image.length() - 1));
            return engine.stringToObject(s);
        }
    }

    static class CharacterLiteral
    extends PValue {
        CharacterLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine engine) {
            char c = StringLiteral.resolveString(this.token.image.substring(1, this.token.image.length() - 1)).charAt(0);
            return new RemoteValue.Character(c);
        }
    }

    static class NullLiteral
    extends PValue {
        NullLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine engine) {
            return new RemoteValue.Null();
        }
    }

    static class BooleanLiteral
    extends PValue {
        BooleanLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine engine) {
            return new RemoteValue.Boolean(this.token.image.equals("true"));
        }
    }

    static class FloatLiteral
    extends PValue {
        FloatLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            String s = this.token.image;
            char c = s.charAt(s.length() - 1);
            try {
                if (c == 'f' || c == 'F') {
                    return new RemoteValue.Float(Float.parseFloat(s));
                }
                return new RemoteValue.Double(Double.parseDouble(s));
            }
            catch (NumberFormatException e) {
                PValue.error("CTL_Bad_number_format", this.token.image);
                return null;
            }
        }
    }

    static class IntegerLiteral
    extends PValue {
        IntegerLiteral(Token token) {
            super(token);
        }

        public RemoteValue value(VMEngine engine) throws EvaluateException {
            String s = this.token.image;
            char c = s.charAt(s.length() - 1);
            boolean isLong = c == 'L' || c == 'l';
            try {
                if (isLong) {
                    return new RemoteValue.Long(Long.decode(s.substring(0, s.length() - 1)));
                }
                return new RemoteValue.Integer(Integer.decode(s));
            }
            catch (NumberFormatException e) {
                if (isLong) {
                    if (s.equals("0x8000000000000000L")) {
                        return new RemoteValue.Long(Long.MIN_VALUE);
                    }
                    if (s.equals("0xffffffffffffffffL")) {
                        return new RemoteValue.Long(-1L);
                    }
                    if (s.equals("01777777777777777777777L")) {
                        return new RemoteValue.Long(-1L);
                    }
                    if (s.equals("01000000000000000000000L")) {
                        return new RemoteValue.Long(Long.MIN_VALUE);
                    }
                } else {
                    if (s.equals("0x80000000")) {
                        return new RemoteValue.Integer(Integer.MIN_VALUE);
                    }
                    if (s.equals("0xffffffff")) {
                        return new RemoteValue.Integer(-1);
                    }
                    if (s.equals("020000000000")) {
                        return new RemoteValue.Integer(Integer.MIN_VALUE);
                    }
                    if (s.equals("037777777777")) {
                        return new RemoteValue.Integer(-1);
                    }
                }
                PValue.error("CTL_Bad_number_format", this.token.image);
                return null;
            }
        }
    }
}

