/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.modules.debugger.jpda.evaluator.BodyParserConstants;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.Node;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;
import org.netbeans.modules.debugger.jpda.evaluator.Token;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;
import org.openide.util.NbBundle;

public abstract class PValue
implements BodyParserConstants {
    protected Token token;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$evaluator$PValue;

    public static String getLocString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$evaluator$PValue == null ? (class$org$netbeans$modules$debugger$jpda$evaluator$PValue = PValue.class$("org.netbeans.modules.debugger.jpda.evaluator.PValue")) : class$org$netbeans$modules$debugger$jpda$evaluator$PValue), (String)s);
    }

    PValue(Token token) {
        this.token = token;
    }

    static PValue createInt(Token s) {
        return new Node.IntegerLiteral(s);
    }

    static PValue createFloat(Token s) {
        return new Node.FloatLiteral(s);
    }

    static PValue createChar(Token s) {
        return new Node.CharacterLiteral(s);
    }

    static PValue createString(Token s) {
        return new Node.StringLiteral(s);
    }

    static PValue createBoolean(Token s) {
        return new Node.BooleanLiteral(s);
    }

    static PValue createNull(Token s) {
        return new Node.NullLiteral(s);
    }

    static PValue createNewObject(String clsName, List args) {
        return new Node.NewObjectOperator(clsName, args);
    }

    static PValue createVariable(String clsName) {
        return new Node.Variable(clsName);
    }

    static PValue createIndexedVariable(PValue variable, PValue index) {
        return new Node.IndexedVariable(variable, index);
    }

    static PValue createField(PValue variable, Token fieldName) {
        return new Node.FieldOfVariable(variable, fieldName);
    }

    static PValue createMethod(PValue variable, List args) {
        if (variable instanceof Node.FieldOfVariable) {
            PValue var = ((Node.FieldOfVariable)variable).variable;
            String methodName = ((Node.FieldOfVariable)variable).fieldName.image;
            return new Node.MethodInvocation(var, methodName, args);
        }
        if (variable instanceof Node.Variable) {
            String name = ((Node.Variable)variable).name;
            int index = name.lastIndexOf(".");
            if (index > -1) {
                String identifier = name.substring(0, index).trim();
                String methodName = name.substring(index + 1, name.length()).trim();
                ((Node.Variable)variable).name = identifier;
                return new Node.MethodInvocation(variable, methodName, args);
            }
            return new Node.MethodInvocation(null, ((Node.Variable)variable).name, args);
        }
        return null;
    }

    static PValue createAssignment(PValue lVariable, Token operator, PValue rVariable) {
        return new Node.AssignmentOperator(lVariable, operator, rVariable);
    }

    static PValue createConditionalExpression(PValue condition, PValue leftOperand, PValue rightOperand) {
        return new Node.ConditionalExpression(condition, leftOperand, rightOperand);
    }

    static PValue createBinaryCondExpression(PValue lValue, Token operator, PValue rValue) {
        return new Node.BinaryConditionalOperator(lValue, operator, rValue);
    }

    static PValue createBExpression(PValue lVariable, Token operator, PValue rVariable) {
        return new Node.BinaryOperator(lVariable, operator, rVariable);
    }

    static PValue createInstanceOfExpression(PValue value, String type) {
        return new Node.InstanceofOperator(value, type);
    }

    static PValue createUExpression(PValue value, Token operator) {
        return new Node.UnaryOperator(value, operator);
    }

    static PValue createPrefixPP(PValue value) {
        return new Node.PPOperator(value, true);
    }

    static PValue createPrefixMM(PValue value) {
        return new Node.MMOperator(value, true);
    }

    static PValue createPostfixPP(PValue value) {
        return new Node.PPOperator(value, false);
    }

    static PValue createPostfixMM(PValue value) {
        return new Node.MMOperator(value, false);
    }

    static PValue createCastExpression(PValue value, String type) {
        return new Node.CastOperator(value, type);
    }

    static String operatorName(int index) {
        switch (index) {
            case 79: {
                return "=";
            }
            case 80: {
                return ">";
            }
            case 81: {
                return "<";
            }
            case 82: {
                return "!";
            }
            case 83: {
                return "~";
            }
            case 84: {
                return "?";
            }
            case 85: {
                return ":";
            }
            case 86: {
                return "==";
            }
            case 87: {
                return "<=";
            }
            case 88: {
                return ">=";
            }
            case 89: {
                return "!=";
            }
            case 90: {
                return "||";
            }
            case 91: {
                return "&&";
            }
            case 92: {
                return "++";
            }
            case 93: {
                return "--";
            }
            case 94: {
                return "+";
            }
            case 95: {
                return "-";
            }
            case 96: {
                return "*";
            }
            case 97: {
                return "/";
            }
            case 98: {
                return "&";
            }
            case 99: {
                return "|";
            }
            case 100: {
                return "^";
            }
            case 101: {
                return "%";
            }
            case 102: {
                return "<<";
            }
            case 103: {
                return ">>";
            }
            case 104: {
                return ">>>";
            }
            case 105: {
                return "+=";
            }
            case 106: {
                return "-=";
            }
            case 107: {
                return "*=";
            }
            case 108: {
                return "/=";
            }
            case 109: {
                return "&=";
            }
            case 110: {
                return "|=";
            }
            case 111: {
                return "^=";
            }
            case 112: {
                return "%=";
            }
            case 113: {
                return "<<=";
            }
            case 114: {
                return ">>=";
            }
            case 115: {
                return ">>>=";
            }
        }
        return "???";
    }

    public RemoteValue value(VMEngine engine) throws EvaluateException {
        return null;
    }

    public static void error(String message) throws EvaluateException {
        PValue.error(message, new Object[0]);
    }

    public static void error(String message, Object par) throws EvaluateException {
        PValue.error(message, new Object[]{par});
    }

    public static void error(String message, Object par1, Object par2) throws EvaluateException {
        PValue.error(message, new Object[]{par1, par2});
    }

    public static void error(String message, Object par1, Object par2, Object par3) throws EvaluateException {
        PValue.error(message, new Object[]{par1, par2, par3});
    }

    public static void error(String messageId, Object[] params) throws EvaluateException {
        String msg = new MessageFormat(PValue.getLocString(messageId)).format(params);
        throw new EvaluateException(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

