/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = expected + "...";
            }
            expected = expected + this.eol + "    ";
            ++i;
        }
        String retval = PValue.getLocString("CTL_Lexical_error") + " \"" + this.currentToken.next.image + "\" " + PValue.getLocString("CTL_at_line") + " " + this.currentToken.next.beginLine + ", " + PValue.getLocString("CTL_column") + " " + this.currentToken.next.beginColumn;
        return retval;
    }
}

