/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.debugger.jpda.evaluator.ThreadPool;

final class ThreadPool {
    private static final int POOL_CAPACITY = 2;
    private static long threadCounter = 0L;
    private static Object poolLock = new Object();
    private static SoftReference poolRef = new SoftReference(new HashSet(2));

    ThreadPool() {
    }

    public static Thread createThread(Runnable r) {
        SharedThread thread = null;
        Object object = poolLock;
        synchronized (object) {
            Set set = (Set)poolRef.get();
            if (set != null && set.size() > 0) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    thread = (SharedThread)it.next();
                    it.remove();
                    if (thread.isAlive()) break;
                    thread = null;
                }
            }
        }
        if (thread == null) {
            thread = new SharedThread();
        }
        thread.schedule(r);
        return thread;
    }

    private static void returnToThreadPool(SharedThread thread) {
        Object object = poolLock;
        synchronized (object) {
            HashSet<SharedThread> set = (HashSet<SharedThread>)poolRef.get();
            if (set == null) {
                set = new HashSet<SharedThread>(2);
                poolRef = new SoftReference(set);
            }
            if (set.size() < 2) {
                set.add(thread);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 10) {
            class R
            implements Runnable {
                private int i;

                R(int i) {
                    this.i = i;
                }

                public void run() {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.err.println("R" + this.i);
                }
            }
            Thread t = ThreadPool.createThread(new R(i));
            t.start();
            if (i == 5) {
                t.stop();
            }
            Thread.sleep(50L);
            if (i == 7) {
                t.stop();
            }
            ++i;
        }
        Thread.sleep(2000L);
    }

    private static class SharedThread
    extends Thread {
        private Runnable body;
        private Object lock = new Object();
        private boolean started = false;
        private boolean threadStarted = false;

        public SharedThread() {
            this.setDaemon(true);
            this.setName("JPDA Evaluator-" + threadCounter++);
        }

        public void schedule(Runnable body) {
            Object object = this.lock;
            synchronized (object) {
                this.started = false;
            }
            this.body = body;
        }

        public void run() {
            while (true) {
                Object var5_5;
                try {
                    try {
                        Object object = this.lock;
                        synchronized (object) {
                            while (!this.started) {
                                this.lock.wait();
                            }
                        }
                        this.body.run();
                        Object object2 = this.lock;
                        synchronized (object2) {
                            this.started = false;
                            ThreadPool.returnToThreadPool(this);
                        }
                        var5_5 = null;
                    }
                    catch (InterruptedException ex) {
                        var5_5 = null;
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = null;
                    throw throwable;
                }
            }
        }

        public void start() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.threadStarted) {
                    super.start();
                    this.threadStarted = true;
                }
                this.started = true;
                this.lock.notify();
            }
        }
    }
}

