/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.LReference;
import org.netbeans.modules.debugger.jpda.evaluator.PValue;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;

public class VMEngine {
    private VirtualMachine vm;
    private ThreadReference threadReference;
    private int frame;
    private List imports;
    private StackFrame stackFrame;

    public VMEngine(VirtualMachine vm, ThreadReference threadReference, int frame, List imports) throws EvaluateException {
        this.vm = vm;
        this.threadReference = threadReference;
        this.frame = frame;
        this.imports = imports != null ? imports : new LinkedList();
        this.stackFrame = null;
        try {
            this.stackFrame = threadReference.frame(frame);
        }
        catch (Exception e) {
            PValue.error("CTL_Cannot_obtain_stack_frame");
        }
    }

    /*
     * Unable to fully structure code
     */
    public RemoteValue resolveVariableName(String name) throws EvaluateException {
        tok = new StringTokenizer(name, ".");
        identifier = tok.nextToken();
        value = this.localValue(identifier);
        if (value == null) {
            value = this.instanceValue(identifier);
        }
        if (value == null) {
            value = this.staticValue(identifier);
        }
        if (value == null) {
            useImports = true;
            while (tok.hasMoreTokens()) {
                ref = this.resolveTypeName(identifier, useImports);
                if (ref != null) {
                    fieldName = tok.nextToken();
                    value = this.staticValue(ref, fieldName);
                    break;
                }
                identifier = identifier + "." + tok.nextToken();
                useImports = false;
            }
        }
        if (value != null) ** GOTO lbl29
        PValue.error("CTL_Unknown_identifier", name);
        return null;
lbl-1000:
        // 1 sources

        {
            identifier = tok.nextToken();
            if (!(value instanceof RemoteValue.Object)) {
                PValue.error("CTL_Unknown_field_name", identifier);
                return null;
            }
            if ((value = this.field((RemoteValue.Object)value, identifier)) != null) continue;
            PValue.error("CTL_Unknown_field_name", identifier);
            return null;
lbl29:
            // 2 sources

            ** while (tok.hasMoreTokens())
        }
lbl30:
        // 1 sources

        return value;
    }

    public RemoteValue localValue(String name) throws EvaluateException {
        if (name.equals("this")) {
            ObjectReference thisObject = this.stackFrame.thisObject();
            if (thisObject == null) {
                PValue.error("CTL_No_this_object");
                return null;
            }
            return this.resolveValue(thisObject);
        }
        try {
            LocalVariable var = this.stackFrame.visibleVariableByName(name);
            if (var == null) {
                return null;
            }
            RemoteValue value = this.resolveValue(this.stackFrame.getValue(var));
            value.setReference(new LReference.LocalVariable(this, this.stackFrame, var));
            return value;
        }
        catch (AbsentInformationException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public RemoteValue instanceValue(String name) {
        try {
            ObjectReference thisObject = this.stackFrame.thisObject();
            if (thisObject == null) {
                return null;
            }
            Field field = thisObject.referenceType().fieldByName(name);
            if (field == null) {
                return null;
            }
            RemoteValue value = this.resolveValue(thisObject.getValue(field));
            value.setReference(new LReference.InstanceVariable(this, thisObject, field));
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RemoteValue staticValue(String name) {
        try {
            ReferenceType ref = this.stackFrame.location().declaringType();
            return this.staticValue(ref, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private RemoteValue staticValue(ReferenceType ref, String name) {
        try {
            Field field = ref.fieldByName(name);
            if (field == null || !field.isStatic()) {
                if (name.equals("class")) {
                    return this.resolveValue(ref.classObject());
                }
                return null;
            }
            RemoteValue value = this.resolveValue(ref.getValue(field));
            value.setReference(new LReference.StaticVariable(this, ref, field));
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RemoteValue field(RemoteValue.Object object, String fieldName) throws EvaluateException {
        try {
            ObjectReference ref = object.reference();
            if (ref instanceof ArrayReference) {
                if (fieldName.equals("length")) {
                    return new RemoteValue.Integer(((ArrayReference)ref).length());
                }
                PValue.error("CTL_Unknown_field_name", fieldName);
                return null;
            }
            ReferenceType refType = ref.referenceType();
            Field field = refType.fieldByName(fieldName);
            if (field == null) {
                PValue.error("CTL_Unknown_field_name", fieldName);
                return null;
            }
            RemoteValue value = this.resolveValue(ref.getValue(field));
            value.setReference(new LReference.InstanceVariable(this, ref, field));
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RemoteValue itemOfArray(RemoteValue.Array array, int index) throws EvaluateException {
        ArrayReference ref = (ArrayReference)array.reference();
        if (index < 0 || index >= ref.length()) {
            PValue.error("CTL_Array_index_out_of_bounds", new Integer(index));
            return null;
        }
        RemoteValue value = this.resolveValue(ref.getValue(index));
        value.setReference(new LReference.ArrayItem(this, ref, index));
        return value;
    }

    public RemoteValue invokeMethod(RemoteValue.Object object, String typeName, String methodName, List args) throws EvaluateException {
        ObjectReference objectRef = null;
        ReferenceType ref = null;
        if (object == null) {
            if (typeName != null) {
                ref = this.resolveTypeName(typeName, true);
                if (ref == null) {
                    PValue.error("CTL_Unknown_identifier", typeName);
                    return null;
                }
            } else {
                objectRef = this.stackFrame.thisObject();
                if (objectRef == null) {
                    ref = this.stackFrame.location().declaringType();
                }
            }
        } else {
            objectRef = object.reference();
        }
        if (objectRef != null) {
            ref = objectRef.referenceType();
        }
        if (!(ref instanceof ClassType)) {
            PValue.error("CTL_Cannot_invoke_method_on_array", methodName);
            return null;
        }
        ClassType classType = (ClassType)ref;
        List<Method> list = classType.methodsByName(methodName);
        if (list.size() == 0) {
            PValue.error("CTL_No_method_found", methodName);
            return null;
        }
        ArrayList<Value> argValues = new ArrayList<Value>();
        Value result = null;
        int x = 0;
        while (x < args.size()) {
            RemoteValue tempValue = (RemoteValue)args.get(x);
            if (tempValue instanceof RemoteValue.Void) {
                PValue.error("CTL_Void_value_cannot_be_passed", methodName);
                return null;
            }
            if (tempValue instanceof RemoteValue.Null) {
                argValues.add(null);
            } else {
                argValues.add(this.mirrorOf((RemoteValue)args.get(x)));
            }
            ++x;
        }
        Method method = this.mostSpecificMethod(list, argValues);
        if (method == null) {
            PValue.error("CTL_No_method_matches_parameters", methodName);
            return null;
        }
        try {
            result = objectRef != null ? objectRef.invokeMethod(this.threadReference, method, argValues, 1) : classType.invokeMethod(this.threadReference, method, argValues, 1);
        }
        catch (InvocationException e) {
            String exceptionName = e.exception().referenceType().name();
            PValue.error("CTL_Method_has_thrown_exception", methodName, exceptionName);
            return null;
        }
        catch (Exception e) {
            PValue.error("CTL_Exception_during_method_invocation", methodName, e.getClass().getName());
            return null;
        }
        try {
            this.stackFrame = this.threadReference.frame(this.frame);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.resolveValue(result);
    }

    public RemoteValue.Object createNewObject(String typeName, List args) throws EvaluateException {
        ReferenceType ref = this.resolveTypeName(typeName, true);
        if (ref == null) {
            PValue.error("CTL_Unknown_identifier", typeName);
            return null;
        }
        if (ref instanceof InterfaceType) {
            PValue.error("CTL_Cannot_create_instance_of_interface", typeName);
            return null;
        }
        if (ref instanceof ArrayType) {
            PValue.error("CTL_Array_creation_not_supported", typeName);
            return null;
        }
        List<Method> list = ref.methodsByName("<init>");
        ArrayList<Value> argValues = new ArrayList<Value>();
        ObjectReference result = null;
        int x = 0;
        while (x < args.size()) {
            RemoteValue tempValue = (RemoteValue)args.get(x);
            if (tempValue instanceof RemoteValue.Void) {
                PValue.error("CTL_Void_value_cannot_be_passed_to_constructor", typeName);
                return null;
            }
            if (tempValue instanceof RemoteValue.Null) {
                argValues.add(null);
            } else {
                argValues.add(this.mirrorOf((RemoteValue)args.get(x)));
            }
            ++x;
        }
        Method constructor = this.mostSpecificMethod(list, argValues);
        if (constructor == null) {
            PValue.error("CTL_No_constructor_matches_parameters", typeName);
            return null;
        }
        try {
            result = ((ClassType)ref).newInstance(this.threadReference, constructor, argValues, 1);
        }
        catch (InvocationException e) {
            String exceptionName = e.exception().referenceType().name();
            PValue.error("CTL_Constructor_has_thrown_exception", typeName, exceptionName);
            return null;
        }
        catch (Exception e) {
            PValue.error("CTL_Exception_during_constructor_invocation", typeName, e.getClass().getName());
            return null;
        }
        try {
            this.stackFrame = this.threadReference.frame(this.frame);
        }
        catch (Exception e) {
            // empty catch block
        }
        return (RemoteValue.Object)this.resolveValue(result);
    }

    public boolean isInstanceOf(RemoteValue desc, String succName) throws EvaluateException {
        ReferenceType succRef = this.resolveTypeName(succName, true);
        if (succRef == null) {
            PValue.error("CTL_Unknown_identifier", succName);
            return false;
        }
        if (desc instanceof RemoteValue.Null) {
            return true;
        }
        if (!(desc instanceof RemoteValue.Object)) {
            PValue.error("CTL_First_operand_not_instance", desc.typeName());
            return false;
        }
        ReferenceType descRef = ((RemoteValue.Object)desc).reference().referenceType();
        if (!(descRef instanceof ClassType)) {
            return descRef instanceof ArrayType && succRef.name().equals("java.lang.Object");
        }
        return this.resolveInstanceOf((ClassType)descRef, succRef);
    }

    private boolean resolveInstanceOf(ClassType desc, ReferenceType succ) {
        ClassType ref = desc;
        boolean found = false;
        while (ref != null) {
            if (succ.equals(ref)) {
                return true;
            }
            ref = ref.superclass();
        }
        List<InterfaceType> list = desc.allInterfaces();
        int x = 0;
        while (x < list.size()) {
            if (succ.equals(list.get(x))) {
                return true;
            }
            ++x;
        }
        return false;
    }

    private ReferenceType resolveTypeName(String typeName, boolean useImports) {
        try {
            List<ReferenceType> list = this.vm.classesByName(typeName);
            if (list.size() == 0 && useImports) {
                int x = 0;
                while (x < this.imports.size()) {
                    String packageName = (String)this.imports.get(x);
                    list = this.vm.classesByName(packageName + "." + typeName);
                    if (list.size() != 0) break;
                    ++x;
                }
            }
            if (list.size() == 0) {
                return null;
            }
            ReferenceType ref = list.get(0);
            if (list.size() > 1) {
                ClassLoaderReference clsLoader = this.stackFrame.location().declaringType().classLoader();
                int x = 0;
                while (x < list.size()) {
                    ReferenceType tempRef = list.get(x);
                    if (clsLoader == tempRef.classLoader()) {
                        ref = tempRef;
                        break;
                    }
                    ++x;
                }
            }
            return ref;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method mostSpecificMethod(List methods, List params) {
        Method chosenMethod = null;
        List<Type> chosenArgs = null;
        try {
            int y;
            ArrayList<Method> candidateMethods = new ArrayList<Method>();
            int x = 0;
            while (x < methods.size()) {
                block14: {
                    List<Type> args;
                    Method method = (Method)methods.get(x);
                    try {
                        args = method.argumentTypes();
                    }
                    catch (Exception e) {
                        break block14;
                    }
                    if (!method.isAbstract() && args.size() == params.size()) {
                        boolean assignable = true;
                        int length = args.size();
                        y = 0;
                        while (y < length) {
                            if (!this.isAssignable((Value)params.get(y), args.get(y))) {
                                assignable = false;
                                break;
                            }
                            ++y;
                        }
                        if (assignable) {
                            candidateMethods.add(method);
                        }
                    }
                }
                ++x;
            }
            if (candidateMethods.size() == 0) {
                return null;
            }
            chosenMethod = (Method)candidateMethods.get(0);
            chosenArgs = chosenMethod.argumentTypes();
            int x2 = 1;
            while (x2 < candidateMethods.size()) {
                Method method = (Method)candidateMethods.get(x2);
                List<Type> args = method.argumentTypes();
                boolean assignable = true;
                y = 0;
                while (y < args.size()) {
                    if (!this.isAssignable(args.get(y), chosenArgs.get(y))) {
                        assignable = false;
                        break;
                    }
                    ++y;
                }
                if (assignable) {
                    chosenMethod = method;
                    chosenArgs = args;
                }
                ++x2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return chosenMethod;
    }

    private static int indexOfPrimitiveType(PrimitiveType type) {
        if (type instanceof IntegerType) {
            return 3;
        }
        if (type instanceof LongType) {
            return 4;
        }
        if (type instanceof FloatType) {
            return 5;
        }
        if (type instanceof DoubleType) {
            return 6;
        }
        if (type instanceof CharType) {
            return 2;
        }
        if (type instanceof ShortType) {
            return 2;
        }
        if (type instanceof ByteType) {
            return 1;
        }
        return 0;
    }

    private boolean isAssignable(Value value, Type dest) {
        if (value == null) {
            return !(dest instanceof PrimitiveType);
        }
        return this.isAssignable(value.type(), dest);
    }

    private boolean isAssignable(Type param, Type dest) {
        if (param instanceof PrimitiveType) {
            int index2;
            if (!(dest instanceof PrimitiveType)) {
                return false;
            }
            if (param instanceof BooleanType || dest instanceof BooleanType) {
                return param instanceof BooleanType && dest instanceof BooleanType;
            }
            int index1 = VMEngine.indexOfPrimitiveType((PrimitiveType)param);
            return index1 < (index2 = VMEngine.indexOfPrimitiveType((PrimitiveType)dest)) || index1 == index2 && param.equals(dest);
        }
        if (!(dest instanceof ReferenceType)) {
            return false;
        }
        if (param instanceof ArrayType) {
            return param.equals(dest) || dest.name().equals("java.lang.Object");
        }
        return this.resolveInstanceOf((ClassType)param, (ReferenceType)dest);
    }

    public RemoteValue.String stringToObject(String s) {
        return new RemoteValue.String(this.vm.mirrorOf(s));
    }

    public String toStringValue(RemoteValue.Object object) throws EvaluateException {
        RemoteValue value = this.invokeMethod(object, null, "toString", new ArrayList());
        if (value instanceof RemoteValue.Null) {
            return null;
        }
        StringReference ref = (StringReference)((RemoteValue.String)value).reference();
        return ref.value();
    }

    public boolean instancesEquals(RemoteValue.Object o1, RemoteValue.Object o2) {
        return o1.reference().equals(o2.reference());
    }

    public RemoteValue resolveValue(Value value) {
        if (value instanceof ObjectReference) {
            if (value instanceof ArrayReference) {
                return new RemoteValue.Array((ArrayReference)value);
            }
            if (value instanceof StringReference) {
                return new RemoteValue.String((StringReference)value);
            }
            return new RemoteValue.Object((ObjectReference)value);
        }
        if (value instanceof BooleanValue) {
            return new RemoteValue.Boolean(((BooleanValue)value).value());
        }
        if (value instanceof IntegerValue) {
            return new RemoteValue.Integer(((IntegerValue)value).value());
        }
        if (value instanceof LongValue) {
            return new RemoteValue.Long(((LongValue)value).value());
        }
        if (value instanceof FloatValue) {
            return new RemoteValue.Float(((FloatValue)value).value());
        }
        if (value instanceof DoubleValue) {
            return new RemoteValue.Double(((DoubleValue)value).value());
        }
        if (value instanceof ShortValue) {
            return new RemoteValue.Short(((ShortValue)value).value());
        }
        if (value instanceof ByteValue) {
            return new RemoteValue.Byte(((ByteValue)value).value());
        }
        if (value instanceof CharValue) {
            return new RemoteValue.Character(((CharValue)value).value());
        }
        if (value instanceof VoidValue) {
            return new RemoteValue.Void();
        }
        if (value == null) {
            return new RemoteValue.Null();
        }
        return null;
    }

    public Value mirrorOf(RemoteValue value) {
        if (value instanceof RemoteValue.Integer) {
            return this.vm.mirrorOf(((RemoteValue.Integer)value).intValue());
        }
        if (value instanceof RemoteValue.Long) {
            return this.vm.mirrorOf(((RemoteValue.Long)value).longValue());
        }
        if (value instanceof RemoteValue.Byte) {
            return this.vm.mirrorOf(((RemoteValue.Byte)value).byteValue());
        }
        if (value instanceof RemoteValue.Short) {
            return this.vm.mirrorOf(((RemoteValue.Short)value).shortValue());
        }
        if (value instanceof RemoteValue.Float) {
            return this.vm.mirrorOf(((RemoteValue.Float)value).floatValue());
        }
        if (value instanceof RemoteValue.Double) {
            return this.vm.mirrorOf(((RemoteValue.Double)value).doubleValue());
        }
        if (value instanceof RemoteValue.Character) {
            return this.vm.mirrorOf(((RemoteValue.Character)value).charValue());
        }
        if (value instanceof RemoteValue.Boolean) {
            return this.vm.mirrorOf(((RemoteValue.Boolean)value).booleanValue());
        }
        if (value instanceof RemoteValue.Object) {
            return ((RemoteValue.Object)value).reference();
        }
        return null;
    }
}

