/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.util.Executor;

public class Operator {
    private boolean resume = false;
    private boolean stopRequest = false;
    private boolean disconnected = false;
    private Thread thread;

    public Operator(final VirtualMachine virtualMachine, final JPDADebugger debugger, final Runnable starter, final Runnable finalizer) {
        this.thread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                EventQueue queue = virtualMachine.eventQueue();
                try {
                    while (true) {
                        EventSet set = queue.remove();
                        JPDADebugger jPDADebugger = debugger;
                        synchronized (jPDADebugger) {
                            Operator.this.resume = false;
                            Operator.this.stopRequest = false;
                            EventIterator i = set.eventIterator();
                            while (i.hasNext()) {
                                Event e = i.nextEvent();
                                if (e instanceof VMDeathEvent || e instanceof VMDisconnectEvent) {
                                    Operator.this.disconnected = true;
                                    if (finalizer != null) {
                                        finalizer.run();
                                    }
                                    return;
                                }
                                if (e instanceof VMStartEvent && starter != null) {
                                    starter.run();
                                    continue;
                                }
                                Executor exec = null;
                                if (e.request() != null) {
                                    exec = (Executor)e.request().getProperty("executor");
                                }
                                if (exec == null) continue;
                                try {
                                    exec.exec(e);
                                }
                                catch (VMDisconnectedException exc) {
                                    Operator.this.disconnected = true;
                                    if (finalizer != null) {
                                        finalizer.run();
                                    }
                                    return;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (Operator.this.resume && !Operator.this.stopRequest) {
                                virtualMachine.resume();
                            }
                        }
                    }
                }
                catch (VMDisconnectedException e) {
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (finalizer != null) {
                    finalizer.run();
                }
            }
        }, "Debugger operator thread");
    }

    public void start() {
        this.thread.start();
    }

    public void register(EventRequest req, Executor e) {
        req.putProperty("executor", e);
    }

    public void unregister(EventRequest req) {
        req.putProperty("executor", null);
    }

    public void resume() {
        this.resume = true;
    }

    public void destroy() {
        this.thread = null;
    }

    public void stopRequest() {
        this.stopRequest = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    private void printEvent(Event e, Executor exec) {
        try {
            if (e instanceof ClassPrepareEvent) {
                System.out.println("EVENT: ClassPrepareEvent " + ((ClassPrepareEvent)e).referenceType());
            } else if (e instanceof ClassUnloadEvent) {
                System.out.println("EVENT: ClassUnloadEvent " + ((ClassUnloadEvent)e).className());
            } else if (e instanceof ThreadStartEvent) {
                try {
                    System.out.println("EVENT: ThreadStartEvent " + ((ThreadStartEvent)e).thread());
                }
                catch (Exception ex) {
                    System.out.println("EVENT: ThreadStartEvent1 " + e);
                }
            } else if (e instanceof ThreadDeathEvent) {
                try {
                    System.out.println("EVENT: ThreadDeathEvent " + ((ThreadDeathEvent)e).thread());
                }
                catch (Exception ex) {
                    System.out.println("EVENT: ThreadDeathEvent1 " + e);
                }
            } else if (!(e instanceof MethodEntryEvent) && !(e instanceof BreakpointEvent)) {
                if (e instanceof StepEvent) {
                    System.out.println("EVENT: BreakpointEvent " + ((StepEvent)e).thread() + " : " + ((StepEvent)e).location());
                } else {
                    System.out.println("EVENT: " + e + " : " + exec);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

