/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.InternalException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.LinkedList;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;

public class Requestor {
    private LinkedList requests = new LinkedList();
    private EventRequestManager requestManager;
    private Operator operator;
    private Executor listener;

    public Requestor(EventRequestManager requestManager, Operator operator, Executor listener) {
        this.requestManager = requestManager;
        this.operator = operator;
        this.listener = listener;
    }

    public int size() {
        return this.requests.size();
    }

    public void add(EventRequest r) {
        this.requests.add(r);
        this.operator.register(r, this.listener);
    }

    public void removeRequests() {
        if (this.requests.size() == 0) {
            return;
        }
        int k = this.requests.size();
        try {
            int i = 0;
            while (i < k) {
                EventRequest r = (EventRequest)this.requests.get(i);
                this.requestManager.deleteEventRequest(r);
                this.operator.unregister(r);
                ++i;
            }
        }
        catch (VMDisconnectedException e) {
        }
        catch (InternalException e) {
            // empty catch block
        }
        this.requests = new LinkedList();
    }
}

