/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Utils
extends org.netbeans.modules.debugger.support.util.Utils {
    public static List anonymousInnerClasses(String outerClazzName, List refTypes) {
        if (outerClazzName == null) {
            throw new IllegalArgumentException("outerClazzName == null");
        }
        if (refTypes == null) {
            throw new IllegalArgumentException("refTypes == null");
        }
        if (refTypes.isEmpty()) {
            return refTypes;
        }
        if (outerClazzName.trim().length() == 0) {
            return Collections.EMPTY_LIST;
        }
        String mandatoryPrefix = outerClazzName + '$';
        int mandatoryPrefixLength = mandatoryPrefix.length();
        ArrayList<ReferenceType> resultList = new ArrayList<ReferenceType>(refTypes.size());
        Iterator i = refTypes.iterator();
        while (i.hasNext()) {
            ReferenceType refType = (ReferenceType)i.next();
            String refTypeName = refType.name();
            if (refTypeName.length() <= mandatoryPrefixLength || !refTypeName.startsWith(mandatoryPrefix) || Character.isJavaIdentifierStart(refTypeName.charAt(mandatoryPrefixLength))) continue;
            resultList.add(refType);
        }
        if (resultList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return resultList;
    }

    public static void showMethods(ReferenceType rt) {
        System.out.println("  ============================================");
        System.out.println("  Methods for " + rt.name());
        List<Method> l = rt.methods();
        int k = l.size();
        int i = 0;
        while (i < k) {
            System.out.println(l.get(i).name() + " ; " + l.get(i).signature());
            ++i;
        }
        System.out.println("  ============================================");
    }

    public static void showLinesForClass(ReferenceType rt) {
        System.out.println("  ============================================");
        System.out.println("  Lines for " + rt.name());
        List<Location> l = null;
        try {
            l = rt.allLineLocations();
        }
        catch (AbsentInformationException e) {
            // empty catch block
        }
        int k = l.size();
        int i = 0;
        while (i < k) {
            System.out.println("   " + l.get(i).lineNumber() + " : " + l.get(i).codeIndex());
            ++i;
        }
        System.out.println("  ============================================");
    }

    public static void showRequests(EventRequestManager requestManager) {
        System.out.println("  ============================================");
        List<EventRequest> l = requestManager.breakpointRequests();
        System.out.println("  Break request: " + l.size());
        int k = l.size();
        int i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.classPrepareRequests();
        System.out.println("  Class prepare request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.accessWatchpointRequests();
        System.out.println("  Access watch request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.classUnloadRequests();
        System.out.println("  Class unload request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.exceptionRequests();
        System.out.println("  Exception request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.methodEntryRequests();
        System.out.println("  Method entry request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.methodExitRequests();
        System.out.println("  Method exit request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.modificationWatchpointRequests();
        System.out.println("  Modif watch request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.stepRequests();
        System.out.println("  Step request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.threadDeathRequests();
        System.out.println("  Thread death entry request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        l = requestManager.threadStartRequests();
        System.out.println("  Thread start request: " + l.size());
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println("    " + l.get(i));
            ++i;
        }
        System.out.println("  ============================================");
    }

    public static void showConnectors(List l) {
        int k = l.size();
        int i = 0;
        while (i < k) {
            Utils.showConnector((Connector)l.get(i));
            ++i;
        }
    }

    public static void showConnector(Connector connector) {
        System.out.println("  ============================================");
        System.out.println("  Connector: " + connector);
        System.out.println("    name: " + connector.name());
        System.out.println("    description: " + connector.description());
        System.out.println("    transport: " + connector.transport().name());
        Utils.showProperties(connector.defaultArguments());
        System.out.println("  ============================================");
    }

    public static void showThread(ThreadReference tr) {
        System.out.println("  ============================================");
        try {
            System.out.println("  Thread: " + tr.name());
        }
        catch (Exception e) {
            System.out.println("  Thread: " + e);
        }
        try {
            System.out.println("    status: " + tr.status());
        }
        catch (Exception e) {
            System.out.println("    status: " + e);
        }
        try {
            System.out.println("    isSuspended: " + tr.isSuspended());
        }
        catch (Exception e) {
            System.out.println("    isSuspended: " + e);
        }
        try {
            System.out.println("    frameCount: " + tr.frameCount());
        }
        catch (Exception e) {
            System.out.println("    frameCount: " + e);
        }
        try {
            System.out.println("    location: " + tr.frame(0));
        }
        catch (Exception e) {
            System.out.println("    location: " + e);
        }
        System.out.println("  ============================================");
    }

    private static void showProperties(Map properties) {
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            Object k = i.next();
            Connector.Argument a = (Connector.Argument)properties.get(k);
            System.out.println("    property: " + k + " > " + a.name());
            System.out.println("      desc: " + a.description());
            System.out.println("      mustSpecify: " + a.mustSpecify());
            System.out.println("      value: " + a.value());
        }
    }

    public static void listGroup(String s, ThreadGroupReference g) {
        List<ObjectReference> l = g.threadGroups();
        int k = l.size();
        int i = 0;
        while (i < k) {
            System.out.println(s + "Thread Group: " + l.get(i) + " : " + ((ThreadGroupReference)l.get(i)).name());
            Utils.listGroup(s + "  ", (ThreadGroupReference)l.get(i));
            ++i;
        }
        l = g.threads();
        k = l.size();
        i = 0;
        while (i < k) {
            System.out.println(s + "Thread: " + l.get(i) + " : " + ((ThreadReference)l.get(i)).name());
            ++i;
        }
    }

    private static void listGroups(List g) {
        System.out.println("  ============================================");
        int k = g.size();
        int i = 0;
        while (i < k) {
            System.out.println("Thread Group: " + g.get(i) + " : " + ((ThreadGroupReference)g.get(i)).name());
            Utils.listGroup("  ", (ThreadGroupReference)g.get(i));
            ++i;
        }
        System.out.println("  ============================================");
    }
}

