/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.cookies;

import java.io.IOException;
import java.io.StringReader;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.schema.cookies.ShareableInputSource;
import org.netbeans.modules.xml.schema.cookies.Util;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ValidateSchemaSupport
extends ValidateXMLSupport {
    public ValidateSchemaSupport(InputSource inputSource) {
        super(inputSource);
    }

    protected XMLReader createParser(boolean validate) {
        String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
        XMLReader parser = super.createParser(validate);
        if (parser == null) {
            return null;
        }
        if (validate) {
            try {
                if (!parser.getFeature("http://apache.org/xml/features/validation/schema")) {
                    return null;
                }
                parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                return new SchemaChecker(parser);
            }
            catch (SAXException ex) {
                return null;
            }
        }
        return parser;
    }

    private static class SchemaChecker
    extends SAXEntityParser {
        private static String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
        private String ns = null;

        public SchemaChecker(XMLReader parser) {
            super(parser);
        }

        protected InputSource wrapInputSource(InputSource inputSource) {
            String targetNamespace = this.getTargetNamespace();
            String url = inputSource.getSystemId();
            StringBuffer buffer = new StringBuffer();
            String namespace = "http://www.w3.org/2001/XMLSchema-instance";
            buffer.append("<schemaWrapper xmlns:xsi='" + namespace + "' ");
            if (targetNamespace != null) {
                buffer.append("xmlns='" + targetNamespace + "' ");
                buffer.append("xsi:schemaLocation='" + targetNamespace + " " + url + "'/>");
            } else {
                buffer.append("xsi:noNamespaceSchemaLocation='" + url + "'/>");
            }
            StringReader reader = new StringReader(buffer.toString());
            InputSource input = new InputSource();
            input.setCharacterStream(reader);
            return input;
        }

        protected boolean propagateException(SAXParseException ex) {
            if (super.propagateException(ex)) {
                String message = ex.getMessage();
                if (message == null) {
                    return true;
                }
                if (this.getTargetNamespace() == null || message.indexOf(this.getTargetNamespace()) < 0) {
                    return message.indexOf("schemaWrapper") < 0;
                }
            }
            return false;
        }

        public void parse(InputSource input) throws SAXException, IOException {
            ShareableInputSource shared = ShareableInputSource.create(input);
            try {
                this.ns = this.parseForTargetNamespace(shared);
                shared.reset();
                super.parse((InputSource)shared);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                shared.closeAll();
                throw throwable;
            }
            shared.closeAll();
        }

        private String getTargetNamespace() {
            return this.ns;
        }

        private String parseForTargetNamespace(InputSource schema) throws SAXException, IOException {
            try {
                XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
                EntityResolver resolver = UserCatalog.getDefault().getEntityResolver();
                if (resolver != null) {
                    reader.setEntityResolver(resolver);
                }
                TargetNSScanner sniffer = new TargetNSScanner();
                reader.setContentHandler(sniffer);
                reader.setErrorHandler(sniffer);
                reader.parse(schema);
            }
            catch (Stop ex) {
                return ex.getNamespace();
            }
            return null;
        }

        private static class Stop
        extends SAXException {
            Stop(String ns) {
                super(ns);
            }

            String getNamespace() {
                return this.getMessage();
            }
        }

        private class TargetNSScanner
        extends DefaultHandler {
            private TargetNSScanner() {
            }

            public void startElement(String uri, String local, String qname, Attributes attrs) throws SAXException {
                if ("schema".equals(local) && SCHEMA_NS.equals(uri)) {
                    String targetNS = attrs.getValue("targetNamespace");
                    throw new Stop(targetNS);
                }
                throw new SAXException(Util.THIS.getString("MSG_missing_schema"));
            }
        }
    }
}

