/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.RegionException;
import org.netbeans.lib.terminalemulator.RegionManager;
import org.netbeans.lib.terminalemulator.StreamTerm;

public class ActiveTerm
extends StreamTerm {
    private ActiveTermListener at_listener;
    private RegionManager rm;
    private Coord last_begin = null;
    private Coord last_end = null;

    public ActiveTerm() {
        this.setCursorVisible(false);
        this.rm = this.regionManager();
        this.getCanvas().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    return;
                }
                Point p = ActiveTerm.this.mapToBufRowCol(e.getPoint());
                BCoord c = new BCoord(p.y, p.x);
                Coord ac = new Coord(c, ActiveTerm.this.firsta);
                ActiveRegion region = ActiveTerm.this.rm.findRegion(ac);
                if (region == null) {
                    // empty if block
                }
                if (region != null) {
                    if (region.isSelectable()) {
                        ActiveTerm.this.setSelectionExtent(region.getExtent());
                    }
                    if (ActiveTerm.this.at_listener != null) {
                        ActiveTerm.this.at_listener.action(region, e);
                    }
                }
            }
        });
        this.getCanvas().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                Point p = ActiveTerm.this.mapToBufRowCol(e.getPoint());
                BCoord c = new BCoord(p.y, p.x);
                Coord ac = new Coord(c, ActiveTerm.this.firsta);
                ActiveRegion region = ActiveTerm.this.rm.findRegion(ac);
                ActiveRegion hl_region = ActiveTerm.this.findRegionToHilite(region);
                if (hl_region == null) {
                    ActiveTerm.this.hilite(null, null);
                } else {
                    ActiveTerm.this.hilite(hl_region.begin, hl_region.end);
                }
            }
        });
    }

    private ActiveRegion findRegionToHilite(ActiveRegion region) {
        if (region == null) {
            return null;
        }
        if (region.isFeedbackEnabled()) {
            return region;
        }
        if (region.isFeedbackViaParent()) {
            return this.findRegionToHilite(region.parent());
        }
        return null;
    }

    public void setActionListener(ActiveTermListener listener) {
        this.at_listener = listener;
    }

    private void hilite_help(Coord begin, Coord end, boolean on) {
        if (begin == null && end == null) {
            return;
        }
        this.setCharacterAttribute(begin, end, 9, on);
    }

    public void hilite(Coord begin, Coord end) {
        if (end != null && end.row == 1 && end.col == 0) {
            end = this.getCursorCoord();
        }
        this.hilite_help(this.last_begin, this.last_end, false);
        this.last_begin = begin == null ? null : (Coord)begin.clone();
        this.last_end = end == null ? null : (Coord)end.clone();
        this.hilite_help(begin, end, true);
    }

    public void hilite(ActiveRegion region) {
        this.hilite(region.begin, region.end);
    }

    public ActiveRegion beginRegion(boolean hyperlink) {
        ActiveRegion region = null;
        try {
            region = this.rm.beginRegion(this.getCursorCoord());
        }
        catch (RegionException regionException) {
            // empty catch block
        }
        if (hyperlink) {
            this.setAttribute(34);
            this.setAttribute(4);
        }
        return region;
    }

    public void endRegion() {
        Coord cursor = this.getCursorCoord();
        Coord bcursor = this.backup(cursor);
        if (bcursor == null) {
            bcursor = cursor;
        }
        try {
            this.rm.endRegion(bcursor);
        }
        catch (RegionException regionException) {
            // empty catch block
        }
        this.setAttribute(0);
    }

    public ActiveRegion findRegion(Coord coord) {
        return this.rm.findRegion(coord);
    }

    public void cancelRegion() {
        try {
            this.rm.cancelRegion();
        }
        catch (RegionException regionException) {
            // empty catch block
        }
    }

    public void clear() {
        this.nullLasts();
        super.clear();
    }

    public void clearHistoryNoRefresh() {
        this.nullLasts();
        super.clearHistoryNoRefresh();
    }

    private void nullLasts() {
        this.last_begin = null;
        this.last_end = null;
    }
}

