/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.util.Vector;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.WordDelineator;

class Buffer {
    private OurVector lines = new OurVector();
    public int nlines;
    private int visible_cols;
    private int extra_cols;

    public int visibleCols() {
        return this.visible_cols;
    }

    public int totalCols() {
        return this.visible_cols + this.extra_cols;
    }

    public Buffer(int visible_cols) {
        this.visible_cols = visible_cols;
    }

    public void setVisibleCols(int visible_cols) {
        int delta = visible_cols - this.visible_cols;
        this.visible_cols = visible_cols;
        this.extra_cols -= delta;
        if (this.extra_cols < 0) {
            this.extra_cols = 0;
        }
    }

    public void noteColumn(int col) {
        int new_extra = col - this.visible_cols;
        if (new_extra > this.extra_cols) {
            this.extra_cols = new_extra;
        }
    }

    Line lineAt(int brow) {
        try {
            return (Line)this.lines.elementAt(brow);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return null;
        }
    }

    Line bottom() {
        return this.lineAt(this.nlines);
    }

    public Line appendLine() {
        Line l = new Line();
        this.lines.add(l);
        ++this.nlines;
        return l;
    }

    public Line addLineAt(int row) {
        Line l = new Line();
        this.lines.add(row, l);
        ++this.nlines;
        return l;
    }

    public int removeLinesAt(int row, int n) {
        int nchars = 0;
        int r = row;
        while (r < row + n) {
            nchars += this.lineAt(r).length() + 1;
            ++r;
        }
        this.lines.removeRange(row, row + n);
        this.nlines -= n;
        return nchars;
    }

    public void removeLineAt(int row) {
        this.lines.remove(row);
        --this.nlines;
    }

    public Line moveLineFromTo(int from, int to) {
        Line l = (Line)this.lines.remove(from);
        this.lines.add(to, l);
        return l;
    }

    void visitLines(BCoord begin, BCoord end, boolean newlines, LineVisitor visitor) {
        if (begin.row == end.row) {
            Line l = this.lineAt(begin.row);
            visitor.visit(l, begin.row, begin.col, end.col);
        } else {
            boolean cont = false;
            Line l = this.lineAt(begin.row);
            cont = newlines && !l.isWrapped() ? visitor.visit(l, begin.row, begin.col, this.totalCols()) : visitor.visit(l, begin.row, begin.col, l.length() - 1);
            if (!cont) {
                return;
            }
            int r = begin.row + 1;
            while (r < end.row) {
                l = this.lineAt(r);
                cont = newlines && !l.isWrapped() ? visitor.visit(l, r, 0, this.totalCols()) : visitor.visit(l, r, 0, l.length() - 1);
                if (!cont) {
                    return;
                }
                ++r;
            }
            l = this.lineAt(end.row);
            cont = visitor.visit(l, end.row, 0, end.col);
            if (!cont) {
                return;
            }
        }
    }

    void reverseVisitLines(BCoord begin, BCoord end, boolean newlines, LineVisitor visitor) {
        if (begin.row == end.row) {
            Line l = this.lineAt(begin.row);
            visitor.visit(l, begin.row, begin.col, end.col);
        } else {
            boolean cont = false;
            Line l = this.lineAt(end.row);
            cont = visitor.visit(l, end.row, 0, end.col);
            if (!cont) {
                return;
            }
            int r = end.row - 1;
            while (r > begin.row) {
                l = this.lineAt(r);
                cont = newlines && !l.isWrapped() ? visitor.visit(l, r, 0, this.totalCols()) : visitor.visit(l, r, 0, l.length() - 1);
                if (!cont) {
                    return;
                }
                --r;
            }
            l = this.lineAt(begin.row);
            cont = newlines && !l.isWrapped() ? visitor.visit(l, begin.row, begin.col, this.totalCols()) : visitor.visit(l, begin.row, begin.col, l.length() - 1);
            if (!cont) {
                return;
            }
        }
    }

    public BExtent find_word(WordDelineator word_delineator, BCoord coord) {
        Line l = this.lineAt(coord.row);
        if (coord.col >= l.length()) {
            return new BExtent(coord, coord);
        }
        int lx = word_delineator.findLeft(l.stringBuffer(), coord.col);
        int rx = word_delineator.findRight(l.stringBuffer(), coord.col);
        return new BExtent(new BCoord(coord.row, lx), new BCoord(coord.row, rx));
    }

    public BCoord backup(BCoord c) {
        if (c.col > 0) {
            return new BCoord(c.row, c.col - 1);
        }
        int prevrow = c.row - 1;
        while (prevrow >= 0) {
            Line l = this.lineAt(prevrow);
            if (l.length() != 0) {
                return new BCoord(prevrow, l.length() - 1);
            }
            --prevrow;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public BCoord advance(BCoord c) {
        row = c.row;
        col = c.col;
        l = this.lineAt(row);
        if (++col >= l.length()) ** GOTO lbl9
        return new BCoord(row, col);
lbl-1000:
        // 1 sources

        {
            l = this.lineAt(row);
            if (l.length() == 0) continue;
            return new BCoord(row, 0);
lbl9:
            // 2 sources

            ** while (++row < this.nlines)
        }
lbl10:
        // 1 sources

        return null;
    }

    public void printStats() {
        int nchars = 0;
        int ncapacity = 0;
        int lx = 0;
        while (lx < this.nlines) {
            Line l = this.lineAt(lx);
            ncapacity += l.capacity();
            nchars += l.length();
            ++lx;
        }
        System.out.println("  nlines " + this.nlines + "  nchars " + nchars + "  ncapacity " + ncapacity);
    }

    class OurVector
    extends Vector {
        OurVector() {
        }

        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

