/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.InterpDumb;
import org.netbeans.lib.terminalemulator.Ops;

public class InterpANSI
extends InterpDumb {
    private InterpTypeANSI type;
    public static final InterpTypeANSI type_singleton = new InterpTypeANSI();

    public InterpANSI(Ops ops) {
        super(ops, type_singleton);
        this.type = type_singleton;
        this.setup();
    }

    protected InterpANSI(Ops ops, InterpTypeANSI type) {
        super(ops, type);
        this.type = type;
        this.setup();
    }

    public String name() {
        return "ansi";
    }

    public void reset() {
        super.reset();
    }

    private void setup() {
        this.state = this.type.st_base;
    }

    protected static class InterpTypeANSI
    extends InterpDumb.InterpTypeDumb {
        protected final AbstractInterp.State st_esc = new AbstractInterp.State("esc");
        protected final AbstractInterp.State st_esc_lb = new AbstractInterp.State("esc_lb");
        protected final AbstractInterp.Actor act_reset_number = new ACT_RESET_NUMBER();
        protected final AbstractInterp.Actor act_remember_digit = new ACT_REMEMBER_DIGIT();

        protected InterpTypeANSI() {
            this.st_base.setAction('\u001b', this.st_esc, new ACT_TO_ESC());
            this.st_esc.setRegular(this.st_esc, this.act_regular);
            this.st_esc.setAction('7', this.st_base, new ACT_SC());
            this.st_esc.setAction('8', this.st_base, new ACT_RC());
            this.st_esc.setAction('c', this.st_base, new ACT_FULL_RESET());
            this.st_esc.setAction('[', this.st_esc_lb, this.act_reset_number);
            this.st_esc_lb.setRegular(this.st_esc_lb, this.act_regular);
            char c = '0';
            while (c <= '9') {
                this.st_esc_lb.setAction(c, this.st_esc_lb, this.act_remember_digit);
                c = (char)(c + '\u0001');
            }
            this.st_esc_lb.setAction(';', this.st_esc_lb, new ACT_PUSH_NUMBER());
            this.st_esc_lb.setAction('A', this.st_base, new ACT_UP());
            this.st_esc_lb.setAction('B', this.st_base, new ACT_DO());
            this.st_esc_lb.setAction('C', this.st_base, new ACT_ND());
            this.st_esc_lb.setAction('D', this.st_base, new ACT_BC());
            this.st_esc_lb.setAction('H', this.st_base, new ACT_HO());
            this.st_esc_lb.setAction('i', this.st_base, new ACT_PRINT());
            this.st_esc_lb.setAction('J', this.st_base, new ACT_J());
            this.st_esc_lb.setAction('K', this.st_base, new ACT_K());
            this.st_esc_lb.setAction('L', this.st_base, new ACT_AL());
            this.st_esc_lb.setAction('M', this.st_base, new ACT_DL());
            this.st_esc_lb.setAction('m', this.st_base, new ACT_ATTR());
            this.st_esc_lb.setAction('n', this.st_base, new ACT_DSR());
            this.st_esc_lb.setAction('P', this.st_base, new ACT_DC());
            this.st_esc_lb.setAction('h', this.st_base, new ACT_SM());
            this.st_esc_lb.setAction('l', this.st_base, new ACT_RM());
            this.st_esc_lb.setAction('r', this.st_base, new ACT_MARGIN());
            this.st_esc_lb.setAction('t', this.st_base, new ACT_GLYPH());
            this.st_esc_lb.setAction('@', this.st_base, new ACT_IC());
        }

        protected final class ACT_GLYPH
        implements AbstractInterp.Actor {
            protected ACT_GLYPH() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    return "ACT GLYPH: missing number";
                }
                int p1 = ai.numberAt(0);
                int p2 = ai.numberAt(1);
                int p3 = ai.numberAt(2);
                if (p1 != 22) {
                    return "ACT GLYPH: op othger than 22 not supported";
                }
                ai.ops.op_glyph(p2, p3);
                return null;
            }
        }

        protected final class ACT_DSR
        implements AbstractInterp.Actor {
            protected ACT_DSR() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_status_report(5);
                } else {
                    ai.ops.op_status_report(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_ATTR
        implements AbstractInterp.Actor {
            protected ACT_ATTR() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_attr(0);
                } else {
                    int n = 0;
                    while (n <= ai.nNumbers()) {
                        ai.ops.op_attr(ai.numberAt(n));
                        ++n;
                    }
                }
                return null;
            }
        }

        protected final class ACT_AL
        implements AbstractInterp.Actor {
            protected ACT_AL() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_al(1);
                } else {
                    ai.ops.op_al(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_K
        implements AbstractInterp.Actor {
            protected ACT_K() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_ce();
                } else {
                    int count = ai.numberAt(0);
                    if (count == 1) {
                        return "ACT K: count of 1 not supported";
                    }
                    if (count == 2) {
                        return "ACT K: count of 2 not supported";
                    }
                }
                return null;
            }
        }

        protected final class ACT_J
        implements AbstractInterp.Actor {
            protected ACT_J() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_cd();
                } else {
                    int count = ai.numberAt(0);
                    if (count == 1) {
                        return "ACT J: count of 1 not supported";
                    }
                    if (count == 2) {
                        ai.ops.op_cl();
                    }
                }
                return null;
            }
        }

        protected final class ACT_PRINT
        implements AbstractInterp.Actor {
            protected ACT_PRINT() {
            }

            public String action(AbstractInterp ai, char c) {
                if (!ai.noNumber()) {
                    switch (ai.numberAt(0)) {
                        case 1: 
                        case 4: 
                        case 5: {
                            break;
                        }
                        case 10: {
                            ai.ops.op_time(true);
                            break;
                        }
                        case 11: {
                            ai.ops.op_time(false);
                        }
                    }
                }
                return null;
            }
        }

        protected final class ACT_HO
        implements AbstractInterp.Actor {
            protected ACT_HO() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_ho();
                } else {
                    ai.ops.op_cm(ai.numberAt(0), ai.numberAt(1));
                }
                return null;
            }
        }

        protected final class ACT_DL
        implements AbstractInterp.Actor {
            protected ACT_DL() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_dl(1);
                } else {
                    ai.ops.op_dl(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_IC
        implements AbstractInterp.Actor {
            protected ACT_IC() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_ic(1);
                } else {
                    ai.ops.op_ic(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_RM
        implements AbstractInterp.Actor {
            protected ACT_RM() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_reset_mode(1);
                } else {
                    ai.ops.op_reset_mode(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_SM
        implements AbstractInterp.Actor {
            protected ACT_SM() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_set_mode(1);
                } else {
                    ai.ops.op_set_mode(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_DC
        implements AbstractInterp.Actor {
            protected ACT_DC() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_dc(1);
                } else {
                    ai.ops.op_dc(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_MARGIN
        implements AbstractInterp.Actor {
            protected ACT_MARGIN() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_margin(0, 0);
                } else {
                    ai.ops.op_margin(ai.numberAt(0), ai.numberAt(1));
                }
                return null;
            }
        }

        protected final class ACT_BC
        implements AbstractInterp.Actor {
            protected ACT_BC() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_bc(1);
                } else {
                    ai.ops.op_bc(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_ND
        implements AbstractInterp.Actor {
            protected ACT_ND() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_nd(1);
                } else {
                    ai.ops.op_nd(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_DO
        implements AbstractInterp.Actor {
            protected ACT_DO() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_do(1);
                } else {
                    ai.ops.op_do(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_UP
        implements AbstractInterp.Actor {
            protected ACT_UP() {
            }

            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_up(1);
                } else {
                    ai.ops.op_up(ai.numberAt(0));
                }
                return null;
            }
        }

        protected final class ACT_PUSH_NUMBER
        implements AbstractInterp.Actor {
            protected ACT_PUSH_NUMBER() {
            }

            public String action(AbstractInterp ai, char c) {
                if (!ai.pushNumber()) {
                    return "ACT PUSH_NUMBER";
                }
                return null;
            }
        }

        protected class ACT_REMEMBER_DIGIT
        implements AbstractInterp.Actor {
            protected ACT_REMEMBER_DIGIT() {
            }

            public String action(AbstractInterp ai, char c) {
                ai.remember_digit(c);
                return null;
            }
        }

        protected class ACT_RESET_NUMBER
        implements AbstractInterp.Actor {
            protected ACT_RESET_NUMBER() {
            }

            public String action(AbstractInterp ai, char c) {
                ai.resetNumber();
                return null;
            }
        }

        protected final class ACT_FULL_RESET
        implements AbstractInterp.Actor {
            protected ACT_FULL_RESET() {
            }

            public String action(AbstractInterp ai, char c) {
                ai.ops.op_full_reset();
                return null;
            }
        }

        protected final class ACT_RC
        implements AbstractInterp.Actor {
            protected ACT_RC() {
            }

            public String action(AbstractInterp ai, char c) {
                ai.ops.op_rc();
                return null;
            }
        }

        protected final class ACT_SC
        implements AbstractInterp.Actor {
            protected ACT_SC() {
            }

            public String action(AbstractInterp ai, char c) {
                ai.ops.op_sc();
                return null;
            }
        }

        protected final class ACT_TO_ESC
        implements AbstractInterp.Actor {
            protected ACT_TO_ESC() {
            }

            public String action(AbstractInterp ai, char c) {
                InterpDumb i = (InterpDumb)ai;
                i.ctl_sequence = "";
                return null;
            }
        }
    }
}

