/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.Attr;
import org.netbeans.lib.terminalemulator.MyFontMetrics;
import org.netbeans.lib.terminalemulator.Term;

class Line {
    public int glyph_glyph;
    public int glyph_rendition;
    private char[] buf;
    private int[] attr;
    private int capacity;
    private int length;
    private boolean wrapped;
    private boolean about_to_wrap;

    public Line() {
        this.reset();
    }

    public void reset() {
        this.length = 0;
        this.capacity = 32;
        this.buf = new char[this.capacity];
        this.attr = null;
        this.glyph_glyph = 0;
        this.glyph_rendition = 0;
        this.wrapped = false;
        this.about_to_wrap = false;
    }

    public int capacity() {
        return this.capacity;
    }

    public int length() {
        return this.length;
    }

    public boolean hasAttributes() {
        return this.attr != null;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public boolean setAboutToWrap(boolean about_to_wrap) {
        boolean old_about_to_wrap = about_to_wrap;
        this.about_to_wrap = about_to_wrap;
        return old_about_to_wrap;
    }

    public boolean isAboutToWrap() {
        return this.about_to_wrap;
    }

    private boolean haveAttributes(int a) {
        if (this.attr == null && a != 0) {
            this.attr = new int[this.capacity];
        }
        return this.attr != null;
    }

    public char[] charArray() {
        return this.buf;
    }

    public int[] attrArray() {
        return this.attr;
    }

    public byte width(MyFontMetrics metrics, int at) {
        if (at >= this.capacity) {
            return 1;
        }
        return (byte)metrics.wcwidth(this.buf[at]);
    }

    public int cellToBuf(MyFontMetrics metrics, int target_col) {
        if (metrics.isMultiCell()) {
            byte w;
            int bc = 0;
            int vc = 0;
            while (vc + (w = this.width(metrics, bc)) - 1 < target_col) {
                vc += w;
                ++bc;
            }
            return bc;
        }
        return target_col;
    }

    public int bufToCell(MyFontMetrics metrics, int target_col) {
        if (metrics.isMultiCell()) {
            int vc = 0;
            int bc = 0;
            while (bc < target_col) {
                vc += this.width(metrics, bc);
                ++bc;
            }
            return vc;
        }
        return target_col;
    }

    public StringBuffer stringBuffer() {
        StringBuffer sb = new StringBuffer(this.length);
        return sb.append(this.buf, 0, this.length);
    }

    private void ensureCapacity(Term term, int min_capacity) {
        term.noteColumn(this, min_capacity);
        if (min_capacity <= this.capacity) {
            return;
        }
        int new_capacity = (this.length + 1) * 2;
        if (new_capacity < 0) {
            new_capacity = Integer.MAX_VALUE;
        } else if (min_capacity > new_capacity) {
            new_capacity = min_capacity;
        }
        char[] new_buf = new char[new_capacity];
        System.arraycopy(this.buf, 0, new_buf, 0, this.length);
        this.buf = new_buf;
        if (this.attr != null) {
            int[] new_attr = new int[new_capacity];
            System.arraycopy(this.attr, 0, new_attr, 0, this.length);
            this.attr = new_attr;
        }
        this.capacity = new_capacity;
    }

    public void insertCharAt(Term term, char c, int column, int a) {
        int new_length = this.length + 1;
        this.ensureCapacity(term, new_length);
        if (column >= this.length) {
            int fx = this.length;
            while (fx < column) {
                this.buf[fx] = 32;
                ++fx;
            }
        }
        System.arraycopy(this.buf, column, this.buf, column + 1, this.length - column);
        term.checkForMultiCell(c);
        this.buf[column] = c;
        if (this.haveAttributes(a)) {
            System.arraycopy(this.attr, column, this.attr, column + 1, this.length - column);
            this.attr[column] = a;
        }
        this.length = new_length;
    }

    public void setCharAt(Term term, char c, int column, int a) {
        if (column >= this.length) {
            this.ensureCapacity(term, column + 1);
            int fx = this.length;
            while (fx < column) {
                this.buf[fx] = 32;
                ++fx;
            }
            this.length = column + 1;
        }
        term.checkForMultiCell(c);
        this.buf[column] = c;
        if (this.haveAttributes(a)) {
            this.attr[column] = a;
        }
    }

    public void deleteCharAt(int column) {
        if (column < 0 || column >= this.length) {
            return;
        }
        System.arraycopy(this.buf, column + 1, this.buf, column, this.length - column - 1);
        this.buf[this.length - 1] = '\u0000';
        if (this.attr != null) {
            System.arraycopy(this.attr, column + 1, this.attr, column, this.length - column - 1);
            this.attr[this.length - 1] = 0;
        }
        --this.length;
    }

    public void clearToEndFrom(Term term, int col) {
        this.ensureCapacity(term, col + 1);
        int cx = col;
        while (cx < this.length) {
            this.buf[cx] = 32;
            ++cx;
        }
        if (this.attr != null) {
            int cx2 = col;
            while (cx2 < this.length) {
                this.attr[cx2] = 32;
                ++cx2;
            }
        }
        this.length = col;
    }

    public String text(int bcol, int ecol) {
        String newline = "";
        if (this.length == 0) {
            return "";
        }
        if (ecol >= this.length) {
            ecol = this.length - 1;
            newline = "\n";
            if (bcol >= this.length) {
                bcol = this.length - 1;
            }
        }
        return new String(this.buf, bcol, ecol - bcol + 1) + newline;
    }

    public void setCharacterAttribute(int bcol, int ecol, int value, boolean on) {
        if (!this.haveAttributes(value)) {
            return;
        }
        if (on) {
            int c = bcol;
            while (c <= ecol) {
                this.attr[c] = Attr.setAttribute(this.attr[c], value);
                ++c;
            }
        } else {
            int c = bcol;
            while (c <= ecol) {
                this.attr[c] = Attr.unsetAttribute(this.attr[c], value);
                ++c;
            }
        }
    }
}

