/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.Term;

class Screen
extends JComponent
implements Accessible {
    private Term term;
    private static final boolean debug = false;
    private AccessibleContext accessible_context;
    private AccessibleScreenText accessible_screen_text;
    private int oldPos;

    public Screen(Term term, int dx, int dy) {
        this.term = term;
        Dimension dim = new Dimension(dx, dy);
        this.setSize(dim);
        this.setPreferredSize(dim);
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void paint(Graphics g) {
        this.term.do_paint(g);
    }

    public Dimension getMaximumSize() {
        return new Dimension(1000, 1000);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessible_context == null) {
            this.accessible_context = new AccessibleScreen();
        }
        return this.accessible_context;
    }

    void possiblyUpdateCaretText() {
        if (this.accessible_screen_text == null) {
            return;
        }
        int pos = this.term.CoordToPosition(this.term.getCursorCoord());
        this.accessible_context.firePropertyChange("AccessibleText", null, new Integer(pos));
        this.accessible_context.firePropertyChange("AccessibleCaret", new Integer(pos), new Integer(this.oldPos));
        this.oldPos = pos;
    }

    protected class AccessibleScreen
    extends JComponent.AccessibleJComponent {
        protected AccessibleScreen() {
            super(Screen.this);
        }

        public String getAccessibleDescription() {
            return "Terminal emulator";
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            if (Screen.this.accessible_screen_text == null) {
                Screen.this.accessible_screen_text = new AccessibleScreenText();
            }
            return Screen.this.accessible_screen_text;
        }
    }

    protected class AccessibleScreenText
    implements AccessibleText {
        private int last_attr;
        private MutableAttributeSet last_as;

        AccessibleScreenText() {
        }

        public int getCaretPosition() {
            return Screen.this.term.CoordToPosition(Screen.this.term.getCursorCoord());
        }

        public AttributeSet getCharacterAttribute(int index) {
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(((Screen)Screen.this).term.firsta);
            int attr = 0;
            try {
                Line l = ((Screen)Screen.this).term.buf.lineAt(b.row);
                int[] attrs = l.attrArray();
                attr = attrs[b.col];
            }
            catch (Exception x) {
                // empty catch block
            }
            if (attr == this.last_attr) {
                return this.last_as;
            }
            SimpleAttributeSet as = new SimpleAttributeSet();
            if ((attr & 0x2000) == 8192) {
                as.addAttribute(StyleConstants.Underline, Boolean.TRUE);
            }
            if ((attr & 0x4000) == 16384) {
                as.addAttribute(StyleConstants.Bold, Boolean.TRUE);
            }
            boolean reverse = (attr & 0x800) == 2048;
            Color color = Screen.this.term.foregroundColor(reverse, attr);
            if (color != Color.black) {
                as.addAttribute(StyleConstants.Foreground, color);
            }
            if ((color = Screen.this.term.backgroundColor(reverse, attr)) != null) {
                as.addAttribute(StyleConstants.Background, color);
            }
            this.last_attr = attr;
            this.last_as = as;
            return as;
        }

        public Rectangle getCharacterBounds(int index) {
            return Screen.this.term.getCharacterBounds(Screen.this.term.PositionToCoord(index));
        }

        public int getCharCount() {
            return Screen.this.term.getCharCount();
        }

        public int getSelectionStart() {
            Extent x = Screen.this.term.getSelectionExtent();
            if (x == null) {
                return this.getCaretPosition();
            }
            return Screen.this.term.CoordToPosition(x.begin);
        }

        public int getSelectionEnd() {
            Extent x = Screen.this.term.getSelectionExtent();
            if (x == null) {
                return this.getCaretPosition();
            }
            return Screen.this.term.CoordToPosition(x.end);
        }

        public String getSelectedText() {
            return Screen.this.term.getSelectedText();
        }

        private String getHelper(int part, BCoord b) {
            if (b == null) {
                return null;
            }
            Line l = ((Screen)Screen.this).term.buf.lineAt(b.row);
            switch (part) {
                case 1: {
                    return new String(l.charArray(), b.col, 1);
                }
                case 2: {
                    BExtent bword = ((Screen)Screen.this).term.buf.find_word(((Screen)Screen.this).term.word_delineator, b);
                    Extent word = bword.toExtent(((Screen)Screen.this).term.firsta);
                    return Screen.this.term.textWithin(word.begin, word.end);
                }
                case 3: {
                    return new String(l.charArray());
                }
            }
            return null;
        }

        public String getAfterIndex(int part, int index) {
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(((Screen)Screen.this).term.firsta);
            b = ((Screen)Screen.this).term.buf.advance(b);
            return this.getHelper(part, b);
        }

        public String getAtIndex(int part, int index) {
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(((Screen)Screen.this).term.firsta);
            return this.getHelper(part, b);
        }

        public String getBeforeIndex(int part, int index) {
            Coord c = Screen.this.term.PositionToCoord(index);
            if (c == null) {
                return null;
            }
            BCoord b = c.toBCoord(((Screen)Screen.this).term.firsta);
            b = ((Screen)Screen.this).term.buf.backup(b);
            return this.getHelper(part, b);
        }

        public int getIndexAtPoint(Point p) {
            BCoord v = Screen.this.term.toViewCoord(p);
            BCoord b = Screen.this.term.toBufCoords(v);
            return Screen.this.term.CoordToPosition(new Coord(b, ((Screen)Screen.this).term.firsta));
        }
    }
}

