/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermInputListener;

public class StreamTerm
extends Term {
    private OutputStreamWriter writer;

    public OutputStreamWriter getOutputStreamWriter() {
        return this.writer;
    }

    public StreamTerm() {
        this.addInputListener(new TermInputListener(){

            public void sendChars(char[] c, int offset, int count) {
                if (StreamTerm.this.writer == null) {
                    return;
                }
                try {
                    StreamTerm.this.writer.write(c, offset, count);
                    StreamTerm.this.writer.flush();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }

            public void sendChar(char c) {
                if (StreamTerm.this.writer == null) {
                    return;
                }
                try {
                    StreamTerm.this.writer.write(c);
                    StreamTerm.this.writer.flush();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        });
    }

    public void connect(OutputStream pin, InputStream pout, InputStream perr) {
        this.updateTtySize();
        if (pin != null) {
            this.writer = new OutputStreamWriter(pin);
        }
        InputStreamReader out_reader = new InputStreamReader(pout);
        OutputMonitor out_monitor = new OutputMonitor(out_reader, this);
        out_monitor.start();
        if (perr != null) {
            InputStreamReader err_reader = new InputStreamReader(perr);
            OutputMonitor err_monitor = new OutputMonitor(err_reader, this);
            err_monitor.start();
        }
    }

    private class OutputMonitor
    extends Thread {
        private static final int BUFSZ = 1024;
        private char[] buf = new char[1024];
        private Term term;
        private InputStreamReader reader;

        OutputMonitor(InputStreamReader reader, Term term) {
            super("StreamTerm.OutputMonitor");
            this.reader = reader;
            this.term = term;
        }

        private void db_echo_receipt(char[] buf, int offset, int count) {
            System.out.println("Received:");
            int width = 20;
            int cx = 0;
            while (cx < count) {
                int cx0 = cx;
                System.out.print(Fmt.pad(cx, 4) + ": ");
                int x = 0;
                while (x < 20 && cx < count) {
                    String hex = Integer.toHexString(buf[offset + cx]);
                    System.out.print(Fmt.pad0(hex, 2) + " ");
                    ++cx;
                    ++x;
                }
                System.out.println();
                cx = cx0;
                System.out.print("      ");
                int x2 = 0;
                while (x2 < 20 && cx < count) {
                    int c = buf[offset + cx];
                    if (Character.isISOControl((char)c)) {
                        c = 32;
                    }
                    System.out.print(Fmt.pad((byte)c, 2) + " ");
                    ++cx;
                    ++x2;
                }
                System.out.println();
            }
        }

        public void run() {
            Trampoline tramp = new Trampoline();
            try {
                int nread;
                while ((nread = this.reader.read(this.buf, 0, 1024)) != -1) {
                    if (StreamTerm.this.debugInput()) {
                        this.db_echo_receipt(this.buf, 0, nread);
                    }
                    tramp.nread = nread;
                    SwingUtilities.invokeAndWait(tramp);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        private final class Trampoline
        implements Runnable {
            public int nread;

            private Trampoline() {
            }

            public void run() {
                OutputMonitor.this.term.putChars(OutputMonitor.this.buf, 0, this.nread);
            }
        }
    }

    static class Fmt {
        Fmt() {
        }

        public static String pad(int what, int width) {
            return Fmt.pad(new String() + what, width);
        }

        public static String pad(byte what, int width) {
            return Fmt.pad(new String() + (char)what, width);
        }

        public static String pad0(String what, int width) {
            return Fmt.padwith(what, width, '0');
        }

        public static String pad(String what, int width) {
            return Fmt.padwith(what, width, ' ');
        }

        /*
         * Unable to fully structure code
         */
        private static String padwith(String what, int width, char with) {
            block3: {
                left = false;
                if (width < 0) {
                    left = true;
                    width = -width;
                }
                sub = what.length() > width ? what.substring(0, width) : what;
                pad = width - sub.length();
                buf = new StringBuffer(sub);
                if (!left) ** GOTO lbl16
                while (pad-- > 0) {
                    buf.append(with);
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    buf.insert(0, with);
lbl16:
                    // 2 sources

                    ** while (pad-- > 0)
                }
            }
            return new String(buf);
        }
    }
}

