/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.Attr;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Buffer;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Interp;
import org.netbeans.lib.terminalemulator.InterpDumb;
import org.netbeans.lib.terminalemulator.InterpKit;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.LogicalLineVisitor;
import org.netbeans.lib.terminalemulator.MyFontMetrics;
import org.netbeans.lib.terminalemulator.Ops;
import org.netbeans.lib.terminalemulator.RegionManager;
import org.netbeans.lib.terminalemulator.Screen;
import org.netbeans.lib.terminalemulator.Sel;
import org.netbeans.lib.terminalemulator.State;
import org.netbeans.lib.terminalemulator.TermInputListener;
import org.netbeans.lib.terminalemulator.TermListener;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.lib.terminalemulator.WordDelineator;

public class Term
extends JComponent
implements Accessible {
    private State st = new State();
    private Sel sel = new Sel(this, this.st);
    private Ops ops = new OpsImpl();
    private int top_margin = 0;
    private int bot_margin = 0;
    private int cull_count = 0;
    private static final int cull_frequency = 50;
    protected int firsta = 0;
    private int charsInPrehistory = 0;
    private static final int modulo = 0x3FFFFFFF;
    private Screen screen;
    private JScrollBar vscroll_bar;
    private ScrollWrapper hscroll_wrapper;
    private JScrollBar hscroll_bar;
    private boolean has_focus;
    private int n_putchar;
    private int n_putchars;
    private int n_linefeeds;
    private int n_repaint;
    private int n_paint;
    MyFontMetrics metrics = null;
    Buffer buf = new Buffer(80);
    private RegionManager region_manager = new RegionManager();
    private static boolean mouseWheelNotSupported = false;
    private Point left_down_point;
    Clipboard clipboard = this.getToolkit().getSystemClipboard();
    private TermStream base_stream;
    private TermStream dce_end = this.base_stream = new BaseTermStream();
    private TermStream dte_end = this.base_stream;
    public static final int DEBUG_OPS = 1;
    public static final int DEBUG_KEYS = 2;
    public static final int DEBUG_INPUT = 4;
    public static final int DEBUG_OUTPUT = 8;
    public static final int DEBUG_WRAP = 16;
    public static final int DEBUG_MARGINS = 32;
    private int debug_gutter_width = 0;
    private int debug = 0;
    private WordDelineator default_word_delineator;
    WordDelineator word_delineator = this.default_word_delineator = new WordDelineator();
    private LinkedList input_listeners = new LinkedList();
    private LinkedList listeners = new LinkedList();
    private boolean click_to_type = true;
    private boolean read_only = false;
    private HashSet keystroke_set = new HashSet();
    private int hscroll_count = 0;
    private Scroller scroller;
    private Point drag_point;
    private int scrolling_direction = 0;
    private static Extent old_extent = null;
    private boolean size_rounded = true;
    private Color actual_foreground;
    private Color actual_background;
    private boolean check_selection;
    private int totcols;
    private final Point newp = new Point();
    private final boolean do_margins = true;
    private int old_rows = -1;
    private boolean reverse_video = false;
    private Color active_color = Color.lightGray;
    private boolean anchored = false;
    private Interp interp = new InterpDumb(this.ops);
    private int history_size = 20;
    private int glyph_gutter_width;
    private Image[] glyph_images = new Image[256];
    private final Color[] custom_color = new Color[8];
    private final Color[] standard_color = new Color[8];
    private boolean cursor_visible = true;
    private boolean auto_copy = true;
    private boolean refresh_enabled = true;
    boolean selection_xor = false;
    private int tab_size = 8;
    private boolean scroll_on_input = true;
    private boolean scroll_on_output = true;
    private boolean track_cursor = true;
    private boolean horizontally_scrollable = true;
    private AccessibleContext accessible_context;

    public void pushStream(TermStream stream) {
        if (this.dce_end == this.base_stream) {
            this.dte_end = stream;
            stream.setToDCE(this.base_stream);
            stream.setToDTE(this.base_stream);
            this.dce_end = stream;
        } else {
            this.dte_end.setToDCE(stream);
            stream.setToDCE(this.base_stream);
            stream.setToDTE(this.dce_end);
            this.dce_end = stream;
        }
        stream.setTerm(this);
    }

    public void setDebugFlags(int flags) {
        this.debug = flags;
    }

    private boolean debugOps() {
        return (this.debug & 1) == 1;
    }

    private boolean debugKeys() {
        return (this.debug & 2) == 2;
    }

    private boolean debugWrap() {
        return (this.debug & 0x10) == 16;
    }

    private boolean debugMargins() {
        return true;
    }

    protected boolean debugInput() {
        return (this.debug & 4) == 4;
    }

    protected boolean debugOutput() {
        return (this.debug & 8) == 8;
    }

    private int topMargin() {
        return this.top_margin == 0 ? 0 : this.top_margin - 1;
    }

    private int botMargin() {
        return this.bot_margin == 0 ? this.st.rows - 1 : this.bot_margin - 1;
    }

    private int beginx() {
        return this.buf.nlines - this.st.rows;
    }

    private Line cursor_line() {
        return this.buf.lineAt(this.st.cursor.row);
    }

    public void setWordDelineator(WordDelineator word_delineator) {
        this.word_delineator = word_delineator == null ? this.default_word_delineator : word_delineator;
    }

    public WordDelineator getWordDelineator() {
        return this.word_delineator;
    }

    public void setInputListener(TermInputListener l) {
        this.addInputListener(l);
    }

    public void addInputListener(TermInputListener l) {
        this.input_listeners.add(l);
    }

    public void removeInputListener(TermInputListener l) {
        this.input_listeners.remove(l);
    }

    private void fireChar(char c) {
        ListIterator iter = this.input_listeners.listIterator();
        while (iter.hasNext()) {
            TermInputListener l = (TermInputListener)iter.next();
            l.sendChar(c);
        }
    }

    private void fireChars(char[] buf, int offset, int count) {
        ListIterator iter = this.input_listeners.listIterator();
        while (iter.hasNext()) {
            TermInputListener l = (TermInputListener)iter.next();
            l.sendChars(buf, offset, count);
        }
    }

    public void setListener(TermListener l) {
        this.addListener(l);
    }

    public void addListener(TermListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TermListener l) {
        this.listeners.remove(l);
    }

    private void fireSizeChanged(Dimension cells, Dimension pixels) {
        ListIterator iter = this.listeners.listIterator();
        while (iter.hasNext()) {
            TermListener l = (TermListener)iter.next();
            l.sizeChanged(cells, pixels);
        }
    }

    public void setClickToType(boolean click_to_type) {
        this.click_to_type = click_to_type;
    }

    public boolean isClickToType() {
        return this.click_to_type;
    }

    public void setReadOnly(boolean read_only) {
        this.read_only = read_only;
    }

    public boolean isReadOnly() {
        return this.read_only;
    }

    public void clear() {
        int row = 0;
        while (row < this.st.rows) {
            Line l = this.buf.lineAt(this.beginx() + row);
            l.reset();
            ++row;
        }
        this.regionManager().reset();
    }

    public void clearHistoryNoRefresh() {
        this.sel.cancel(true);
        int old_cols = this.buf.visibleCols();
        this.buf = new Buffer(old_cols);
        this.firsta = 0;
        this.charsInPrehistory = 0;
        this.st.firstx = 0;
        this.st.firsty = 0;
        this.st.cursor.row = 0;
        this.st.cursor.col = 0;
        this.st.attr = 0;
        this.st.saveCursor();
        this.st.restoreCursor();
        this.adjust_lines(this.st.rows);
        this.st.firstx = 0;
        this.st.firsty = 0;
        this.regionManager().reset();
        this.screen.possiblyUpdateCaretText();
    }

    public void clearHistory() {
        this.clearHistoryNoRefresh();
        this.repaint(true);
    }

    public RegionManager regionManager() {
        return this.region_manager;
    }

    public String textWithin(Coord begin, Coord end) {
        if (begin == null || end == null) {
            return null;
        }
        final StringBuffer buf = new StringBuffer();
        this.visitLines(begin, end, false, new LineVisitor(){

            public boolean visit(Line l, int row, int bcol, int ecol) {
                buf.append(l.charArray(), bcol, ecol - bcol + 1);
                return true;
            }
        });
        return buf.toString();
    }

    public String getRowText(int row) {
        Line line = this.buf.lineAt(row);
        if (line == null) {
            return null;
        }
        return line.stringBuffer().toString();
    }

    public HashSet getKeyStrokeSet() {
        return this.keystroke_set;
    }

    public void setKeyStrokeSet(HashSet keystroke_set) {
        this.keystroke_set = keystroke_set;
    }

    private boolean maybeConsume(KeyEvent e) {
        if (e.isConsumed()) {
            return false;
        }
        if (this.keystroke_set == null || !this.keystroke_set.contains(KeyStroke.getKeyStrokeForEvent(e))) {
            e.consume();
            return true;
        }
        return false;
    }

    void visitLines(Coord begin, Coord end, boolean newlines, LineVisitor visitor) {
        this.buf.visitLines(begin.toBCoord(this.firsta), end.toBCoord(this.firsta), newlines, visitor);
    }

    public void visitLogicalLines(Coord begin, Coord end, final LogicalLineVisitor llv) {
        LineVisitor tramp = new LineVisitor(){
            String text = "";
            int lineno = 0;
            Coord begin = null;
            Coord end = null;

            public boolean visit(Line l, int brow, int bcol, int ecol) {
                if (l.isWrapped()) {
                    if (this.begin == null) {
                        this.begin = new Coord(new BCoord(brow, bcol), Term.this.firsta);
                    }
                    this.text = this.text + l.text(bcol, ecol);
                } else {
                    if (this.begin == null) {
                        this.begin = new Coord(new BCoord(brow, bcol), Term.this.firsta);
                    }
                    this.end = new Coord(new BCoord(brow, ecol), Term.this.firsta);
                    this.text = this.text + l.text(bcol, ecol);
                    if (!llv.visit(this.lineno, this.begin, this.end, this.text)) {
                        return false;
                    }
                    ++this.lineno;
                    this.text = "";
                    this.begin = null;
                    this.end = null;
                }
                return true;
            }
        };
        if (begin == null) {
            begin = new Coord();
        }
        if (end == null) {
            int lastrow = this.buf.nlines - 1;
            Line l = this.buf.lineAt(lastrow);
            end = new Coord(new BCoord(lastrow, l.length() - 1), this.firsta);
        }
        if (begin.compareTo(end) > 0) {
            return;
        }
        this.buf.visitLines(begin.toBCoord(this.firsta), end.toBCoord(this.firsta), false, tramp);
    }

    public void reverseVisitLogicalLines(Coord begin, Coord end, final LogicalLineVisitor llv) {
        LineVisitor tramp = new LineVisitor(){
            String text = "";
            int lineno = 0;
            Coord begin = null;
            Coord end = null;

            public boolean visit(Line l, int brow, int bcol, int ecol) {
                boolean line_is_continuation = false;
                if (brow > 0 && Term.this.buf.lineAt(brow - 1).isWrapped()) {
                    line_is_continuation = true;
                }
                if (line_is_continuation) {
                    if (this.end == null) {
                        this.end = new Coord(new BCoord(brow, ecol), Term.this.firsta);
                    }
                    this.text = l.text(bcol, ecol) + this.text;
                } else {
                    if (this.end == null) {
                        this.end = new Coord(new BCoord(brow, ecol), Term.this.firsta);
                    }
                    this.begin = new Coord(new BCoord(brow, bcol), Term.this.firsta);
                    this.text = l.text(bcol, ecol) + this.text;
                    if (!llv.visit(this.lineno, this.begin, this.end, this.text)) {
                        return false;
                    }
                    ++this.lineno;
                    this.text = "";
                    this.begin = null;
                    this.end = null;
                }
                return true;
            }
        };
        if (begin == null) {
            begin = new Coord();
        }
        if (end == null) {
            int lastrow = this.buf.nlines - 1;
            Line l = this.buf.lineAt(lastrow);
            end = new Coord(new BCoord(lastrow, l.length() - 1), this.firsta);
        }
        if (begin.compareTo(end) > 0) {
            return;
        }
        this.buf.reverseVisitLines(begin.toBCoord(this.firsta), end.toBCoord(this.firsta), false, tramp);
    }

    public Extent extentInLogicalLine(Coord begin, int offset, int length) {
        Coord from = (Coord)begin.clone();
        while (offset-- > 0) {
            from = new Coord(this.buf.advance(from.toBCoord(this.firsta)), this.firsta);
        }
        Coord to = (Coord)from.clone();
        while (--length > 0) {
            to = new Coord(this.buf.advance(to.toBCoord(this.firsta)), this.firsta);
        }
        return new Extent(from, to);
    }

    private boolean cursor_was_visible() {
        return this.st.cursor.row - 1 >= this.st.firstx && this.st.cursor.row - 1 < this.st.firstx + this.st.rows;
    }

    public void possiblyNormalize(Coord target) {
        if (target == null) {
            return;
        }
        BCoord btarget = target.toBCoord(this.firsta);
        if (btarget.row >= this.st.firstx && btarget.row < this.st.firstx + this.st.rows) {
            return;
        }
        this.st.firstx = btarget.row - this.st.rows / 2;
        if (this.st.firstx < 0) {
            this.st.firstx = 0;
        } else if (this.st.firstx + this.st.rows > this.buf.nlines) {
            this.st.firstx = this.buf.nlines - this.st.rows;
        }
        this.repaint(true);
    }

    public void possiblyNormalize(ActiveRegion region) {
        if (region == null) {
            return;
        }
        BCoord bbegin = region.begin.toBCoord(this.firsta);
        BCoord bend = region.end.toBCoord(this.firsta);
        if (bbegin.row >= this.st.firstx && bend.row < this.st.firstx + this.st.rows) {
            return;
        }
        if (bend.row - bbegin.row + 1 >= this.st.rows) {
            this.st.firstx = bbegin.row;
        } else {
            this.st.firstx = bbegin.row - this.st.rows / 2;
            if (this.st.firstx < 0) {
                this.st.firstx = 0;
            } else if (this.st.firstx + this.st.rows > this.buf.nlines) {
                this.st.firstx = this.buf.nlines - this.st.rows;
            } else if (this.st.firstx + this.st.rows <= bend.row) {
                this.st.firstx = bend.row - this.st.rows + 1;
            }
        }
        this.repaint(true);
    }

    public boolean isCoordVisible(Coord target) {
        BCoord btarget = target.toBCoord(this.firsta);
        return btarget.row >= this.st.firstx && btarget.row < this.st.firstx + this.st.rows;
    }

    private void possiblyScrollOnInput() {
        if (!this.scroll_on_input) {
            return;
        }
        if (this.st.cursor.row < this.st.firstx || this.st.cursor.row >= this.st.firstx + this.st.rows) {
            this.st.firstx = this.buf.nlines - this.st.rows;
            this.repaint(true);
        }
    }

    private void hscrollReset(char c) {
        Term.ckEventDispatchThread();
        this.hscroll_count = c == '\n' || c == '\r' ? 8 : (this.hscroll_count += 8);
    }

    private void possiblyHScroll() {
        if (!this.horizontally_scrollable) {
            return;
        }
        Term.ckEventDispatchThread();
        if (this.hscroll_count > 0) {
            --this.hscroll_count;
        } else {
            return;
        }
        if (this.st.cursor.col >= this.st.firsty + this.buf.visibleCols()) {
            this.st.firsty = this.st.cursor.col - this.buf.visibleCols() + 1;
            this.buf.noteColumn(this.st.cursor.col + 1);
            this.repaint(true);
        } else if (this.st.cursor.col - this.buf.visibleCols() < this.st.firsty) {
            this.st.firsty = this.st.cursor.col - this.buf.visibleCols() + 1;
            if (this.st.firsty < 0) {
                this.st.firsty = 0;
            } else {
                this.repaint(true);
            }
        }
    }

    public void setAttribute(int value) {
        this.st.attr = Attr.setAttribute(this.st.attr, value);
    }

    public void setCharacterAttribute(Coord begin, Coord end, final int value, final boolean on) {
        this.visitLines(begin, end, false, new LineVisitor(){

            public boolean visit(Line l, int brow, int bcol, int ecol) {
                l.setCharacterAttribute(bcol, ecol, value, on);
                return true;
            }
        });
        this.repaint(false);
    }

    public void setGlyph(int glyph_id, int background_id) {
        Line l = this.cursor_line();
        l.glyph_glyph = glyph_id;
        l.glyph_rendition = background_id;
    }

    public void setRowGlyph(int row, int glyph_id, int background_id) {
        Coord c = new Coord();
        c.row = row;
        c.col = 0;
        BCoord b = c.toBCoord(this.firsta);
        Line l = this.buf.lineAt(b.row);
        if (l == null) {
            return;
        }
        l.glyph_glyph = glyph_id;
        l.glyph_rendition = background_id;
        this.possibly_repaint(false);
    }

    private void adjust_lines(int delta_row) {
        if (delta_row > 0) {
            this.st.firstx -= delta_row;
            while (this.st.firstx < 0) {
                this.buf.appendLine();
                ++this.st.firstx;
            }
        } else if (delta_row < 0) {
            int delete_from_bottom;
            int orows = this.st.rows - delta_row;
            int allowed = this.buf.nlines - this.st.cursor.row - 1;
            if (allowed < 0) {
                allowed = 0;
            }
            if (allowed > -delta_row) {
                delete_from_bottom = -delta_row;
            } else {
                delete_from_bottom = allowed;
                this.st.firstx += -delta_row - allowed;
            }
            while (delete_from_bottom-- > 0) {
                this.buf.removeLineAt(this.buf.nlines - 1);
                switch (this.sel.intersection(this.firsta + this.buf.nlines - 1)) {
                    case 0: 
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.sel.cancel(true);
                    }
                }
            }
        }
        this.adjust_scrollbar();
    }

    public int getHistoryBuffSize() {
        return this.buf.nlines - this.st.rows;
    }

    private void limit_lines() {
        int toremove;
        if (this.anchored) {
            return;
        }
        int history = this.buf.nlines - this.st.rows;
        if (history < 0) {
            history = 0;
        }
        if ((toremove = history - this.history_size) > 0) {
            int charsRemoved = this.buf.removeLinesAt(0, toremove);
            this.charsInPrehistory += charsRemoved;
            this.st.adjust(-toremove);
            this.firsta += toremove;
            this.sel.adjust(this.firsta, 0);
            if (++this.cull_count % 50 == 0) {
                this.region_manager.cull(this.firsta);
            }
            if (this.firsta + this.buf.nlines >= 0x3FFFFFFF) {
                int old_firsta = this.firsta;
                this.firsta = 0;
                this.sel.relocate(old_firsta, this.firsta);
                this.region_manager.relocate(old_firsta, this.firsta);
            }
        }
        this.adjust_scrollbar();
    }

    private void scroll_to(int direction, MouseEvent e) {
        if (direction == this.scrolling_direction) {
            if (direction == 0) {
                BCoord bc = this.toBufCoords(this.toViewCoord(e.getPoint()));
                this.sel.track(new Coord(bc, this.firsta));
                this.repaint(false);
            }
            return;
        }
        if (this.scroller != null) {
            this.scroller.interrupt();
            this.scroller = null;
        }
        if (direction == 0) {
            BCoord bc = this.toBufCoords(this.toViewCoord(e.getPoint()));
            this.sel.track(new Coord(bc, this.firsta));
            this.repaint(false);
        } else {
            this.scroller = new Scroller(direction);
            this.scroller.start();
        }
        this.scrolling_direction = direction;
    }

    public Term() {
        this.st.rows = 25;
        this.st.firstx = 0;
        this.st.firsty = 0;
        this.standard_color[0] = Color.black;
        this.standard_color[1] = Color.red;
        this.standard_color[2] = Color.green;
        this.standard_color[3] = Color.yellow;
        this.standard_color[4] = Color.blue;
        this.standard_color[5] = Color.magenta;
        this.standard_color[6] = Color.cyan;
        this.standard_color[7] = Color.white;
        this.custom_color[0] = Color.black;
        this.custom_color[1] = Color.black;
        this.custom_color[2] = Color.black;
        this.custom_color[3] = Color.black;
        this.custom_color[4] = Color.black;
        this.custom_color[5] = Color.black;
        this.custom_color[6] = Color.black;
        this.custom_color[7] = Color.black;
        this.setFont(new Font("Monospaced", 0, ((Font)UIManager.getDefaults().get("TextArea.font")).getSize() + 1));
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.screen = new Screen(this, this.buf.visibleCols() * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width, this.st.rows * this.metrics.height);
        this.add("Center", this.screen);
        this.screen.setBackground(null);
        this.adjust_lines(this.st.rows);
        this.st.cursor.row = 0;
        this.vscroll_bar = new JScrollBar(1);
        this.add("East", this.vscroll_bar);
        this.vscroll_bar.setValues(this.st.firstx, this.st.rows - 1, 0, this.st.rows);
        this.vscroll_bar.setUnitIncrement(1);
        this.vscroll_bar.setEnabled(true);
        this.vscroll_bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar sb = (JScrollBar)e.getAdjustable();
                switch (e.getAdjustmentType()) {
                    case 5: {
                        int pos = e.getValue();
                        if (pos == ((Term)Term.this).st.firstx) break;
                        ((Term)Term.this).st.firstx = pos;
                        Term.this.repaint(false);
                        break;
                    }
                }
            }
        });
        this.hscroll_bar = new JScrollBar(0);
        this.hscroll_bar.setValues(this.st.firsty, this.buf.totalCols() - 1, 0, this.buf.totalCols());
        this.hscroll_bar.setUnitIncrement(1);
        this.hscroll_bar.setEnabled(true);
        this.hscroll_wrapper = new ScrollWrapper(this.hscroll_bar);
        this.add("South", this.hscroll_wrapper);
        this.hscroll_bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar sb = (JScrollBar)e.getAdjustable();
                switch (e.getAdjustmentType()) {
                    case 5: {
                        int pos = e.getValue();
                        if (pos == ((Term)Term.this).st.firsty) break;
                        ((Term)Term.this).st.firsty = pos;
                        Term.this.repaint(false);
                        break;
                    }
                }
            }
        });
        this.screen.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Dimension size = Term.this.screen.getSize();
                Term.this.sizeChanged(size.width, size.height);
                Term.this.repaint(true);
            }
        });
        this.screen.addKeyListener(new KeyListener(){
            boolean saw_return;

            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (Term.this.debugKeys()) {
                    System.out.println("term: keyTyped: " + e);
                }
                if (Term.this.read_only) {
                    return;
                }
                if (c == '\n' && this.saw_return) {
                    this.saw_return = false;
                    c = '\r';
                }
                if (Term.this.maybeConsume(e)) {
                    Term.this.on_char(c);
                    Term.this.possiblyScrollOnInput();
                }
                Term.this.hscrollReset(c);
            }

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 65485: {
                        Term.this.copy();
                        break;
                    }
                    case 65487: {
                        Term.this.paste();
                        break;
                    }
                    case 10: {
                        this.saw_return = true;
                        break;
                    }
                    case 33: {
                        if (e.getModifiers() == 2) {
                            Term.this.pageLeft(1);
                            break;
                        }
                        Term.this.pageUp(1);
                        break;
                    }
                    case 34: {
                        if (e.getModifiers() == 2) {
                            Term.this.pageRight(1);
                            break;
                        }
                        Term.this.pageDown(1);
                        break;
                    }
                    case 38: {
                        if (e.getModifiers() != 2) break;
                        Term.this.lineUp(1);
                        break;
                    }
                    case 40: {
                        if (e.getModifiers() != 2) break;
                        Term.this.lineDown(1);
                    }
                }
                Term.this.maybeConsume(e);
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    this.saw_return = false;
                }
                Term.this.maybeConsume(e);
            }
        });
        this.screen.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                if (Term.this.left_down_point != null) {
                    BCoord bc = Term.this.toBufCoords(Term.this.toViewCoord(Term.this.left_down_point));
                    Term.this.sel.track(new Coord(bc, Term.this.firsta));
                    Term.this.left_down_point = null;
                }
                Term.this.drag_point = e.getPoint();
                int scroll_direction = 0;
                if (((Term)Term.this).drag_point.y < 0) {
                    scroll_direction |= 2;
                } else if (((Term)Term.this).drag_point.y > ((Term)Term.this).screen.getSize().height) {
                    scroll_direction |= 4;
                }
                if (((Term)Term.this).drag_point.x < 0) {
                    scroll_direction |= 8;
                } else if (((Term)Term.this).drag_point.x > ((Term)Term.this).screen.getSize().width) {
                    scroll_direction |= 0x10;
                }
                Term.this.scroll_to(scroll_direction, e);
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
        Term.addMouseWheelHandler(this.screen, this.vscroll_bar);
        this.screen.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                BCoord bcoord = Term.this.toBufCoords(Term.this.toViewCoord(e.getPoint()));
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (Term.this.click_to_type) {
                        Term.this.screen.requestFocus();
                    }
                } else if (SwingUtilities.isMiddleMouseButton(e)) {
                    if (mouseWheelNotSupported) {
                        Term.this.paste();
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    // empty if block
                }
            }

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.isShiftDown()) {
                        BCoord bc = Term.this.toBufCoords(Term.this.toViewCoord(e.getPoint()));
                        if (Term.this.sel.extend(new Coord(bc, Term.this.firsta))) {
                            Term.this.fireSelectionExtentChanged();
                            Term.this.repaint(false);
                        }
                        return;
                    }
                    if (Term.this.sel.cancel(false)) {
                        Term.this.repaint(false);
                    }
                    if (e.getClickCount() == 1) {
                        Term.this.left_down_point = (Point)e.getPoint().clone();
                    } else if (e.getClickCount() == 2) {
                        BCoord bcoord = Term.this.toBufCoords(Term.this.toViewCoord(e.getPoint()));
                        BExtent word = Term.this.buf.find_word(Term.this.word_delineator, bcoord);
                        Term.this.sel.select_word(word.toExtent(Term.this.firsta));
                        Term.this.repaint(false);
                    } else if (e.getClickCount() == 3) {
                        BCoord bcoord = Term.this.toBufCoords(Term.this.toViewCoord(e.getPoint()));
                        Term.this.sel.select_line(new Coord(bcoord, Term.this.firsta));
                        Term.this.repaint(false);
                    }
                    Term.this.fireSelectionExtentChanged();
                } else if (SwingUtilities.isMiddleMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                    // empty if block
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.isShiftDown()) {
                        return;
                    }
                    if (Term.this.scroller != null) {
                        Term.this.scroller.interrupt();
                        Term.this.scroller = null;
                    }
                    if (Term.this.left_down_point == null) {
                        Term.this.sel.done(false);
                    }
                    Term.this.left_down_point = null;
                }
            }

            public void mouseEntered(MouseEvent e) {
                if (!Term.this.click_to_type) {
                    Term.this.screen.requestFocus();
                }
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.screen.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Term.this.has_focus = true;
                Term.this.repaint(false);
            }

            public void focusLost(FocusEvent e) {
                Term.this.has_focus = false;
                Term.this.repaint(false);
            }
        });
    }

    public void printStats(String message) {
        if (message != null) {
            System.out.println(message);
        }
        if (message != null) {
            System.out.print("\t");
        }
        this.buf.printStats();
        if (message != null) {
            System.out.print("\t");
        }
        System.out.println("rows " + this.st.rows + "  v cols " + this.buf.visibleCols() + "  t cols " + this.buf.totalCols() + "  history " + this.history_size + "  firstx " + this.st.firstx + "  firsty " + this.st.firsty + "  firsta " + this.firsta + "  gutter " + this.glyph_gutter_width);
        if (message != null) {
            System.out.print("\t");
        }
        System.out.println("Cursor " + this.st.cursor + "  topMargin " + this.topMargin() + "  botMargin " + this.botMargin());
        if (message != null) {
            System.out.print("\t");
        }
        System.out.println("putChar " + this.n_putchar + "  putChars " + this.n_putchars + "  linefeeds " + this.n_linefeeds + "  repaint " + this.n_repaint + "  paint " + this.n_paint);
    }

    public void paste() {
        if (this.read_only) {
            return;
        }
        Transferable contents = this.clipboard.getContents(this.screen);
        if (contents == null) {
            return;
        }
        if (!contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            String string = (String)contents.getTransferData(DataFlavor.stringFlavor);
            char[] ca = string.toCharArray();
            this.sendChars(ca, 0, ca.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copy() {
        String text = this.sel.getSelection();
        if (text != null) {
            StringSelection ss = new StringSelection(text);
            this.clipboard.setContents(ss, this.sel);
        }
    }

    void fireSelectionExtentChanged() {
        Extent new_extent = this.getSelectionExtent();
        this.firePropertyChange("selectionExtent", old_extent, new_extent);
        old_extent = new_extent;
    }

    public void setRows(int rows) {
        if (this.old_rows == -1) {
            this.old_rows = this.st.rows;
        }
        this.st.rows = rows;
        this.updateScreenSize();
    }

    public int getRows() {
        return this.st.rows;
    }

    public void setColumns(int cols) {
        this.buf.setVisibleCols(cols);
        this.updateScreenSize();
    }

    void noteColumn(Line l, int capacity) {
        int vcapacity = l.bufToCell(this.metrics, capacity);
        this.buf.noteColumn(vcapacity);
    }

    void checkForMultiCell(char c) {
        this.metrics.checkForMultiCell(c);
    }

    public int getColumns() {
        return this.buf.visibleCols();
    }

    public void setRowsColumns(int rows, int columns) {
        if (this.old_rows == -1) {
            this.old_rows = this.st.rows;
        }
        this.st.rows = rows;
        this.buf.setVisibleCols(columns);
        this.updateScreenSize();
    }

    public void setSizeRounded(boolean size_rounded) {
        this.size_rounded = size_rounded;
        this.updateScreenSize();
    }

    public boolean isSizeRounded() {
        return this.size_rounded;
    }

    public void fillSizeInfo(Dimension cells, Dimension pixels) {
        cells.height = this.st.rows;
        cells.width = this.buf.visibleCols();
        Dimension cpixels = this.screen.getSize();
        pixels.width = cpixels.width - this.glyph_gutter_width - this.debug_gutter_width;
        pixels.height = cpixels.height;
    }

    protected void updateTtySize() {
        if (this.screen != null) {
            Dimension cells = new Dimension(this.buf.visibleCols(), this.st.rows);
            Dimension pixels = this.screen.getSize();
            this.fireSizeChanged(cells, pixels);
        }
    }

    BCoord toViewCoord(BCoord b) {
        int vc = this.buf.lineAt(b.row).bufToCell(this.metrics, b.col);
        BCoord v = new BCoord(b.row - this.st.firstx, vc - this.st.firsty);
        return v;
    }

    Point toPixel(BCoord v) {
        Point p = new Point(v.col * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width, v.row * this.metrics.height);
        return p;
    }

    public Point toPixel(Coord target) {
        BCoord btarget = target.toBCoord(this.firsta);
        return this.toPixel(btarget);
    }

    BCoord toViewCoord(Point p) {
        BCoord v = new BCoord(p.y / this.metrics.height, (p.x - this.glyph_gutter_width - this.debug_gutter_width) / this.metrics.width);
        v.clip(this.st.rows, this.buf.visibleCols());
        return v;
    }

    BCoord toBufCoords(BCoord v) {
        int brow = this.st.firstx + v.row;
        if (brow >= this.buf.nlines) {
            brow = this.buf.nlines - 1;
        }
        int bc = this.buf.lineAt(brow).cellToBuf(this.metrics, this.st.firsty + v.col);
        BCoord b = new BCoord(brow, bc);
        return b;
    }

    public Point mapToViewRowCol(Point p) {
        BCoord c = this.toViewCoord(p);
        return new Point(c.col, c.row);
    }

    public Point mapToBufRowCol(Point p) {
        BCoord c = this.toBufCoords(this.toViewCoord(p));
        return new Point(c.col, c.row);
    }

    private Color rendition_to_color(int rendition) {
        switch (rendition) {
            case 40: {
                return this.standard_color[0];
            }
            case 41: {
                return this.standard_color[1];
            }
            case 42: {
                return this.standard_color[2];
            }
            case 43: {
                return this.standard_color[3];
            }
            case 44: {
                return this.standard_color[4];
            }
            case 45: {
                return this.standard_color[5];
            }
            case 46: {
                return this.standard_color[6];
            }
            case 47: {
                return this.standard_color[7];
            }
            case 58: {
                return this.custom_color[0];
            }
            case 59: {
                return this.custom_color[1];
            }
            case 60: {
                return this.custom_color[2];
            }
            case 61: {
                return this.custom_color[3];
            }
            case 62: {
                return this.custom_color[4];
            }
            case 63: {
                return this.custom_color[5];
            }
            case 64: {
                return this.custom_color[6];
            }
            case 65: {
                return this.custom_color[7];
            }
        }
        return null;
    }

    private void do_run(Graphics g, int yoff, int xoff, int baseline, int brow, char[] buf, Line l, int attr, int rbegin, int rend) {
        int xlength;
        int rlength;
        int x;
        if (this.metrics.isMultiCell()) {
            int vbegin = l.bufToCell(this.metrics, rbegin);
            int vend = l.bufToCell(this.metrics, rend + 1) - 1;
            x = xoff + (vbegin - this.st.firsty) * this.metrics.width;
            int vlength = vend - vbegin + 1;
            if (vlength <= 0) {
                return;
            }
            rlength = rend - rbegin + 1;
            xlength = vlength * this.metrics.width;
        } else {
            x = xoff + (rbegin - this.st.firsty) * this.metrics.width;
            rlength = rend - rbegin + 1;
            if (rlength <= 0) {
                return;
            }
            xlength = rlength * this.metrics.width;
        }
        boolean reverse = (attr & 0x800) == 2048;
        boolean active = (attr & 0x10000) == 65536;
        Color bg = null;
        bg = active ? this.active_color : this.backgroundColor(reverse, attr);
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(x, yoff, xlength, this.metrics.height - this.metrics.leading);
        }
        Color fg = this.foregroundColor(reverse, attr);
        g.setColor(fg);
        if ((attr & 0x2000) == 8192) {
            int h = this.metrics.height - this.metrics.leading - 1;
            g.drawLine(x, yoff + h, x + xlength, yoff + h);
        }
        this.myDrawChars(g, buf, l, rbegin, rlength, x, baseline);
        if ((attr & 0x4000) == 16384) {
            this.myDrawChars(g, buf, l, rbegin, rlength, x + 1, baseline);
        }
    }

    private void massage_glyphs(GlyphVector gv, int start, int n, Line l) {
        Point2D pos0 = gv.getGlyphPosition(0);
        this.newp.y = (int)pos0.getY();
        int col = (int)pos0.getX();
        int gx = 0;
        while (gx < n) {
            this.newp.x = col;
            gv.setGlyphPosition(gx, this.newp);
            col += l.width(this.metrics, start + gx) * this.metrics.width;
            ++gx;
        }
    }

    private void myDrawChars(Graphics g, char[] buf, Line l, int start, int howmany, int xoff, int baseline) {
        if (this.metrics.isMultiCell()) {
            Graphics2D g2 = (Graphics2D)g;
            FontRenderContext frc = g2.getFontRenderContext();
            char[] tmp = new char[howmany];
            System.arraycopy(buf, start, tmp, 0, howmany);
            GlyphVector gv = this.getFont().createGlyphVector(frc, tmp);
            this.massage_glyphs(gv, start, howmany, l);
            g2.drawGlyphVector(gv, xoff, baseline);
        } else {
            g.drawChars(buf, start, howmany, xoff, baseline);
        }
    }

    private void paint_line_new(Graphics g, Line l, int brow, int xoff, int yoff, int baseline, Extent selx) {
        int rbegin;
        int lastcol;
        int firstcol;
        int length = l.length();
        if (length == 0) {
            return;
        }
        if (this.metrics.isMultiCell()) {
            firstcol = l.cellToBuf(this.metrics, this.st.firsty);
            int inverse_firstcol = l.bufToCell(this.metrics, firstcol);
            int delta = this.st.firsty - inverse_firstcol;
            if (delta > 0) {
                ++firstcol;
                int pdelta = delta * this.metrics.width;
                xoff += pdelta;
            }
            lastcol = l.cellToBuf(this.metrics, this.st.firsty + this.buf.visibleCols() - 1);
        } else {
            lastcol = this.st.firsty + this.buf.visibleCols() - 1;
            firstcol = this.st.firsty;
        }
        lastcol = Math.min(lastcol, length - 1);
        if (firstcol > lastcol) {
            return;
        }
        int howmany = lastcol - firstcol + 1;
        char[] buf = l.charArray();
        if (!l.hasAttributes()) {
            if (this.debugWrap()) {
                if (l.isWrapped() && l.isAboutToWrap()) {
                    g.setColor(Color.red);
                } else if (l.isAboutToWrap()) {
                    g.setColor(Color.orange);
                } else if (l.isWrapped()) {
                    g.setColor(Color.magenta);
                }
            }
            this.myDrawChars(g, buf, l, firstcol, howmany, xoff, baseline);
            return;
        }
        int[] attrs = l.attrArray();
        int sbegin = -1;
        int send = -1;
        if (this.check_selection && selx != null) {
            int arow = this.firsta + brow;
            Coord b = selx.begin;
            Coord e = selx.end;
            if (b.row <= arow && e.row >= arow) {
                if (b.row == e.row) {
                    sbegin = b.col;
                    send = e.col;
                } else if (arow == b.row) {
                    sbegin = b.col;
                    send = this.totcols;
                } else if (arow == e.row) {
                    sbegin = 0;
                    send = e.col;
                } else {
                    sbegin = 0;
                    send = this.totcols;
                }
            }
        }
        int rend = rbegin = firstcol;
        while (true) {
            int attr = attrs[rbegin];
            rend = rbegin + 1;
            while (rend <= lastcol) {
                if (attrs[rend] != attr) break;
                ++rend;
            }
            int alt_attr = attr & 0xFFFEF610;
            if (sbegin == -1 || send < rbegin || sbegin > --rend) {
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, attr, rbegin, rend);
            } else if (sbegin <= rbegin && send >= rend) {
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, alt_attr, rbegin, rend);
            } else if (sbegin > rbegin && send < rend) {
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, attr, rbegin, sbegin - 1);
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, alt_attr, sbegin, send);
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, attr, send + 1, rend);
            } else if (sbegin <= rbegin) {
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, alt_attr, rbegin, send);
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, attr, send + 1, rend);
            } else if (send >= rend) {
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, attr, rbegin, sbegin - 1);
                this.do_run(g, yoff, xoff, baseline, brow, buf, l, alt_attr, sbegin, rend);
            }
            if (rend + 1 >= lastcol) break;
            rbegin = rend + 1;
        }
    }

    void do_paint(Graphics g) {
        Term.ckEventDispatchThread();
        if (this.st.firstx == -1) {
            return;
        }
        g.setFont(this.getFont());
        ++this.n_paint;
        if (this.reverse_video) {
            this.actual_foreground = this.getBackground();
            this.actual_background = this.getForeground();
        } else {
            this.actual_foreground = this.getForeground();
            this.actual_background = this.getBackground();
        }
        g.setColor(this.actual_background);
        g.fillRect(0, 0, this.screen.getSize().width, this.screen.getSize().height);
        int xoff = this.debug_gutter_width + this.glyph_gutter_width;
        int lx = this.st.firstx;
        int vrow = 0;
        while (vrow < this.st.rows) {
            Line l = this.buf.lineAt(lx);
            if (l == null) break;
            int yoff = this.metrics.height * vrow;
            Color background = this.rendition_to_color(l.glyph_rendition);
            if (background != null) {
                int rect_height = this.metrics.height - this.metrics.leading;
                g.setColor(background);
                g.fillRect(xoff, yoff, this.screen.getWidth(), rect_height);
            }
            ++lx;
            ++vrow;
        }
        if (!this.selection_xor) {
            this.sel.paint(g);
        }
        g.setColor(this.actual_foreground);
        Extent selx = this.sel.getExtent();
        this.check_selection = selx != null && !this.selection_xor;
        this.totcols = this.buf.totalCols();
        lx = this.st.firstx;
        int vrow2 = 0;
        while (vrow2 < this.st.rows) {
            Image image;
            Line l = this.buf.lineAt(lx);
            if (l == null) {
                this.printStats(null);
                break;
            }
            xoff = 0;
            int yoff = this.metrics.height * vrow2;
            int baseline = yoff + this.metrics.ascent;
            if (this.debug_gutter_width > 0) {
                String buf = "" + (this.firsta + this.st.firstx + vrow2);
                g.drawString(buf, xoff, baseline);
            }
            xoff += this.debug_gutter_width;
            if (this.glyph_gutter_width > 0 && (image = this.glyph_images[l.glyph_glyph]) != null) {
                int gyoff = yoff;
                g.drawImage(image, xoff, gyoff, Color.white, null);
            }
            this.paint_line_new(g, l, vrow2 + this.st.firstx, xoff += this.glyph_gutter_width, yoff, baseline, selx);
            g.setColor(this.actual_foreground);
            ++lx;
            ++vrow2;
        }
        this.paint_cursor(g);
        if (this.selection_xor) {
            this.sel.paint(g);
        }
        if (this.debugMargins()) {
            this.paint_margins(g);
        }
    }

    private void paint_margins(Graphics g) {
    }

    private void paint_cursor(Graphics g) {
        if (!this.cursor_visible) {
            return;
        }
        if (this.st.cursor.row == -1) {
            return;
        }
        int cursor_row = this.st.cursor.row - this.st.firstx;
        if (cursor_row >= this.st.rows) {
            return;
        }
        int cursor_col = this.st.cursor.col - this.st.firsty;
        if (cursor_col >= this.buf.visibleCols()) {
            return;
        }
        if (cursor_col < 0) {
            return;
        }
        g.setXORMode(this.actual_background);
        int rect_x = cursor_col * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width;
        int rect_y = cursor_row * this.metrics.height;
        int rect_width = this.metrics.width;
        int rect_height = this.metrics.height - this.metrics.leading;
        if (this.has_focus) {
            g.fillRect(rect_x, rect_y, rect_width, rect_height);
        } else {
            g.drawRect(rect_x, rect_y, rect_width, rect_height);
        }
    }

    private boolean possiblyScrollDown() {
        if (this.st.cursor.row >= this.st.firstx + this.botMargin() + 1) {
            if (this.topMargin() == 0) {
                if (this.scroll_on_output || this.cursor_was_visible() && this.track_cursor) {
                    ++this.st.firstx;
                }
                return true;
            }
            this.st.cursor.row = this.st.firstx + this.botMargin();
            Line l = this.buf.moveLineFromTo(this.st.firstx + this.topMargin(), this.st.cursor.row);
            l.reset();
            return false;
        }
        return false;
    }

    public void putChar(char c) {
        this.dce_end.putChar(c);
    }

    public void putChars(char[] buf, int offset, int count) {
        this.dce_end.putChars(buf, offset, count);
    }

    public void flush() {
        this.dce_end.flush();
    }

    private void reply(String str) {
        int sx = 0;
        while (sx < str.length()) {
            this.sendChar(str.charAt(sx));
            ++sx;
        }
    }

    private void putc_work(char c) {
        this.interp.processChar(c);
        this.possiblyHScroll();
        this.screen.possiblyUpdateCaretText();
    }

    private void on_char(char c) {
        this.sendChar(c);
    }

    private void sendChars(char[] c, int offset, int count) {
        this.dte_end.sendChars(c, offset, count);
    }

    private void sendChar(char c) {
        this.dte_end.sendChar(c);
    }

    private void adjust_scrollbar() {
        this.adjust_scrollbar_impl();
    }

    private void adjust_scrollbar_impl() {
        int max;
        int min;
        int extent;
        int value;
        if (this.vscroll_bar != null) {
            value = this.st.firstx;
            extent = this.st.rows - 1;
            min = 0;
            max = this.buf.nlines <= this.st.rows ? this.st.rows - 1 : this.buf.nlines - 1;
            this.vscroll_bar.setValues(value, extent, min, max);
        }
        if (this.hscroll_bar != null && this.horizontally_scrollable) {
            value = this.st.firsty;
            extent = this.buf.visibleCols() - 1;
            min = 0;
            max = this.buf.totalCols() <= this.buf.visibleCols() ? this.buf.visibleCols() - 1 : this.buf.totalCols() - 1;
            this.hscroll_bar.setValues(value, extent, min, max);
        }
    }

    private Dimension calculateSize() {
        int dx = this.buf.visibleCols() * this.metrics.width + this.glyph_gutter_width + this.debug_gutter_width;
        int dy = this.st.rows * this.metrics.height;
        Dimension d = new Dimension(dx, dy);
        return d;
    }

    private void updateScreenSize() {
        if (this.screen != null) {
            Dimension d = this.calculateSize();
            this.sizeChanged(d.width, d.height);
        }
    }

    void sizeChanged(int newWidth, int newHeight) {
        int newcols = (newWidth - this.glyph_gutter_width - this.debug_gutter_width) / this.metrics.width;
        this.buf.setVisibleCols(newcols);
        if (this.old_rows == -1) {
            this.old_rows = this.st.rows;
        }
        this.st.rows = newHeight / this.metrics.height;
        if (this.st.rows < 1) {
            this.st.rows = 1;
        }
        int row_delta = this.st.rows - this.old_rows;
        this.old_rows = -1;
        this.adjust_lines(row_delta);
        this.limit_lines();
        Dimension new_size = this.isSizeRounded() ? this.calculateSize() : new Dimension(newWidth, newHeight);
        this.screen.setPreferredSize(new_size);
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.updateTtySize();
    }

    protected void possibly_repaint(boolean adjust_scrollbar) {
        if (!this.refresh_enabled) {
            return;
        }
        this.repaint(adjust_scrollbar);
    }

    protected void repaint(boolean adjust_scrollbar) {
        ++this.n_repaint;
        if (adjust_scrollbar) {
            this.adjust_scrollbar();
        }
        this.screen.repaint();
    }

    public void setReverseVideo(boolean reverse_video) {
        this.reverse_video = reverse_video;
        this.repaint(false);
    }

    public boolean isReverseVideo() {
        return this.reverse_video;
    }

    public void setHighlightColor(Color color) {
        this.sel.setColor(color);
        this.repaint(false);
    }

    public Color getHighlightColor() {
        return this.sel.getColor();
    }

    public void setHighlightXORColor(Color color) {
        this.sel.setXORColor(color);
        this.repaint(false);
    }

    public Color getHighlightXORColor() {
        return this.sel.getXORColor();
    }

    public void setActiveColor(Color color) {
        this.active_color = color;
        this.repaint(false);
    }

    public Color getActiveColor() {
        return this.active_color;
    }

    public void setAnchored(boolean anchored) {
        Term.ckEventDispatchThread();
        if (anchored) {
            this.anchored = false;
            this.limit_lines();
            this.anchored = true;
        } else {
            this.anchored = false;
            this.limit_lines();
            this.repaint(false);
        }
    }

    public boolean isAnchored() {
        return this.anchored;
    }

    public JComponent getCanvas() {
        return this.screen;
    }

    public JComponent getScreen() {
        return this.screen;
    }

    public Ops ops() {
        return this.ops;
    }

    public void setEmulation(String emulation) {
        Interp new_interp = InterpKit.forName(emulation, this.ops);
        if (new_interp == null) {
            return;
        }
        this.interp = new_interp;
    }

    public String getEmulation() {
        return this.getInterp().name();
    }

    public void setInterp(Interp interp) {
        this.interp = interp;
    }

    public Interp getInterp() {
        return this.interp;
    }

    public void setHistorySize(int new_size) {
        this.history_size = new_size;
        this.limit_lines();
        this.repaint(true);
    }

    public int getHistorySize() {
        return this.history_size;
    }

    public void setGlyphGutterWidth(int pixels) {
        this.glyph_gutter_width = pixels;
        if (this.glyph_gutter_width > 30) {
            this.glyph_gutter_width = 30;
        }
        this.updateScreenSize();
    }

    public void setGlyphImage(int glyph_number, Image image) {
        if (glyph_number > 256) {
            return;
        }
        this.glyph_images[glyph_number] = image;
    }

    public Dimension getGlyphCellSize() {
        return new Dimension(this.glyph_gutter_width, this.metrics.height);
    }

    public void setCustomColor(int number, Color c) {
        this.custom_color[number] = c;
    }

    public int getCursorRow() {
        return this.st.cursor.row;
    }

    public int getCursorCol() {
        return this.cursor_line().cellToBuf(this.metrics, this.st.cursor.col);
    }

    public Coord getCursorCoord() {
        Line l = this.buf.lineAt(this.st.cursor.row);
        return new Coord(new BCoord(this.st.cursor.row, l.cellToBuf(this.metrics, this.st.cursor.col)), this.firsta);
    }

    public void goTo(Coord coord) {
        this.setCursorCoord(coord);
    }

    public void setCursorCoord(Coord coord) {
        Coord c = (Coord)coord.clone();
        c.clip(this.st.rows, this.buf.visibleCols(), this.firsta);
        this.st.cursor = c.toBCoord(this.firsta);
        this.st.cursor.col = this.cursor_line().bufToCell(this.metrics, this.st.cursor.col);
        this.repaint(true);
    }

    public void setCursorVisible(boolean cursor_visible) {
        this.cursor_visible = cursor_visible;
    }

    public boolean isCursorVisible() {
        return this.cursor_visible;
    }

    public Coord backup(Coord c) {
        BCoord bRow = this.buf.backup(c.toBCoord(this.firsta));
        if (bRow == null) {
            return null;
        }
        return new Coord(bRow, this.firsta);
    }

    public Coord advance(Coord c) {
        return new Coord(this.buf.advance(c.toBCoord(this.firsta)), this.firsta);
    }

    public String getSelectedText() {
        return this.sel.getSelection();
    }

    public Extent getSelectionExtent() {
        return this.sel.getExtent();
    }

    public void setSelectionExtent(Extent extent) {
        extent.begin.clip(this.buf.nlines, this.buf.totalCols(), this.firsta);
        extent.end.clip(this.buf.nlines, this.buf.totalCols(), this.firsta);
        this.sel.setExtent(extent);
        this.repaint(false);
    }

    public void clearSelection() {
        this.sel.cancel(true);
        this.repaint(false);
    }

    public void setAutoCopy(boolean auto_copy) {
        this.auto_copy = auto_copy;
    }

    public boolean isAutoCopy() {
        return this.auto_copy;
    }

    public void setRefreshEnabled(boolean refresh_enabled) {
        this.refresh_enabled = refresh_enabled;
        if (refresh_enabled) {
            this.repaint(true);
        }
    }

    public boolean isRefreshEnabled() {
        return this.refresh_enabled;
    }

    public void setSelectionXOR(boolean selection_xor) {
        this.selection_xor = selection_xor;
        this.repaint(false);
    }

    public boolean isSelectionXOR() {
        return this.selection_xor;
    }

    public void setTabSize(int tab_size) {
        this.tab_size = tab_size;
    }

    public int getTabSize() {
        return this.tab_size;
    }

    public void setScrollOnInput(boolean scroll_on_input) {
        this.scroll_on_input = scroll_on_input;
    }

    public boolean isScrollOnInput() {
        return this.scroll_on_input;
    }

    public void setScrollOnOutput(boolean scroll_on_output) {
        this.scroll_on_output = scroll_on_output;
    }

    public boolean isScrollOnOutput() {
        return this.scroll_on_output;
    }

    public void setTrackCursor(boolean track_cursor) {
        this.track_cursor = track_cursor;
    }

    public boolean isTrackCursor() {
        return this.track_cursor;
    }

    public void setHorizontallyScrollable(boolean horizontally_scrollable) {
        this.horizontally_scrollable = horizontally_scrollable;
        this.hscroll_wrapper.setVisible(horizontally_scrollable);
    }

    public boolean isHorizontallyScrollable() {
        return this.horizontally_scrollable;
    }

    public void setText(String text) {
        this.clearHistoryNoRefresh();
        this.appendText(text, true);
    }

    public void appendText(String text, boolean repaint) {
        if (text == null) {
            return;
        }
        Term.ckEventDispatchThread();
        int cx = 0;
        while (cx < text.length()) {
            this.putc_work(text.charAt(cx));
            if (text.charAt(cx) == '\n') {
                this.putc_work('\r');
            }
            ++cx;
        }
        if (repaint) {
            this.repaint(true);
        }
    }

    public void pageUp(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx -= n * this.st.rows;
        if (this.st.firstx < 0) {
            this.st.firstx = 0;
        }
        this.repaint(true);
    }

    public void pageDown(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx += n * this.st.rows;
        if (this.st.firstx + this.st.rows > this.buf.nlines) {
            this.st.firstx = this.buf.nlines - this.st.rows;
        }
        this.repaint(true);
    }

    public void lineUp(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx -= n;
        if (this.st.firstx < 0) {
            this.st.firstx = 0;
        }
        this.repaint(true);
    }

    public void lineDown(int n) {
        Term.ckEventDispatchThread();
        this.st.firstx += n;
        if (this.st.firstx + this.st.rows > this.buf.nlines) {
            this.st.firstx = this.buf.nlines - this.st.rows;
        }
        this.repaint(true);
    }

    public void pageLeft(int n) {
        this.columnLeft(n * this.buf.visibleCols());
    }

    public void pageRight(int n) {
        this.columnRight(n * this.buf.visibleCols());
    }

    public void columnRight(int n) {
        Term.ckEventDispatchThread();
        this.st.firsty += n;
        if (this.st.firsty + this.buf.visibleCols() > this.buf.totalCols()) {
            this.st.firsty = this.buf.totalCols() - this.buf.visibleCols();
        }
        this.repaint(true);
    }

    public void columnLeft(int n) {
        Term.ckEventDispatchThread();
        this.st.firsty -= n;
        if (this.st.firsty < 0) {
            this.st.firsty = 0;
        }
        this.repaint(true);
    }

    public int charWidth(char c) {
        return this.metrics.wcwidth(c);
    }

    public void setFont(Font new_font) {
        Font font = new Font("Monospaced", new_font.getStyle(), new_font.getSize());
        super.setFont(font);
        this.metrics = new MyFontMetrics(this, font);
        this.updateScreenSize();
    }

    public void requestFocus() {
        this.screen.requestFocus();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessible_context == null) {
            this.accessible_context = new AccessibleTerm();
        }
        return this.accessible_context;
    }

    public int CoordToPosition(Coord c) {
        BCoord b = c.toBCoord(this.firsta);
        int nchars = this.charsInPrehistory;
        int r = 0;
        while (r < b.row) {
            Line l = this.buf.lineAt(r);
            nchars += l.length();
            if (!l.isWrapped()) {
                ++nchars;
            }
            ++r;
        }
        return nchars += c.col;
    }

    public Coord PositionToCoord(int position) {
        int nchars = this.charsInPrehistory;
        int r = 0;
        while (r < this.buf.nlines) {
            Line l = this.buf.lineAt(r);
            nchars += l.length();
            if (!l.isWrapped()) {
                ++nchars;
            }
            if (nchars > position) {
                BCoord b = new BCoord();
                b.row = r;
                b.col = this.buf.lineAt(r).length() + 1 - (nchars - position);
                return new Coord(b, this.firsta);
            }
            ++r;
        }
        return null;
    }

    int getCharCount() {
        int nchars = this.charsInPrehistory;
        int r = 0;
        while (r < this.buf.nlines) {
            Line l = this.buf.lineAt(r);
            nchars += l.length();
            if (!l.isWrapped()) {
                ++nchars;
            }
            ++r;
        }
        return nchars;
    }

    Rectangle getCharacterBounds(Coord c) {
        if (c == null) {
            return null;
        }
        BCoord b = c.toBCoord(this.firsta);
        char ch = '\u0000';
        try {
            Line l = this.buf.lineAt(b.row);
            ch = l.charArray()[b.col];
        }
        catch (Exception x) {
            // empty catch block
        }
        Point p1 = this.toPixel(b);
        Rectangle rect = new Rectangle();
        rect.x = p1.x;
        rect.y = p1.y;
        rect.width = this.metrics.width * this.charWidth(ch);
        rect.height = this.metrics.height;
        return rect;
    }

    Color backgroundColor(boolean reverse, int attr) {
        Color bg = null;
        if (reverse) {
            int fcx = Attr.foregroundColor(attr);
            bg = fcx != 0 && fcx <= 8 ? this.standard_color[fcx - 1] : (fcx > 8 ? this.custom_color[fcx - 9] : this.actual_foreground);
        } else {
            int bcx = Attr.backgroundColor(attr);
            if (bcx != 0 && bcx <= 8) {
                bg = this.standard_color[bcx - 1];
            } else if (bcx > 8) {
                bg = this.custom_color[bcx - 9];
            }
        }
        return bg;
    }

    Color foregroundColor(boolean reverse, int attr) {
        int fcx;
        int bcx;
        Color fg = null;
        fg = reverse ? ((bcx = Attr.backgroundColor(attr)) != 0 && bcx <= 8 ? this.standard_color[bcx - 1] : (bcx > 8 ? this.custom_color[bcx - 9] : this.actual_background)) : ((fcx = Attr.foregroundColor(attr)) != 0 && fcx <= 8 ? this.standard_color[fcx - 1] : (fcx > 8 ? this.custom_color[fcx - 9] : this.actual_foreground));
        return fg;
    }

    private static void ckEventDispatchThread() {
    }

    static void addMouseWheelHandler(JComponent comp, JScrollBar bar) {
        if (mouseWheelNotSupported) {
            return;
        }
        try {
            Class<?> mouseWheelListener = Class.forName("java.awt.event.MouseWheelListener");
            Object proxy = Proxy.newProxyInstance(mouseWheelListener.getClassLoader(), new Class[]{mouseWheelListener}, (InvocationHandler)new MouseWheelHandler(bar));
            Method m = comp.getClass().getMethod("addMouseWheelListener", mouseWheelListener);
            if (m != null) {
                m.invoke((Object)comp, proxy);
            }
        }
        catch (Throwable t) {
            mouseWheelNotSupported = true;
        }
    }

    static class MouseWheelHandler
    implements InvocationHandler {
        private JScrollBar scrollbar;

        public MouseWheelHandler(JScrollBar scrollbar) {
            this.scrollbar = scrollbar;
        }

        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Class<?> clazz = Class.forName("java.awt.event.MouseWheelEvent");
            Method mgetUnitsToScroll = clazz.getMethod("getUnitsToScroll", null);
            int units = 0;
            if (mgetUnitsToScroll != null) {
                Object o = mgetUnitsToScroll.invoke(args[0], null);
                units = (Integer)o;
            }
            int totalScrollAmount = units * this.scrollbar.getUnitIncrement();
            this.scrollbar.setValue(this.scrollbar.getValue() + totalScrollAmount);
            return null;
        }
    }

    protected class AccessibleTerm
    extends JComponent.AccessibleJComponent {
        protected AccessibleTerm() {
            super(Term.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public void setAccessibleName(String name) {
            Term.this.screen.getAccessibleContext().setAccessibleName(name);
        }
    }

    private class OpsImpl
    implements Ops {
        long last_time = System.currentTimeMillis();

        private OpsImpl() {
        }

        public void op_pause() {
            Thread.currentThread();
            Thread.yield();
        }

        public void op_char(char c) {
            if (Term.this.debugOps()) {
                System.out.println("op_char('" + c + "') = " + c);
            }
            Line l = Term.this.cursor_line();
            int insertion_col = l.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col);
            if (Term.this.debugOps()) {
                System.out.println("op_char(): st.cursor.col " + ((Term)Term.this).st.cursor.col + " insertion_col " + insertion_col);
            }
            if (!((Term)Term.this).st.overstrike) {
                l.insertCharAt(Term.this, ' ', insertion_col, ((Term)Term.this).st.attr);
            }
            int cwidth = Term.this.metrics.wcwidth(c);
            if (l.isAboutToWrap() || cwidth > 1 && ((Term)Term.this).st.cursor.col + cwidth > Term.this.buf.visibleCols() && !Term.this.horizontally_scrollable) {
                if (Term.this.debugOps()) {
                    System.out.println("\twrapping it");
                }
                l.setWrapped(true);
                l.setAboutToWrap(false);
                this.op_line_feed();
                this.op_carriage_return();
                l = Term.this.cursor_line();
                insertion_col = 0;
            }
            l.setCharAt(Term.this, c, insertion_col, ((Term)Term.this).st.attr);
            ((Term)Term.this).st.cursor.col += cwidth;
            if (((Term)Term.this).st.cursor.col >= Term.this.buf.visibleCols() && !Term.this.horizontally_scrollable) {
                if (Term.this.debugOps()) {
                    System.out.println("\tabout to wrap");
                }
                l.setAboutToWrap(true);
                ((Term)Term.this).st.cursor.col -= cwidth;
            }
        }

        public void op_attr(int attr) {
            if (Term.this.debugOps()) {
                System.out.println("op_attr(" + attr + ")");
            }
            Term.this.setAttribute(attr);
        }

        public void op_bel() {
        }

        public void op_back_space() {
            if (Term.this.debugOps()) {
                System.out.println("op_back_space");
            }
            if (((Term)Term.this).st.cursor.col > 0) {
                if (!Term.this.cursor_line().isAboutToWrap()) {
                    --((Term)Term.this).st.cursor.col;
                }
                Term.this.cursor_line().setAboutToWrap(false);
                if (((Term)Term.this).st.cursor.col == 0 && ((Term)Term.this).st.cursor.row > 0) {
                    Line prev;
                    if (Term.this.debugOps()) {
                        System.out.println("\tchecking if prev is wrapped");
                    }
                    if ((prev = Term.this.buf.lineAt(((Term)Term.this).st.cursor.row - 1)).isWrapped()) {
                        if (Term.this.debugOps()) {
                            System.out.println("\tit is");
                        }
                        --((Term)Term.this).st.cursor.row;
                        int last_col = prev.cellToBuf(Term.this.metrics, Term.this.buf.visibleCols() - 1);
                        ((Term)Term.this).st.cursor.col = prev.bufToCell(Term.this.metrics, last_col);
                        prev.setWrapped(false);
                        prev.setAboutToWrap(true);
                    }
                }
            }
        }

        public void op_line_feed() {
            if (Term.this.debugOps()) {
                System.out.println("op_line_feed");
            }
            Line last_line = Term.this.cursor_line();
            ++((Term)Term.this).st.cursor.row;
            if (Term.this.possiblyScrollDown()) {
                Term.this.buf.addLineAt(((Term)Term.this).st.cursor.row);
                Term.this.limit_lines();
                if (Term.this.debugOps()) {
                    System.out.println("op_line_feed ADJUSTED");
                }
            }
            boolean atw = last_line.isAboutToWrap();
            Term.this.cursor_line().setAboutToWrap(atw);
            last_line.setAboutToWrap(false);
            Term.this.n_linefeeds++;
        }

        public void op_tab() {
            if (Term.this.debugOps()) {
                System.out.println("op_tab");
            }
            if (((Term)Term.this).st.cursor.col == Term.this.buf.visibleCols() - 1 && !Term.this.horizontally_scrollable) {
                return;
            }
            Line l = Term.this.cursor_line();
            int insert_col = l.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col);
            l.setCharAt(Term.this, ' ', insert_col, ((Term)Term.this).st.attr);
            ++((Term)Term.this).st.cursor.col;
            ++insert_col;
            while ((((Term)Term.this).st.cursor.col < Term.this.buf.visibleCols() - 1 || Term.this.horizontally_scrollable) && ((Term)Term.this).st.cursor.col % Term.this.tab_size != 0) {
                Term.this.cursor_line().setCharAt(Term.this, ' ', insert_col, ((Term)Term.this).st.attr);
                ++((Term)Term.this).st.cursor.col;
                ++insert_col;
            }
        }

        public void op_carriage_return() {
            if (Term.this.debugOps()) {
                System.out.println("op_carriage_return");
            }
            ((Term)Term.this).st.cursor.col = 0;
            Term.this.cursor_line().setAboutToWrap(false);
        }

        public void op_al(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_al(" + count + ")");
            }
            while (count-- > 0) {
                boolean old_atw = Term.this.cursor_line().setAboutToWrap(false);
                Line l = Term.this.buf.moveLineFromTo(((Term)Term.this).st.firstx + Term.this.botMargin(), ((Term)Term.this).st.cursor.row);
                l.reset();
                Term.this.cursor_line().setAboutToWrap(old_atw);
            }
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row - 1)) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    Term.this.sel.cancel(true);
                    break;
                }
                case 4: {
                    Term.this.sel.adjust(Term.this.firsta, 1);
                }
            }
        }

        public void op_bc(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_bc(" + count + ")");
            }
            while (count-- > 0) {
                if (((Term)Term.this).st.cursor.col <= 0) {
                    return;
                }
                --((Term)Term.this).st.cursor.col;
            }
            Term.this.cursor_line().setAboutToWrap(false);
        }

        public void op_cm(int row, int col) {
            if (Term.this.debugOps()) {
                System.out.println("op_cm(row " + row + ", col " + col + ")");
            }
            if (row == 0) {
                row = 1;
            }
            if (col == 0) {
                col = 1;
            }
            if (row > ((Term)Term.this).st.rows) {
                row = ((Term)Term.this).st.rows;
            }
            if (col > Term.this.buf.visibleCols()) {
                col = Term.this.buf.visibleCols();
            }
            Term.this.cursor_line().setAboutToWrap(false);
            ((Term)Term.this).st.cursor.row = Term.this.beginx() + row - 1;
            ((Term)Term.this).st.cursor.col = col - 1;
        }

        public void op_cl() {
            if (Term.this.debugOps()) {
                System.out.println("op_cl");
            }
            Term.this.cursor_line().setAboutToWrap(false);
            Term.this.clear();
            ((Term)Term.this).st.cursor.row = Term.this.beginx();
            ((Term)Term.this).st.cursor.col = 0;
        }

        public void op_ce() {
            if (Term.this.debugOps()) {
                System.out.println("op_ce");
            }
            Line l = Term.this.cursor_line();
            l.clearToEndFrom(Term.this, l.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col));
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row)) {
                case 0: 
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    Term.this.sel.cancel(true);
                }
            }
        }

        public void op_cd() {
            if (Term.this.debugOps()) {
                System.out.println("op_cd -- clear to end of screen");
            }
            int lx = ((Term)Term.this).st.cursor.row;
            while (lx < Term.this.beginx() + ((Term)Term.this).st.rows) {
                Line l = Term.this.buf.lineAt(lx);
                l.reset();
                ++lx;
            }
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row)) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    Term.this.sel.cancel(true);
                }
            }
        }

        public void op_dc(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_dc(" + count + ")");
            }
            if (count == 0) {
                count = 1;
            }
            Line l = Term.this.cursor_line();
            while (count-- > 0) {
                l.deleteCharAt(l.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col));
            }
        }

        public void op_dl(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_dl(" + count + ")");
            }
            while (count-- > 0) {
                boolean old_atw = Term.this.cursor_line().setAboutToWrap(false);
                Line l = Term.this.buf.moveLineFromTo(((Term)Term.this).st.cursor.row, Term.this.beginx() + Term.this.botMargin() - 1);
                l.reset();
                Term.this.cursor_line().setAboutToWrap(old_atw);
            }
            switch (Term.this.sel.intersection(((Term)Term.this).st.cursor.row)) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    Term.this.sel.cancel(true);
                    break;
                }
                case 4: {
                    Term.this.sel.adjust(Term.this.firsta, -1);
                }
            }
        }

        public void op_do(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_do(" + count + ") -- down");
            }
            boolean old_atw = Term.this.cursor_line().setAboutToWrap(false);
            while (count-- > 0) {
                ++((Term)Term.this).st.cursor.row;
                if (((Term)Term.this).st.cursor.row < Term.this.buf.nlines || !Term.this.possiblyScrollDown()) continue;
                Term.this.buf.addLineAt(((Term)Term.this).st.cursor.row);
                Term.this.limit_lines();
                if (!Term.this.debugOps()) continue;
                System.out.println("op_do ADJUSTED");
            }
            Term.this.cursor_line().setAboutToWrap(old_atw);
        }

        public void op_ho() {
            if (Term.this.debugOps()) {
                System.out.println("op_ho -- home");
            }
            Term.this.cursor_line().setAboutToWrap(false);
            ((Term)Term.this).st.cursor.row = Term.this.beginx();
            ((Term)Term.this).st.cursor.col = 0;
        }

        public void op_ic(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_ic(" + count + ")");
            }
            Line l = Term.this.cursor_line();
            int insertion_col = l.cellToBuf(Term.this.metrics, ((Term)Term.this).st.cursor.col);
            while (count-- > 0) {
                l.insertCharAt(Term.this, ' ', insertion_col, ((Term)Term.this).st.attr);
            }
        }

        public void op_nd(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_nd(" + count + ")");
            }
            int vc = ((Term)Term.this).st.cursor.col;
            while (count-- > 0) {
                if (++vc < Term.this.buf.visibleCols()) continue;
                if (Term.this.debugOps()) {
                    System.out.println("\tbailing out at count " + count);
                }
                --vc;
                break;
            }
            ((Term)Term.this).st.cursor.col = vc;
        }

        public void op_up(int count) {
            if (Term.this.debugOps()) {
                System.out.println("op_up(" + count + ")");
            }
            boolean old_atw = Term.this.cursor_line().setAboutToWrap(false);
            while (count-- > 0) {
                --((Term)Term.this).st.cursor.row;
                if (((Term)Term.this).st.cursor.row >= ((Term)Term.this).st.firstx) continue;
                ((Term)Term.this).st.cursor.row = ((Term)Term.this).st.firstx;
                Line l = Term.this.buf.moveLineFromTo(((Term)Term.this).st.firstx + Term.this.botMargin(), ((Term)Term.this).st.cursor.row);
                l.reset();
            }
            Term.this.cursor_line().setAboutToWrap(old_atw);
        }

        public void op_sc() {
            if (Term.this.debugOps()) {
                System.out.println("op_sc()");
            }
            Term.this.st.saveCursor();
        }

        public void op_rc() {
            if (Term.this.debugOps()) {
                System.out.println("op_rc()");
            }
            Term.this.st.restoreCursor();
        }

        public void op_glyph(int glyph, int rendition) {
            if (Term.this.debugOps()) {
                System.out.println("op_glyph(glyph " + glyph + ", rendition " + rendition + ")");
            }
            Term.this.setGlyph(glyph, rendition);
        }

        public void op_reverse(boolean reverse_video) {
            Term.this.setReverseVideo(reverse_video);
        }

        public void op_cursor_visible(boolean visible) {
            Term.this.setCursorVisible(visible);
        }

        public void op_margin(int from, int to) {
            if (Term.this.debugOps()) {
                System.out.println("op_margin(" + from + ", " + to + ")");
            }
            if (from < 0) {
                Term.this.top_margin = 0;
            } else if (from > ((Term)Term.this).st.rows) {
                Term.this.top_margin = ((Term)Term.this).st.rows;
            } else {
                Term.this.top_margin = from;
            }
            if (to < 0) {
                Term.this.bot_margin = 0;
            } else if (to > ((Term)Term.this).st.rows) {
                Term.this.bot_margin = ((Term)Term.this).st.rows;
            } else {
                Term.this.bot_margin = to;
            }
            if (Term.this.top_margin > Term.this.bot_margin) {
                int tmp = Term.this.top_margin;
                Term.this.top_margin = Term.this.bot_margin;
                Term.this.bot_margin = tmp;
            }
        }

        public void op_time(boolean repaint) {
            long time = System.currentTimeMillis();
            long elapsed = time - this.last_time;
            Date d = new Date(time);
            String date_str = d.toString();
            String elapsed_str = "" + elapsed / 1000L + "." + elapsed % 1000L;
            String output1 = date_str + " Elapsed (sec): " + elapsed_str;
            String output2 = "putChar " + Term.this.n_putchar + "  putChars " + Term.this.n_putchars + "  linefeeds " + Term.this.n_linefeeds + "  repaint " + Term.this.n_repaint + "  paint " + Term.this.n_paint;
            Term.this.setAttribute(41);
            int sx = 0;
            while (sx < output1.length()) {
                this.op_char(output1.charAt(sx));
                ++sx;
            }
            this.op_line_feed();
            this.op_carriage_return();
            int sx2 = 0;
            while (sx2 < output2.length()) {
                this.op_char(output2.charAt(sx2));
                ++sx2;
            }
            Term.this.setAttribute(0);
            this.last_time = time;
            Term.this.n_putchar = 0;
            Term.this.n_putchars = 0;
            Term.this.n_linefeeds = 0;
            Term.this.n_paint = 0;
            Term.this.n_repaint = 0;
            Term.this.repaint(true);
        }

        public int op_get_width() {
            return Term.this.horizontally_scrollable ? Term.this.buf.totalCols() : Term.this.buf.visibleCols();
        }

        public int op_get_column() {
            return ((Term)Term.this).st.cursor.col;
        }

        public void op_soft_reset() {
            ((Term)Term.this).st.overstrike = true;
            Term.this.top_margin = 0;
            Term.this.bot_margin = 0;
            ((Term)Term.this).st.attr = 0;
            Term.this.repaint(false);
        }

        public void op_full_reset() {
            this.op_soft_reset();
            this.op_cl();
            Term.this.reverse_video = false;
            Term.this.repaint(false);
        }

        public void op_set_mode(int mode) {
            switch (mode) {
                case 4: {
                    ((Term)Term.this).st.overstrike = false;
                    break;
                }
            }
        }

        public void op_reset_mode(int mode) {
            switch (mode) {
                case 4: {
                    ((Term)Term.this).st.overstrike = true;
                    break;
                }
            }
        }

        public void op_status_report(int code) {
            switch (code) {
                case 5: {
                    Term.this.reply("\u001b[0n");
                    break;
                }
                case 6: {
                    Term.this.reply("\u001b[" + (((Term)Term.this).st.cursor.row - ((Term)Term.this).st.firstx) + ";" + ((Term)Term.this).st.cursor.col + "R");
                }
            }
        }
    }

    private class Scroller
    extends Thread {
        public static final int UP = 2;
        public static final int DOWN = 4;
        public static final int LEFT = 8;
        public static final int RIGHT = 16;
        private int direction;

        public Scroller(int direction) {
            this.direction = direction;
        }

        private boolean extend() {
            Term.ckEventDispatchThread();
            if (((Term)Term.this).sel.sel_extent == null) {
                return false;
            }
            BCoord x = ((Term)Term.this).sel.sel_extent.toBCoord(Term.this.firsta);
            BCoord v = Term.this.toViewCoord(x);
            int r = v.row;
            int c = v.col;
            if ((this.direction & 4) == 4) {
                Term.this.lineDown(1);
                r = ((Term)Term.this).st.rows - 1;
                c = Term.this.buf.totalCols();
            } else if ((this.direction & 2) == 2) {
                Term.this.lineUp(1);
                r = 0;
                c = 0;
            } else {
                BCoord vc2 = Term.this.toViewCoord(Term.this.drag_point);
                r = vc2.row;
                c = vc2.col;
            }
            if ((this.direction & 8) == 8) {
                --((Term)Term.this).st.firsty;
                if (((Term)Term.this).st.firsty < 0) {
                    ((Term)Term.this).st.firsty = 0;
                }
                c = 0;
            } else if ((this.direction & 0x10) == 16) {
                ++((Term)Term.this).st.firsty;
                int limit = Term.this.buf.totalCols() - Term.this.buf.visibleCols();
                if (limit < 0) {
                    limit = 0;
                }
                if (((Term)Term.this).st.firsty > limit) {
                    ((Term)Term.this).st.firsty = limit;
                }
                c = ((Term)Term.this).st.firsty + Term.this.buf.visibleCols();
            }
            BCoord vc = new BCoord(r, c);
            BCoord bc = Term.this.toBufCoords(vc);
            Term.this.sel.track(new Coord(bc, Term.this.firsta));
            Term.this.repaint(true);
            return true;
        }

        public void run() {
            while (true) {
                this.extend();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException x) {
                    return;
                }
            }
        }
    }

    private class BaseTermStream
    extends TermStream {
        private BaseTermStream() {
        }

        public void flush() {
            Term.this.repaint(true);
        }

        public void putChar(char c) {
            Term.ckEventDispatchThread();
            Term.this.n_putchar++;
            Term.this.putc_work(c);
            Term.this.possibly_repaint(true);
        }

        public void putChars(char[] buf, int offset, int count) {
            Term.ckEventDispatchThread();
            Term.this.n_putchars++;
            int bx = 0;
            while (bx < count) {
                Term.this.putc_work(buf[offset + bx]);
                ++bx;
            }
            Term.this.possibly_repaint(true);
        }

        public void sendChar(char c) {
            Term.this.fireChar(c);
        }

        public void sendChars(char[] buf, int offset, int count) {
            Term.this.fireChars(buf, offset, count);
        }
    }

    private class ScrollWrapper
    extends JComponent
    implements Accessible {
        public JScrollBar scroll_bar;
        private AccessibleContext accessible_context;

        public ScrollWrapper(JScrollBar scroll_bar) {
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            int slop = ((Term)Term.this).vscroll_bar.getMaximumSize().width;
            gbc.insets = new Insets(0, 0, 0, slop);
            this.add((Component)scroll_bar, gbc);
            this.scroll_bar = scroll_bar;
        }

        protected void paintComponent(Graphics g) {
            Dimension sz = this.getSize();
            g.clearRect(0, 0, sz.width, sz.height);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessible_context == null) {
                this.accessible_context = new AccessibleScrollWrapper();
            }
            return this.accessible_context;
        }

        protected class AccessibleScrollWrapper
        extends JComponent.AccessibleJComponent {
            protected AccessibleScrollWrapper() {
                super(ScrollWrapper.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }
}

