/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcs.cmdline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.vcs.advanced.CommandLineVcsFileSystem;
import org.netbeans.modules.vcscore.VcsConfigVariable;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.openide.filesystems.FileSystemCapability;

public class CvsFileSystem
extends VcsFileSystem
implements PropertyChangeListener {
    static final String PS_SERVER = "/";
    static final String PS_LOCAL = File.separator;
    private static final String[] VARIABLES_TO_TRANSFER = new String[]{"SERVERTYPE", "CVS_SERVER", "CVS_USERNAME", "CVS_REPOSITORY", "CVS_EXE", "SHELL", "ENVIRONMENT_VAR_CVS_RSH"};
    private String cvsServerType;
    private String cvsRoot;
    private String cvsServer;
    private String cvsUser;
    private String cvsPassword;
    private String cvsModule;
    private String cvsModuleName;
    private String cvsExePath;
    private String cygwinPath;
    private transient boolean doInitialCheckout = false;
    private static final String CACHE_FILE_FOLDER = "CVS";
    private static final String CACHE_FILE_NAME = "netbeans.cmd.cache";
    private boolean executePreCommit = true;
    static final long serialVersionUID = 3105697696081480308L;
    private static final String CONFIG_CVS_UNIX = "cvsUnix.xml";
    private static final String CONFIG_CVS_WIN = "cvsWin.xml";
    private static final String CONFIG_CVS_WIN98 = "cvsWin98.xml";

    private CommandLineVcsFileSystem createCommandLineVcsFileSystem() {
        String os = System.getProperty("os.name");
        String configFileName = os.indexOf("Win") >= 0 ? (this.isUseUnixShell() ? CONFIG_CVS_WIN98 : CONFIG_CVS_WIN) : CONFIG_CVS_UNIX;
        CommandLineVcsFileSystem fs = new CommandLineVcsFileSystem();
        fs.readConfiguration(configFileName);
        fs.setConfigFileName(configFileName);
        Vector vars = fs.getVariables();
        HashMap<String, VcsConfigVariable> varsByName = new HashMap<String, VcsConfigVariable>();
        int i = 0;
        int n = vars.size();
        while (i < n) {
            VcsConfigVariable var = (VcsConfigVariable)vars.get(i);
            varsByName.put(var.getName(), var);
            ++i;
        }
        Set clvfsVarNames = varsByName.keySet();
        Hashtable cvsVariables = this.getVariablesByName();
        int i2 = 0;
        while (i2 < VARIABLES_TO_TRANSFER.length) {
            VcsConfigVariable var;
            String cvsVarName = VARIABLES_TO_TRANSFER[i2];
            VcsConfigVariable cvsVar = (VcsConfigVariable)cvsVariables.get(cvsVarName);
            if (cvsVar != null) {
                var = (VcsConfigVariable)varsByName.get(cvsVarName);
                if (var != null) {
                    var.setValue(cvsVar.getValue());
                } else {
                    vars.add(cvsVar);
                }
            } else if ("CVS_USERNAME".equals(cvsVarName)) {
                var = (VcsConfigVariable)varsByName.get(cvsVarName);
                if (var != null) {
                    var.setValue(this.cvsUser);
                } else {
                    vars.add(new VcsConfigVariable("CVS_USERNAME", "", this.cvsUser, false, false, false, null));
                }
            }
            ++i2;
        }
        if ("local".equals(this.cvsServerType)) {
            VcsConfigVariable var = (VcsConfigVariable)varsByName.get("CVS_SERVER");
            if (var != null) {
                var.setValue("");
            }
            if ((var = (VcsConfigVariable)varsByName.get("CVS_USERNAME")) != null) {
                var.setValue("");
            }
        }
        fs.setVariables(vars);
        fs.setExpertMode(this.isExpertMode());
        fs.setAnnotationPattern(this.getAnnotationPattern());
        fs.setAutoRefresh(this.getAutoRefresh());
        fs.setCommandNotification(this.isCommandNotification());
        fs.setOffLine(this.isOffLine());
        fs.setDebug(this.getDebug());
        fs.setProcessUnimportantFiles(this.isProcessUnimportantFiles());
        fs.setHideShadowFiles(this.isHideShadowFiles());
        fs.setCapableCompile(this.getCapability().capableOf(FileSystemCapability.COMPILE));
        fs.setCapableDebug(this.getCapability().capableOf(FileSystemCapability.DEBUG));
        fs.setCapableDoc(this.getCapability().capableOf(FileSystemCapability.DOC));
        fs.setCapableExecute(this.getCapability().capableOf(FileSystemCapability.EXECUTE));
        return fs;
    }

    public String getCacheFileName(String path) {
        File cacheDir = this.getFile(path + File.separator + CACHE_FILE_FOLDER);
        if (!cacheDir.exists() || !cacheDir.isDirectory()) {
            return null;
        }
        return new File(cacheDir, CACHE_FILE_NAME).getAbsolutePath();
    }

    private Hashtable getVariablesByName() {
        return this.variablesByName;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != "valid") {
            return;
        }
        if (this.isValid()) {
            this.setRefreshTime(this.refreshTimeToSet);
            this.warnDirectoriesDoNotExists();
        } else {
            this.setRefreshTime(0);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException, NotActiveException {
        in.defaultReadObject();
        this.setCreateVersioningSystem(true);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private Object readResolve() throws ObjectStreamException {
        return this.createCommandLineVcsFileSystem();
    }
}

