/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openidex.nodes.looks.DefaultLook;
import org.openidex.nodes.looks.Look;

public class FilterLook
extends DefaultLook {
    public static final long ALL_METHODS = Integer.MAX_VALUE;
    public static final long NO_METHODS = 0L;
    public static final long ATTACH_TO = 1L;
    public static final long GET_COOKIE = 2L;
    public static final long GET_HANDLE = 4L;
    public static final long GET_DISPLAY_NAME = 8L;
    public static final long GET_NAME = 16L;
    public static final long SET_NAME = 32L;
    public static final long GET_SHORT_DESCRIPTION = 64L;
    public static final long GET_ICON = 128L;
    public static final long GET_OPENED_ICON = 256L;
    public static final long GET_HELP_CTX = 512L;
    public static final long GET_CHILD_OBJECTS = 1024L;
    public static final long GET_NEW_TYPES = 2048L;
    public static final long GET_ACTIONS = 4096L;
    public static final long GET_CONTEXT_ACTIONS = 8192L;
    public static final long GET_DEFAULT_ACTION = 16384L;
    public static final long GET_PROPERTY_SETS = 32768L;
    public static final long GET_CUSTOMIZER = 65536L;
    public static final long CAN_RENAME = 131072L;
    public static final long CAN_DESTROY = 262144L;
    public static final long CAN_COPY = 524288L;
    public static final long CAN_CUT = 0x100000L;
    public static final long GET_PASTE_TYPES = 0x200000L;
    public static final long GET_DROP_TYPE = 0x400000L;
    public static final long CLIPBOARD_COPY = 0x800000L;
    public static final long CLIPBOARD_CUT = 0x1000000L;
    public static final long DRAG = 0x2000000L;
    public static final long DESTROY = 0x4000000L;
    protected long mask = Integer.MAX_VALUE;
    protected Look delegate;

    public FilterLook(Look delegate) {
        this.delegate = delegate;
    }

    private boolean filterMethod(long method) {
        return (this.mask & method) > 0L;
    }

    public boolean isLookStandalone(Object representedObject) {
        return this.delegate.isLookStandalone(representedObject);
    }

    public void setLookMask(long mask) {
        this.mask = mask;
    }

    public long getLookMask() {
        return this.mask;
    }

    public long lookMask(long methods) {
        this.mask |= methods;
        return this.mask;
    }

    public long lookUnmask(long methods) {
        this.mask &= methods ^ 0xFFFFFFFFFFFFFFFFL;
        return this.mask;
    }

    public void attachTo(Look.NodeSubstitute substitute) {
        if (this.filterMethod(1L)) {
            this.delegate.attachTo(new FilterNodeSubstitute(substitute, this));
        } else {
            super.attachTo(substitute);
        }
    }

    public Node.Cookie getCookie(Look.NodeSubstitute substitute, Class type) {
        if (this.filterMethod(2L)) {
            return this.delegate.getCookie(substitute, type);
        }
        return super.getCookie(substitute, type);
    }

    public Node.Handle getHandle(Look.NodeSubstitute substitute) {
        if (this.filterMethod(4L)) {
            return this.delegate.getHandle(substitute);
        }
        return super.getHandle(substitute);
    }

    public String getDisplayName(Look.NodeSubstitute substitute) {
        if (this.filterMethod(8L)) {
            return this.delegate.getDisplayName(substitute);
        }
        return super.getDisplayName(substitute);
    }

    public String getName(Look.NodeSubstitute substitute) {
        if (this.filterMethod(16L)) {
            return this.delegate.getName(substitute);
        }
        return super.getName(substitute);
    }

    public void setName(Look.NodeSubstitute substitute, String newName) {
        if (this.filterMethod(32L)) {
            this.delegate.setName(substitute, newName);
        } else {
            super.setName(substitute, newName);
        }
    }

    public String getShortDescription(Look.NodeSubstitute substitute) {
        if (this.filterMethod(64L)) {
            return this.delegate.getShortDescription(substitute);
        }
        return super.getShortDescription(substitute);
    }

    public Image getIcon(Look.NodeSubstitute substitute, int type) {
        if (this.filterMethod(128L)) {
            return this.delegate.getIcon(substitute, type);
        }
        return super.getIcon(substitute, type);
    }

    public Image getOpenedIcon(Look.NodeSubstitute substitute, int type) {
        if (this.filterMethod(256L)) {
            return this.delegate.getOpenedIcon(substitute, type);
        }
        return super.getOpenedIcon(substitute, type);
    }

    public HelpCtx getHelpCtx(Look.NodeSubstitute substitute) {
        if (this.filterMethod(512L)) {
            return this.delegate.getHelpCtx(substitute);
        }
        return super.getHelpCtx(substitute);
    }

    public Object[] getChildObjects(Look.NodeSubstitute substitute) {
        if (this.filterMethod(1024L)) {
            return this.delegate.getChildObjects(substitute);
        }
        return super.getChildObjects(substitute);
    }

    public NewType[] getNewTypes(Look.NodeSubstitute substitute) {
        if (this.filterMethod(2048L)) {
            return this.delegate.getNewTypes(substitute);
        }
        return super.getNewTypes(substitute);
    }

    public SystemAction[] getActions(Look.NodeSubstitute substitute) {
        if (this.filterMethod(4096L)) {
            return this.delegate.getActions(substitute);
        }
        return super.getActions(substitute);
    }

    public SystemAction[] getContextActions(Look.NodeSubstitute substitute) {
        if (this.filterMethod(8192L)) {
            return this.delegate.getContextActions(substitute);
        }
        return super.getContextActions(substitute);
    }

    public SystemAction getDefaultAction(Look.NodeSubstitute substitute) {
        if (this.filterMethod(16384L)) {
            return this.delegate.getDefaultAction(substitute);
        }
        return super.getDefaultAction(substitute);
    }

    public Node.PropertySet[] getPropertySets(Look.NodeSubstitute substitute) {
        if (this.filterMethod(32768L)) {
            return this.delegate.getPropertySets(substitute);
        }
        return super.getPropertySets(substitute);
    }

    public Component getCustomizer(Look.NodeSubstitute substitute) {
        if (this.filterMethod(65536L)) {
            return this.delegate.getCustomizer(substitute);
        }
        return super.getCustomizer(substitute);
    }

    public boolean canRename(Look.NodeSubstitute substitute) {
        if (this.filterMethod(131072L)) {
            return this.delegate.canRename(substitute);
        }
        return super.canRename(substitute);
    }

    public boolean canDestroy(Look.NodeSubstitute substitute) {
        if (this.filterMethod(262144L)) {
            return this.delegate.canDestroy(substitute);
        }
        return super.canDestroy(substitute);
    }

    public boolean canCopy(Look.NodeSubstitute substitute) {
        if (this.filterMethod(524288L)) {
            return this.delegate.canCopy(substitute);
        }
        return super.canCopy(substitute);
    }

    public boolean canCut(Look.NodeSubstitute substitute) {
        if (this.filterMethod(0x100000L)) {
            return this.delegate.canCut(substitute);
        }
        return super.canCut(substitute);
    }

    public PasteType[] getPasteTypes(Look.NodeSubstitute substitute, Transferable t) {
        if (this.filterMethod(0x200000L)) {
            return this.delegate.getPasteTypes(substitute, t);
        }
        return super.getPasteTypes(substitute, t);
    }

    public PasteType getDropType(Look.NodeSubstitute substitute, Transferable t, int action, int index) {
        if (this.filterMethod(0x400000L)) {
            return this.delegate.getDropType(substitute, t, action, index);
        }
        return super.getDropType(substitute, t, action, index);
    }

    public Transferable clipboardCopy(Look.NodeSubstitute substitute) throws IOException {
        if (this.filterMethod(0x800000L)) {
            return this.delegate.clipboardCopy(substitute);
        }
        return super.clipboardCopy(substitute);
    }

    public Transferable clipboardCut(Look.NodeSubstitute substitute) throws IOException {
        if (this.filterMethod(0x1000000L)) {
            return this.delegate.clipboardCut(substitute);
        }
        return super.clipboardCut(substitute);
    }

    public Transferable drag(Look.NodeSubstitute substitute) throws IOException {
        if (this.filterMethod(0x2000000L)) {
            return this.delegate.drag(substitute);
        }
        return super.drag(substitute);
    }

    public void destroy(Look.NodeSubstitute substitute) throws IOException {
        if (this.filterMethod(0x4000000L)) {
            this.delegate.destroy(substitute);
        } else {
            super.destroy(substitute);
        }
    }

    static class FilterNodeSubstitute
    extends Look.NodeSubstitute {
        private FilterLook filterLook;
        private Look.NodeSubstitute substitute;

        FilterNodeSubstitute(Look.NodeSubstitute substitute, FilterLook filterLook) {
            this.substitute = substitute;
            this.filterLook = filterLook;
        }

        public Object getRepresentedObject() {
            return this.substitute.getRepresentedObject();
        }

        public void firePropertySetsChange(Node.PropertySet[] o, Node.PropertySet[] n) {
            if (this.filterLook.filterMethod(32768L)) {
                this.substitute.firePropertySetsChange(o, n);
            }
        }

        public void fireNameChange(String o, String n) {
            if (this.filterLook.filterMethod(16L)) {
                this.substitute.fireNameChange(o, n);
            }
        }

        public void fireCookieChange() {
            if (this.filterLook.filterMethod(2L)) {
                this.substitute.fireCookieChange();
            }
        }

        public void fireDisplayNameChange(String o, String n) {
            if (this.filterLook.filterMethod(8L)) {
                this.substitute.fireDisplayNameChange(o, n);
            }
        }

        public void refreshChildren() {
            if (this.filterLook.filterMethod(1024L)) {
                this.substitute.refreshChildren();
            }
        }

        public void fireOpenedIconChange() {
            if (this.filterLook.filterMethod(256L)) {
                this.substitute.fireOpenedIconChange();
            }
        }

        public void fireNodeDestroyed() {
            if (this.filterLook.filterMethod(0x4000000L)) {
                this.substitute.fireNodeDestroyed();
            }
        }

        public void fireIconChange() {
            if (this.filterLook.filterMethod(128L)) {
                this.substitute.fireIconChange();
            }
        }

        public void fireShortDescriptionChange(String o, String n) {
            if (this.filterLook.filterMethod(64L)) {
                this.substitute.fireShortDescriptionChange(o, n);
            }
        }

        public void firePropertyChange(String name, Object o, Object n) {
            if (this.filterLook.filterMethod(32768L)) {
                this.substitute.firePropertyChange(name, o, n);
            }
        }

        public CookieSet getCookieSet() {
            return this.substitute.getCookieSet();
        }
    }
}

