/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.util.Enumeration;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openidex.nodes.looks.Look;

final class JndiLook {
    private static Object context;

    JndiLook() {
    }

    public static Look findLook(Class c) {
        if (context == null) {
            try {
                context = new InitialContext().lookup("Looks/Types");
            }
            catch (NamingException ex) {
                context = ex;
            }
        }
        if (context instanceof Context) {
            return JndiLook.findLook((Context)context, JndiLook.forClass(c));
        }
        return null;
    }

    private static Look findLook(Context namespace, Enumeration names) {
        while (names.hasMoreElements()) {
            try {
                String check = (String)names.nextElement();
                NamingEnumeration<Binding> en = namespace.listBindings(check);
                while (en.hasMoreElements()) {
                    Binding b = en.next();
                    Object o = b.getObject();
                    if (!(o instanceof Look)) continue;
                    return (Look)o;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Enumeration forClass(Class c) {
        QueueEnumeration en = new QueueEnumeration(){

            protected void process(Object o) {
                Class x = (Class)o;
                Class s = x.getSuperclass();
                if (s != null) {
                    this.put(s);
                    this.put(x.getInterfaces());
                }
            }
        };
        en.put((Object)c);
        return new AlterEnumeration((Enumeration)en){

            protected Object alter(Object clazz) {
                Class c2 = (Class)clazz;
                return c2.getName().replace('.', '/');
            }
        };
    }
}

