/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openidex.nodes.looks.DefaultLook;
import org.openidex.nodes.looks.Look;
import org.openidex.nodes.looks.LookChildren;
import org.openidex.nodes.looks.LookProperties;

public final class LookNode
extends Node
implements Node.Cookie {
    private static Image DEFAULT_ICON_16;
    private static Image DEFAULT_ICON_32;
    private static final String DEFAULT_ICON_16_NAME = "org/openidex/nodes/looks/resources/defaultNode.gif";
    private static final String DEFAULT_ICON_32_NAME = "org/openidex/nodes/looks/resources/defaultNode32.gif";
    private SubstituteImpl substitute = null;
    private final String lock = "LookNode.lock";
    private Look look = null;
    private Look lookCandidate = null;
    private CookieSet cookieSet = null;
    static /* synthetic */ Class class$org$openidex$nodes$looks$Look;
    static /* synthetic */ Class class$org$openidex$nodes$looks$LookNode;

    public LookNode(Object representedObject) {
        this(representedObject, null);
    }

    public LookNode(Object representedObject, Look look) {
        super((Children)new LookChildren());
        this.substitute = new SubstituteImpl(representedObject);
        this.look = look;
        if (look != null) {
            look.attachTo(this.substitute);
        }
    }

    Look.NodeSubstitute getSubstitute() {
        return this.substitute;
    }

    public Object getRepresentedObject() {
        return this.substitute.getRepresentedObject();
    }

    public void setLook(Look look) {
        this.lookCandidate = look;
        this.look = look;
        this.getLook().attachTo(this.getSubstitute());
        this.fireCookieChange();
        this.refreshChildren();
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    private CookieSet getCookieSet() {
        CookieSet cs = this.cookieSet;
        if (cs != null) {
            return cs;
        }
        LookNode lookNode = this;
        synchronized (lookNode) {
            if (this.cookieSet != null) {
                CookieSet cookieSet = this.cookieSet;
                return cookieSet;
            }
            this.cookieSet = new CookieSet();
            this.cookieSet.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    LookNode.super.fireCookieChange();
                }
            });
            CookieSet cookieSet = this.cookieSet;
            return cookieSet;
        }
    }

    void refreshChildren() {
        ((LookChildren)this.getChildren()).refreshChildren();
    }

    public Look getLook() {
        if (this.look != null) {
            return this.look;
        }
        Node parentNode = this.getParentNode();
        if (parentNode == null || !(parentNode instanceof LookNode)) {
            if (this.lookCandidate != null) {
                this.look = this.lookCandidate;
                this.look.attachTo(this.substitute);
                return this.look;
            }
            return DefaultLook.INSTANCE;
        }
        return ((LookNode)parentNode).getLook();
    }

    final Look getHardLook() {
        return this.look;
    }

    public Node.Cookie getCookie(Class type) {
        if (type == (class$org$openidex$nodes$looks$Look == null ? (class$org$openidex$nodes$looks$Look = LookNode.class$("org.openidex.nodes.looks.Look")) : class$org$openidex$nodes$looks$Look)) {
            return this.getLook();
        }
        if (type == (class$org$openidex$nodes$looks$LookNode == null ? (class$org$openidex$nodes$looks$LookNode = LookNode.class$("org.openidex.nodes.looks.LookNode")) : class$org$openidex$nodes$looks$LookNode)) {
            return this;
        }
        Node.Cookie cookie = this.getCookieSet().getCookie(type);
        if (cookie == null) {
            return this.getLook().getCookie(this.substitute, type);
        }
        return cookie;
    }

    public Node.Handle getHandle() {
        return this.getLook().getHandle(this.substitute);
    }

    public Node cloneNode() {
        LookNode clone = new LookNode(this.getRepresentedObject());
        clone.lookCandidate = this.look != null ? this.look : this.lookCandidate;
        return clone;
    }

    public String getDisplayName() {
        String displayName = this.getLook().getDisplayName(this.substitute);
        if (displayName == null) {
            return this.getName();
        }
        return displayName;
    }

    public void setDisplayName(String name) {
    }

    public String getName() {
        return this.getLook().getName(this.substitute);
    }

    public void setName(String s) {
        this.getLook().setName(this.substitute, s);
    }

    public void setShortDescription(String shortDescription) {
    }

    public String getShortDescription() {
        String shortDescription = this.getLook().getShortDescription(this.substitute);
        if (shortDescription == null) {
            return this.getDisplayName();
        }
        return shortDescription;
    }

    public Image getIcon(int type) {
        Image icon = this.getLook().getIcon(this.substitute, type);
        if (icon == null) {
            if (type == 2 || type == 4) {
                if (DEFAULT_ICON_32 == null) {
                    DEFAULT_ICON_32 = Utilities.loadImage((String)DEFAULT_ICON_32_NAME);
                }
                return DEFAULT_ICON_32;
            }
            if (DEFAULT_ICON_16 == null) {
                DEFAULT_ICON_16 = Utilities.loadImage((String)DEFAULT_ICON_16_NAME);
            }
            return DEFAULT_ICON_16;
        }
        return icon;
    }

    public Image getOpenedIcon(int type) {
        Image icon = this.getLook().getOpenedIcon(this.substitute, type);
        if (icon == null) {
            return this.getIcon(type);
        }
        return icon;
    }

    public HelpCtx getHelpCtx() {
        return this.getLook().getHelpCtx(this.substitute);
    }

    public NewType[] getNewTypes() {
        return this.getLook().getNewTypes(this.substitute);
    }

    public SystemAction[] getActions() {
        SystemAction[] systemActions = this.getLook().getActions(this.substitute);
        if (systemActions == null) {
            systemActions = super.getActions();
        }
        int actlen = systemActions.length;
        SystemAction[] mergedActions = new SystemAction[actlen + 2];
        System.arraycopy(systemActions, 0, mergedActions, 0, actlen);
        SystemAction sla = LookProperties.getSetLookAction(this);
        System.arraycopy(new SystemAction[]{null, sla}, 0, mergedActions, actlen, 2);
        return mergedActions;
    }

    public SystemAction[] getContextActions() {
        return this.getLook().getContextActions(this.substitute);
    }

    public SystemAction getDefaultAction() {
        return this.getLook().getDefaultAction(this.substitute);
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet[] sets = this.getLook().getPropertySets(this.substitute);
        Node.PropertySet[] all = new Node.PropertySet[sets.length + 1];
        System.arraycopy(sets, 0, all, 0, sets.length);
        Sheet.Set set = LookProperties.getLookPropertySet(this);
        all[all.length - 1] = set;
        return all;
    }

    public Component getCustomizer() {
        return this.getLook().getCustomizer(this.substitute);
    }

    public boolean hasCustomizer() {
        return this.getLook().hasCustomizer(this.substitute);
    }

    public boolean canRename() {
        return this.getLook().canRename(this.substitute);
    }

    public boolean canDestroy() {
        return this.getLook().canDestroy(this.substitute);
    }

    public boolean canCopy() {
        return this.getLook().canCopy(this.substitute);
    }

    public boolean canCut() {
        return this.getLook().canCut(this.substitute);
    }

    public PasteType[] getPasteTypes(Transferable t) {
        return this.getLook().getPasteTypes(this.substitute, t);
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return this.getLook().getDropType(this.substitute, t, action, index);
    }

    public Transferable clipboardCopy() throws IOException {
        return this.getLook().clipboardCopy(this.substitute);
    }

    public Transferable clipboardCut() throws IOException {
        return this.getLook().clipboardCut(this.substitute);
    }

    public Transferable drag() throws IOException {
        return this.getLook().drag(this.substitute);
    }

    public void destroy() throws IOException {
        this.getLook().destroy(this.substitute);
        super.destroy();
    }

    boolean hasLookNodeParent() {
        Node parent = this.getParentNode();
        return parent != null && parent instanceof LookNode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SubstituteImpl
    extends Look.NodeSubstitute {
        private Object representedObject;
        private CookieSet cookieSet;

        private SubstituteImpl(Object representedObject) {
            this.representedObject = representedObject;
        }

        public Object getRepresentedObject() {
            return this.representedObject;
        }

        public final void firePropertyChange(String name, Object o, Object n) {
            LookNode.super.firePropertyChange(name, o, n);
        }

        public final void fireNameChange(String o, String n) {
            LookNode.super.fireNameChange(o, n);
        }

        public final void fireDisplayNameChange(String o, String n) {
            LookNode.super.fireDisplayNameChange(o, n);
        }

        public final void fireShortDescriptionChange(String o, String n) {
            LookNode.super.fireShortDescriptionChange(o, n);
        }

        public final void fireIconChange() {
            LookNode.super.fireIconChange();
        }

        public final void fireOpenedIconChange() {
            LookNode.super.fireOpenedIconChange();
        }

        public final void firePropertySetsChange(Node.PropertySet[] o, Node.PropertySet[] n) {
            LookNode.super.firePropertySetsChange(o, n);
        }

        public final void fireCookieChange() {
            LookNode.super.fireCookieChange();
        }

        public final void fireNodeDestroyed() {
            LookNode.super.fireNodeDestroyed();
        }

        public final void refreshChildren() {
            LookNode.this.refreshChildren();
        }

        public CookieSet getCookieSet() {
            if (this.cookieSet == null) {
                this.cookieSet = new CookieSet();
            }
            return this.cookieSet;
        }
    }
}

