/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.nodes.looks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openidex.nodes.looks.Look;
import org.openidex.nodes.looks.LookNode;

class LookProperties {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$openidex$nodes$looks$LookProperties == null ? (class$org$openidex$nodes$looks$LookProperties = LookProperties.class$("org.openidex.nodes.looks.LookProperties")) : class$org$openidex$nodes$looks$LookProperties));
    public static final String LOOK_SHEET_SET_NAME = "Look";
    private static final String DEFAULT = bundle.getString("CTL_Default");
    static /* synthetic */ Class class$org$openidex$nodes$looks$LookProperties;
    static /* synthetic */ Class class$org$openidex$nodes$looks$LookProperties$SetLookAction;

    LookProperties() {
    }

    public static SystemAction getSetLookAction(LookNode node) {
        SetLookAction setLookAction = (SetLookAction)SystemAction.get((Class)(class$org$openidex$nodes$looks$LookProperties$SetLookAction == null ? (class$org$openidex$nodes$looks$LookProperties$SetLookAction = LookProperties.class$("org.openidex.nodes.looks.LookProperties$SetLookAction")) : class$org$openidex$nodes$looks$LookProperties$SetLookAction));
        setLookAction.setLookNode(node);
        return setLookAction;
    }

    public static Sheet.Set getLookPropertySet(LookNode node) {
        Sheet.Set set = new Sheet.Set();
        set.setName(LOOK_SHEET_SET_NAME);
        set.setDisplayName(bundle.getString("CTL_LookSheetSetName"));
        set.put((Node.Property)new LookProperty(node));
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class LookItemListener
    implements ActionListener {
        private LookNode lookNode;
        private Look look;

        LookItemListener(LookNode lookNode, Look look) {
            this.lookNode = lookNode;
            this.look = look;
        }

        public void actionPerformed(ActionEvent evt) {
            this.lookNode.setLook(this.look);
        }
    }

    private static final class MainItemListener
    implements MenuListener {
        private JMenu menu;
        private LookNode lookNode;

        public MainItemListener(LookNode lookNode) {
            this.lookNode = lookNode;
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            menu.removeAll();
        }

        public void menuSelected(MenuEvent e) {
            this.menu = (JMenu)e.getSource();
            if (this.lookNode.hasLookNodeParent()) {
                this.menu.add(this.createMenuItem(this.lookNode, null));
            }
            if (this.lookNode != null) {
                Look[] looks = LookEditor.getAllLooks(this.lookNode);
                int i = 0;
                while (i < looks.length) {
                    this.menu.add(this.createMenuItem(this.lookNode, looks[i]));
                    ++i;
                }
            }
        }

        private JMenuItem createMenuItem(LookNode lookNode, Look look) {
            JMenuItem curMenu = new JMenuItem();
            if (look == null) {
                Actions.setMenuText((AbstractButton)curMenu, (String)DEFAULT, (boolean)true);
                curMenu.addActionListener(new LookItemListener(lookNode, null));
            } else {
                Actions.setMenuText((AbstractButton)curMenu, (String)look.getName(), (boolean)true);
                curMenu.addActionListener(new LookItemListener(lookNode, look));
            }
            return curMenu;
        }
    }

    public static class SetLookAction
    extends NodeAction {
        private LookNode lookNode = null;
        static /* synthetic */ Class class$org$openidex$nodes$looks$LookProperties$SetLookAction;

        public String getName() {
            return bundle.getString("ACT_SetLook");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void setLookNode(LookNode lookNode) {
            this.lookNode = lookNode;
        }

        public JMenuItem getPopupPresenter() {
            JMenuPlus mainItem = new JMenuPlus();
            Actions.setMenuText((AbstractButton)mainItem, (String)this.getName(), (boolean)true);
            HelpCtx.setHelpIDString((JComponent)mainItem, (String)(class$org$openidex$nodes$looks$LookProperties$SetLookAction == null ? (class$org$openidex$nodes$looks$LookProperties$SetLookAction = SetLookAction.class$("org.openidex.nodes.looks.LookProperties$SetLookAction")) : class$org$openidex$nodes$looks$LookProperties$SetLookAction).getName());
            mainItem.addMenuListener(new MainItemListener(this.lookNode));
            return mainItem;
        }

        protected boolean enable(Node[] node) {
            return node.length == 1;
        }

        protected void performAction(Node[] node) {
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class LookEditor
    extends PropertyEditorSupport {
        LookNode lookNode = null;
        private Look look = null;
        static /* synthetic */ Class class$org$openidex$nodes$looks$Look;

        public LookEditor(LookNode lookNode) {
            this.lookNode = lookNode;
        }

        public String getAsText() {
            if (this.getValue() == null) {
                return DEFAULT;
            }
            return ((Look)this.getValue()).getName();
        }

        public void setAsText(String string) throws IllegalArgumentException {
            if (string.equals(DEFAULT)) {
                this.setValue(null);
            }
            Look[] allLooks = LookEditor.getAllLooks(this.lookNode);
            int i = 0;
            while (i < allLooks.length) {
                if (allLooks[i].getName().equals(string)) {
                    this.setValue(allLooks[i]);
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException("No such look - " + string);
        }

        public String getJavaInitializationString() {
            return this.getValue() == null ? "" : this.look.getName();
        }

        public String[] getTags() {
            String[] names;
            Look[] allLooks = LookEditor.getAllLooks(this.lookNode);
            int offset = 0;
            if (this.lookNode.hasLookNodeParent()) {
                names = new String[allLooks.length + 1];
                names[0] = DEFAULT;
                offset = 1;
            } else {
                names = new String[allLooks.length];
            }
            int i = 0;
            while (i < allLooks.length) {
                names[i + offset] = allLooks[i].getName();
                ++i;
            }
            return names;
        }

        static Look[] getAllLooks(LookNode lookNode) {
            Lookup.Template t = new Lookup.Template(class$org$openidex$nodes$looks$Look == null ? (class$org$openidex$nodes$looks$Look = LookEditor.class$("org.openidex.nodes.looks.Look")) : class$org$openidex$nodes$looks$Look);
            Lookup.Result r = Lookup.getDefault().lookup(t);
            Collection lc = r.allInstances();
            ArrayList<Look> looks = new ArrayList<Look>(lc.size());
            int i = 0;
            Iterator it = lc.iterator();
            while (it.hasNext()) {
                Look look = (Look)it.next();
                if (look.isLookStandalone(lookNode.getRepresentedObject())) {
                    looks.add(look);
                }
                ++i;
            }
            return looks.toArray(new Look[0]);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class LookProperty
    extends PropertySupport.ReadWrite {
        private final LookNode lookNode;
        static /* synthetic */ Class class$org$openidex$nodes$looks$Look;

        LookProperty(LookNode lookNode) {
            super(bundle.getString("CTL_LookProperty"), class$org$openidex$nodes$looks$Look == null ? (class$org$openidex$nodes$looks$Look = LookProperty.class$("org.openidex.nodes.looks.Look")) : class$org$openidex$nodes$looks$Look, bundle.getString("CTL_LookProperty"), bundle.getString("CTL_LookPropertyShortDescription"));
            this.lookNode = lookNode;
        }

        public Object getValue() {
            return this.lookNode.getHardLook();
        }

        public void setValue(Object value) {
            this.lookNode.setLook((Look)value);
        }

        public PropertyEditor getPropertyEditor() {
            return new LookEditor(this.lookNode);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

