/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class DataObjectSearchGroup
extends SearchGroup {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    protected void add(SearchType searchType) {
        boolean ok = false;
        Class[] classes = searchType.getSearchTypeClasses();
        int i = 0;
        while (i < classes.length) {
            if (classes[i] == (class$org$openide$loaders$DataObject == null ? DataObjectSearchGroup.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) {
                ok = true;
                break;
            }
            ++i;
        }
        if (ok) {
            super.add(searchType);
        }
    }

    public void doSearch() {
        DataObject.Container[] roots = this.getContainers();
        int i = 0;
        while (i < roots.length) {
            if (!this.scanContainer(roots[i])) {
                return;
            }
            ++i;
        }
    }

    private DataObject.Container[] getContainers() {
        ArrayList<Object> children = null;
        Node[] nodes = DataObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        if (nodes.length == 1) {
            InstanceCookie ic = (InstanceCookie)nodes[0].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = DataObjectSearchGroup.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            try {
                if (ic != null && (class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = DataObjectSearchGroup.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository).isAssignableFrom(ic.instanceClass())) {
                    children = new ArrayList(10);
                    Enumeration fss = Repository.getDefault().getFileSystems();
                    while (fss.hasMoreElements()) {
                        FileSystem fs = (FileSystem)fss.nextElement();
                        if (!fs.isValid() || fs.isHidden()) continue;
                        children.add(DataObject.find((FileObject)fs.getRoot()));
                    }
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(4096, (Throwable)ioe);
                children = null;
            }
            catch (ClassNotFoundException cnfe) {
                ErrorManager.getDefault().notify(4096, (Throwable)cnfe);
                children = null;
            }
        }
        if (children == null) {
            children = new ArrayList<Object>(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                DataObject.Container container = (DataObject.Container)nodes[i].getCookie(class$org$openide$loaders$DataObject$Container == null ? DataObjectSearchGroup.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container);
                if (container != null) {
                    children.add(container);
                }
                ++i;
            }
        }
        return children.toArray(new DataObject.Container[children.size()]);
    }

    private boolean scanContainer(DataObject.Container container) {
        DataObject[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            DataObject.Container c = (DataObject.Container)children[i].getCookie(class$org$openide$loaders$DataObject$Container == null ? DataObjectSearchGroup.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container);
            if (c != null) {
                if (!this.scanContainer(c)) {
                    return false;
                }
            } else {
                this.processSearchObject(children[i]);
            }
            ++i;
        }
        return true;
    }

    public Node getNodeForFoundObject(Object object) {
        if (!(object instanceof DataObject)) {
            return null;
        }
        return ((DataObject)object).getNodeDelegate();
    }

    private static Node[] normalizeNodes(Node[] nodes) {
        if (nodes.length < 2) {
            return nodes;
        }
        HashMap<Object, Boolean> badNodes = new HashMap<Object, Boolean>(2 * nodes.length, 0.75f);
        HashMap goodNodes = new HashMap(2 * nodes.length, 0.75f);
        ArrayList<Node> path = new ArrayList<Node>(10);
        ArrayList<Node> result = new ArrayList<Node>(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            badNodes.put(nodes[i], Boolean.FALSE);
            ++i;
        }
        int i2 = 0;
        while (i2 < nodes.length) {
            Iterator j;
            path.clear();
            boolean isBad = false;
            Node n = nodes[i2].getParentNode();
            while (n != null) {
                if (badNodes.containsKey(n)) {
                    isBad = true;
                    break;
                }
                if (goodNodes.containsKey(n)) break;
                path.add(n);
                n = n.getParentNode();
            }
            if (isBad) {
                badNodes.put(nodes[i2], Boolean.TRUE);
                j = ((AbstractList)path).iterator();
                while (j.hasNext()) {
                    badNodes.put(j.next(), Boolean.TRUE);
                }
            } else {
                j = ((AbstractList)path).iterator();
                while (j.hasNext()) {
                    goodNodes.put(j.next(), Boolean.TRUE);
                }
                result.add(nodes[i2]);
            }
            ++i2;
        }
        return result.toArray(new Node[result.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

