/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class FileObjectSearchGroup
extends SearchGroup {
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    protected void add(SearchType searchType) {
        boolean ok = false;
        Class[] classes = searchType.getSearchTypeClasses();
        int i = 0;
        while (i < classes.length) {
            if (classes[i] == (class$org$openide$filesystems$FileObject == null ? FileObjectSearchGroup.class$("org.openide.filesystems.FileObject") : class$org$openide$filesystems$FileObject)) {
                ok = true;
                break;
            }
            ++i;
        }
        if (ok) {
            super.add(searchType);
        }
    }

    public void doSearch() {
        FileObject[] rootFolders = this.getFileFolders();
        if (rootFolders == null) {
            return;
        }
        int i = 0;
        while (i < rootFolders.length) {
            if (!this.scanFolder(rootFolders[i])) {
                return;
            }
            ++i;
        }
    }

    private FileObject[] getFileFolders() {
        Node[] nodes = FileObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        ArrayList<FileObject> children = new ArrayList<FileObject>(nodes.length);
        if (nodes.length == 1) {
            InstanceCookie ic = (InstanceCookie)nodes[0].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = FileObjectSearchGroup.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            try {
                if (ic != null && (class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = FileObjectSearchGroup.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository).isAssignableFrom(ic.instanceClass())) {
                    Repository rep = Repository.getDefault();
                    Enumeration fss = rep.getFileSystems();
                    while (fss.hasMoreElements()) {
                        FileSystem fs = (FileSystem)fss.nextElement();
                        if (!fs.isValid() || fs.isHidden()) continue;
                        children.add(fs.getRoot());
                    }
                    return children.toArray(new FileObject[children.size()]);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ClassNotFoundException cne) {
                cne.printStackTrace();
            }
        }
        int i = 0;
        while (i < nodes.length) {
            DataFolder dataFolder = (DataFolder)nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? FileObjectSearchGroup.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (dataFolder != null) {
                children.add(dataFolder.getPrimaryFile());
            }
            ++i;
        }
        return children.toArray(new FileObject[children.size()]);
    }

    private boolean scanFolder(FileObject folder) {
        FileObject[] children = folder.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            if (children[i].isFolder()) {
                if (!this.scanFolder(children[i])) {
                    return false;
                }
            } else {
                this.processSearchObject(children[i]);
            }
            ++i;
        }
        return true;
    }

    public Node getNodeForFoundObject(final Object object) {
        if (!(object instanceof FileObject)) {
            return null;
        }
        try {
            return DataObject.find((FileObject)((FileObject)object)).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dnfe) {
            return new AbstractNode(Children.LEAF){

                public String getName() {
                    return ((FileObject)object).getName();
                }
            };
        }
    }

    private static Node[] normalizeNodes(Node[] nodes) {
        ArrayList<Node> ret = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.length) {
            if (!FileObjectSearchGroup.hasParent(nodes[i], nodes)) {
                ret.add(nodes[i]);
            }
            ++i;
        }
        return ret.toArray(new Node[ret.size()]);
    }

    private static boolean hasParent(Node node, Node[] nodes) {
        Node parent = node.getParentNode();
        while (parent != null) {
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i].equals(parent)) {
                    return true;
                }
                ++i;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

