/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.FileObjectSearchGroup;
import org.openidex.search.SearchType;

public abstract class SearchGroup {
    public static final String PROP_FOUND = "org.openidex.search.found";
    public static final String PROP_RESULT = "org.openidex.search.result";
    private PropertyChangeSupport propChangeSupport;
    protected SearchType[] searchTypes = new SearchType[0];
    protected final Set searchRoots = new HashSet(5);
    protected final Set searchObjects = new HashSet(50);
    protected final Set resultObjects = new HashSet(50);
    protected boolean stopped = false;
    private PropertyChangeListener propListener;

    protected void add(SearchType searchType) {
        int i = 0;
        while (i < this.searchTypes.length) {
            if (searchType.equals(this.searchTypes[i])) {
                return;
            }
            ++i;
        }
        SearchType[] temp = new SearchType[this.searchTypes.length + 1];
        System.arraycopy(this.searchTypes, 0, temp, 0, this.searchTypes.length);
        temp[this.searchTypes.length] = searchType;
        this.searchTypes = temp;
    }

    public SearchType[] getSearchTypes() {
        return this.searchTypes;
    }

    public void setSearchRootNodes(Node[] roots) {
        int i = 0;
        while (i < this.searchTypes.length) {
            roots = this.searchTypes[i].acceptSearchRootNodes(roots);
            ++i;
        }
        this.searchRoots.clear();
        this.searchRoots.addAll(Arrays.asList(roots));
    }

    public Node[] getSearchRoots() {
        return this.searchRoots.toArray(new Node[this.searchRoots.size()]);
    }

    public final void stopSearch() {
        this.stopped = true;
    }

    public void search() {
        this.prepareSearch();
        this.doSearch();
    }

    protected void prepareSearch() {
        int i = 0;
        while (i < this.searchTypes.length) {
            this.searchTypes[i].addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.getSearchTypeListener(), (Object)this.searchTypes[i]));
            ++i;
        }
    }

    private synchronized PropertyChangeListener getSearchTypeListener() {
        if (this.propListener == null) {
            this.propListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("org.openidex.search.objectChanged".equals(evt.getPropertyName())) {
                        Object searchObject = evt.getNewValue();
                        int i = 0;
                        while (i < SearchGroup.this.searchTypes.length) {
                            if (!SearchGroup.this.searchTypes[i].testObject(searchObject)) {
                                if (SearchGroup.this.resultObjects.remove(searchObject)) {
                                    SearchGroup.this.firePropertyChange(SearchGroup.PROP_RESULT, searchObject, null);
                                }
                                return;
                            }
                            ++i;
                        }
                        if (SearchGroup.this.resultObjects.add(searchObject)) {
                            SearchGroup.this.firePropertyChange(SearchGroup.PROP_RESULT, null, searchObject);
                        }
                    }
                }
            };
        }
        return this.propListener;
    }

    protected abstract void doSearch();

    protected void processSearchObject(Object searchObject) {
        int i = 0;
        while (i < this.searchTypes.length) {
            if (!this.searchTypes[i].acceptSearchObject(searchObject)) {
                return;
            }
            ++i;
        }
        this.searchObjects.add(searchObject);
        int i2 = 0;
        while (i2 < this.searchTypes.length) {
            this.searchTypes[i2].prepareSearchObject(searchObject);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.searchTypes.length) {
            if (!this.searchTypes[i3].testObject(searchObject)) {
                return;
            }
            ++i3;
        }
        this.resultObjects.add(searchObject);
        this.firePropertyChange(PROP_FOUND, null, searchObject);
    }

    public abstract Node getNodeForFoundObject(Object var1);

    public Set getResultObjects() {
        return new HashSet(this.resultObjects);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertySupport().addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertySupport().removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.getPropertySupport().firePropertyChange(name, oldValue, newValue);
    }

    private synchronized PropertyChangeSupport getPropertySupport() {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propChangeSupport;
    }

    public static SearchGroup[] createSearchGroups(SearchType[] items) {
        HashSet<Class> classSet = new HashSet<Class>(items.length);
        int i = 0;
        while (i < items.length) {
            List<Class> classes = Arrays.asList(items[i].getSearchTypeClasses());
            if (i == 0) {
                classSet.addAll(classes);
            } else {
                classSet.retainAll(classes);
            }
            ++i;
        }
        if (classSet.isEmpty()) {
            return new SearchGroup[0];
        }
        HashSet<SearchGroup> groupSet = new HashSet<SearchGroup>(classSet.size());
        Iterator it = classSet.iterator();
        while (it.hasNext()) {
            SearchGroup group = Registry.createSearchGroup((Class)it.next());
            if (group == null) continue;
            int i2 = 0;
            while (i2 < items.length) {
                group.add(items[i2]);
                ++i2;
            }
            groupSet.add(group);
        }
        return groupSet.toArray(new SearchGroup[groupSet.size()]);
    }

    public static final class Registry {
        private static final Map registry = new HashMap(2);
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$openide$filesystems$FileObject;

        private Registry() {
        }

        public static synchronized boolean registerSearchGroupFactory(Class searchObjectClass, Factory factory) {
            Factory oldFactory = registry.put(searchObjectClass, factory);
            if (oldFactory != null) {
                registry.put(searchObjectClass, oldFactory);
                return false;
            }
            return true;
        }

        public static SearchGroup createSearchGroup(Class searchObjectType) {
            Factory factory = (Factory)registry.get(searchObjectType);
            if (factory == null) {
                return null;
            }
            return factory.createSearchGroup();
        }

        public static boolean hasFactory(Class searchObjectType) {
            return registry.containsKey(searchObjectType);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static {
            registry.put(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Registry.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new DataObjectSearchGroup();
                }
            });
            registry.put(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = Registry.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new FileObjectSearchGroup();
                }
            });
        }
    }

    public static interface Factory {
        public SearchGroup createSearchGroup();
    }
}

