/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.execution.DefaultSysProcess;
import org.netbeans.core.execution.ExecutionEvent;
import org.netbeans.core.execution.ExecutionListener;
import org.netbeans.core.execution.ExecutorTaskImpl;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.IOTable;
import org.netbeans.core.execution.OutputStreamWriter;
import org.netbeans.core.execution.ProcessNode;
import org.netbeans.core.execution.RunClassThread;
import org.netbeans.core.execution.SysIn;
import org.netbeans.core.execution.TaskIO;
import org.netbeans.core.execution.TaskThreadGroup;
import org.netbeans.core.execution.WindowTable;
import org.netbeans.core.execution.WriterPrintStream;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class ExecutionEngine
extends org.openide.execution.ExecutionEngine {
    public static final ThreadGroup base = new ThreadGroup("base");
    private int number = 1;
    public static final TaskIO systemIO = new TaskIO();
    private static IOTable taskIOs;
    private static WindowTable wtable;
    private boolean execNodeInited = false;
    private HashSet executionListeners = new HashSet();
    private ArrayList runningTasks = new ArrayList(5);
    static final long serialVersionUID = 9072488605180080803L;
    static /* synthetic */ Class class$org$netbeans$core$execution$ExecutionEngine;
    static /* synthetic */ Class class$org$openide$execution$ExecutionEngine;

    public ExecutionEngine() {
        System.setIn(new SysIn());
        System.setOut(ExecutionEngine.createPrintStream(true));
        System.setErr(ExecutionEngine.createPrintStream(false));
    }

    public static ExecutionEngine getExecutionEngine() {
        ExecutionEngine ee = (ExecutionEngine)((Object)Lookup.getDefault().lookup(class$org$netbeans$core$execution$ExecutionEngine == null ? (class$org$netbeans$core$execution$ExecutionEngine = ExecutionEngine.class$("org.netbeans.core.execution.ExecutionEngine")) : class$org$netbeans$core$execution$ExecutionEngine));
        if (ee != null) {
            return ee;
        }
        org.openide.execution.ExecutionEngine ee2 = (org.openide.execution.ExecutionEngine)Lookup.getDefault().lookup(class$org$openide$execution$ExecutionEngine == null ? (class$org$openide$execution$ExecutionEngine = ExecutionEngine.class$("org.openide.execution.ExecutionEngine")) : class$org$openide$execution$ExecutionEngine);
        if (ee2 instanceof ExecutionEngine) {
            return (ExecutionEngine)ee2;
        }
        return null;
    }

    public Collection getRunningTasks() {
        return this.runningTasks;
    }

    public String getRunningTaskName(ExecutorTask task) {
        if (!this.runningTasks.contains(task) || !(task instanceof DefaultSysProcess)) {
            return null;
        }
        return ((DefaultSysProcess)task).getName();
    }

    private void initExecNode() {
        ProcessNode.getExecutionNode();
        this.execNodeInited = true;
        try {
            if (Utilities.isUnix()) {
                Class<?> clz = Class.forName("java.lang.UNIXProcess");
            }
        }
        catch (ClassNotFoundException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    public ExecutorTask execute(String name, Runnable run, InputOutput inout) {
        if (!this.execNodeInited) {
            this.initExecNode();
        }
        TaskThreadGroup g = new TaskThreadGroup(base, "exec_" + name + "_" + this.number);
        g.setDaemon(true);
        ExecutorTaskImpl task = new ExecutorTaskImpl();
        Object object = task.lock;
        synchronized (object) {
            try {
                int n = this.number++;
                new RunClassThread(g, name, n, inout, this, task, run);
                task.lock.wait();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return task;
    }

    protected NbClassPath createLibraryPath() {
        List l = NbTopManager.getUninitialized().getModuleSystem().getModuleJars();
        return new NbClassPath(l.toArray(new File[l.size()]));
    }

    public final void addExecutionListener(ExecutionListener l) {
        HashSet hashSet = this.executionListeners;
        synchronized (hashSet) {
            this.executionListeners.add(l);
        }
    }

    public final void removeExecutionListener(ExecutionListener l) {
        HashSet hashSet = this.executionListeners;
        synchronized (hashSet) {
            this.executionListeners.remove(l);
        }
    }

    protected final PermissionCollection createPermissions(CodeSource cs, InputOutput io) {
        PermissionCollection pc = Policy.getPolicy().getPermissions(cs);
        ThreadGroup grp = Thread.currentThread().getThreadGroup();
        return new IOPermissionCollection(io, pc, grp instanceof TaskThreadGroup ? (TaskThreadGroup)grp : null);
    }

    protected final void fireExecutionStarted(ExecutionEvent ev) {
        this.runningTasks.add(ev.getProcess());
        Iterator iter = ((HashSet)this.executionListeners.clone()).iterator();
        while (iter.hasNext()) {
            ExecutionListener l = (ExecutionListener)iter.next();
            l.startedExecution(ev);
        }
    }

    protected final void fireExecutionFinished(ExecutionEvent ev) {
        ((AbstractCollection)this.runningTasks).remove((Object)ev.getProcess());
        Iterator iter = ((HashSet)this.executionListeners.clone()).iterator();
        while (iter.hasNext()) {
            ExecutionListener l = (ExecutionListener)iter.next();
            l.finishedExecution(ev);
        }
    }

    static void putWindow(Window w, TaskThreadGroup tg) {
        wtable.putTaskWindow(w, tg);
    }

    static void closeGroup(ThreadGroup tg) {
        wtable.closeGroup(tg);
    }

    static boolean hasWindows(ThreadGroup tg) {
        return wtable.hasWindows(tg);
    }

    static IOTable getTaskIOs() {
        if (taskIOs == null) {
            taskIOs = new IOTable(base, systemIO);
        }
        return taskIOs;
    }

    public static ThreadGroup findGroup() {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        ThreadGroup old = null;
        while (g != null && g != base) {
            old = g;
            g = g.getParent();
        }
        return g == null ? null : old;
    }

    static PrintStream createPrintStream(boolean stdOut) {
        return new WriterPrintStream(new SysOut(stdOut), stdOut);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        wtable = new WindowTable();
        ExecutionEngine.systemIO.out = new OutputStreamWriter(System.out);
        ExecutionEngine.systemIO.err = new OutputStreamWriter(System.err);
        ExecutionEngine.systemIO.in = new InputStreamReader(System.in);
    }

    static class SysOut
    extends OutputStream {
        boolean std;

        SysOut(boolean std) {
            this.std = std;
        }

        public void write(int b) throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().write(b);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(b);
            }
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            String s = new String(buff, off, len);
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().write(s.toCharArray(), 0, s.length());
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(s.toCharArray(), 0, s.length());
            }
        }

        public void flush() throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().flush();
            } else {
                ExecutionEngine.getTaskIOs().getErr().flush();
            }
        }

        public void close() throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().close();
            } else {
                ExecutionEngine.getTaskIOs().getErr().close();
            }
        }
    }
}

