/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.ExecutionEvent;
import org.netbeans.core.execution.ExecutionListener;
import org.netbeans.core.execution.ProcessNode;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class ExecutionViewAction
extends CallableSystemAction {
    static final long serialVersionUID = -6906468860893774146L;
    public static final int DEFAULT_WINDOW_WIDTH = 270;
    public static final int DEFAULT_WINDOW_HEIGHT = 150;
    public static final int MIN_HEIGHT = 50;
    private static ExecutionView executionView = null;
    static /* synthetic */ Class class$org$netbeans$core$execution$ExecutionViewAction;

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$execution$ExecutionViewAction == null ? (class$org$netbeans$core$execution$ExecutionViewAction = ExecutionViewAction.class$("org.netbeans.core.execution.ExecutionViewAction")) : class$org$netbeans$core$execution$ExecutionViewAction)).getString("ExecutionView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$execution$ExecutionViewAction == null ? (class$org$netbeans$core$execution$ExecutionViewAction = ExecutionViewAction.class$("org.netbeans.core.execution.ExecutionViewAction")) : class$org$netbeans$core$execution$ExecutionViewAction);
    }

    protected String iconResource() {
        return "org/netbeans/core/resources/actions/executionView.gif";
    }

    public void performAction() {
        ExecutionView tc = ExecutionViewAction.getExecutionView();
        WindowManager wm = WindowManager.getDefault();
        ModeImpl mode = (ModeImpl)wm.getCurrentWorkspace().findMode((TopComponent)tc);
        if (mode == null) {
            mode = (ModeImpl)wm.getCurrentWorkspace().findMode("output");
        }
        if (mode == null) {
            mode = (ModeImpl)wm.getCurrentWorkspace().createMode("execution", NbBundle.getBundle((String)"org.netbeans.core.windows.Bundle").getString("CTL_ExecutionWindow"), WindowUtils.getIconURL((String)"nbresloc:/org/netbeans/core/resources/frames/execution.gif"));
        }
        mode.addIgnoredNameClass(((Object)((Object)tc)).getClass());
        mode.dockInto((TopComponent)tc);
        tc.open();
        tc.requestFocus();
    }

    public static ExecutionView getExecutionView() {
        if (executionView == null) {
            executionView = new ExecutionView();
        }
        return executionView;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Resolvable
    implements Serializable {
        static final long serialVersionUID = 8143238035030034549L;

        Resolvable() {
        }

        private Object readResolve() {
            return ExecutionViewAction.getExecutionView();
        }
    }

    public static final class ExecutionView
    extends ExplorerPanel {
        private boolean initialized = false;
        static final long serialVersionUID = 3712218929995126077L;
        static /* synthetic */ Class class$org$netbeans$core$execution$ExecutionViewAction;

        public static ExecutionView createExecutionView() {
            return ExecutionViewAction.getExecutionView();
        }

        ExecutionView() {
            ExecutionEngine ee = ExecutionEngine.getExecutionEngine();
            if (ee == null) {
                throw new IllegalStateException("No ExecutionEngine");
            }
            ExplorerManager em = this.getExplorerManager();
            em.setRootContext(ProcessNode.getExecutionNode());
            ListView list = new ListView();
            ((Container)((Object)this)).add((Component)list, "Center");
            this.setName(NbBundle.getBundle((Class)(class$org$netbeans$core$execution$ExecutionViewAction == null ? (class$org$netbeans$core$execution$ExecutionViewAction = ExecutionView.class$("org.netbeans.core.execution.ExecutionViewAction")) : class$org$netbeans$core$execution$ExecutionViewAction)).getString("CTL_Execution_view_title"));
            this.setIcon(Utilities.loadImage((String)"org/netbeans/core/resources/frames/execution.gif"));
            this.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$core$execution$ExecutionViewAction == null ? (class$org$netbeans$core$execution$ExecutionViewAction = ExecutionView.class$("org.netbeans.core.execution.ExecutionViewAction")) : class$org$netbeans$core$execution$ExecutionViewAction)).getString("HINT_Execution_view"));
            list.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$execution$ExecutionViewAction == null ? (class$org$netbeans$core$execution$ExecutionViewAction = ExecutionView.class$("org.netbeans.core.execution.ExecutionViewAction")) : class$org$netbeans$core$execution$ExecutionViewAction)).getString("ACSN_ExecutionList"));
            list.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$execution$ExecutionViewAction == null ? (class$org$netbeans$core$execution$ExecutionViewAction = ExecutionView.class$("org.netbeans.core.execution.ExecutionViewAction")) : class$org$netbeans$core$execution$ExecutionViewAction)).getString("ACSD_ExecutionList"));
            ee.addExecutionListener(new ExecListener());
        }

        public HelpCtx getHelpCtx() {
            return ExplorerPanel.getHelpCtx((Node[])this.getExplorerManager().getSelectedNodes(), (HelpCtx)new HelpCtx("execution.view.window"));
        }

        public Dimension getPreferredSize() {
            return new Dimension(270, 150);
        }

        protected void updateTitle() {
        }

        protected Object writeReplace() {
            return new Resolvable();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class ExecListener
        implements ExecutionListener {
            private int execCount = 0;
            private List autoOpenedList = new ArrayList(5);
            private final Object dataLock = new Object();

            ExecListener() {
            }

            public void startedExecution(ExecutionEvent ev) {
                Workspace curW = null;
                Object object = this.dataLock;
                synchronized (object) {
                    ++this.execCount;
                    curW = WindowManager.getDefault().getCurrentWorkspace();
                    if (ev.isUserImportant() && !ExecutionView.this.isOpened(curW)) {
                        this.autoOpenedList.add(curW);
                    } else {
                        curW = null;
                    }
                }
                if (curW != null) {
                    Workspace localCurW = curW;
                    SwingUtilities.invokeLater(new Runnable(this, localCurW){
                        private final /* synthetic */ Workspace val$localCurW;
                        private final /* synthetic */ ExecListener this$1;
                        {
                            this.this$1 = this$1;
                            this.val$localCurW = val$localCurW;
                        }

                        public void run() {
                            ExecListener.access$000(this.this$1).open(this.val$localCurW);
                        }
                    });
                }
            }

            public void finishedExecution(ExecutionEvent ev) {
                ArrayList localAutoOpened = null;
                Object object = this.dataLock;
                synchronized (object) {
                    --this.execCount;
                    if (this.execCount == 0) {
                        localAutoOpened = new ArrayList(this.autoOpenedList);
                        this.autoOpenedList.clear();
                    }
                }
                if (localAutoOpened != null) {
                    Iterator iter = localAutoOpened.iterator();
                    while (iter.hasNext()) {
                        Workspace localCur = (Workspace)iter.next();
                        SwingUtilities.invokeLater(new Runnable(this, localCur){
                            private final /* synthetic */ Workspace val$localCur;
                            private final /* synthetic */ ExecListener this$1;
                            {
                                this.this$1 = this$1;
                                this.val$localCur = val$localCur;
                            }

                            public void run() {
                                ExecListener.access$000(this.this$1).close(this.val$localCur);
                            }
                        });
                    }
                }
            }

            static /* synthetic */ ExecutionView access$000(ExecListener x0) {
                return x0.ExecutionView.this;
            }
        }
    }
}

