/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import org.netbeans.core.execution.DefaultSysProcess;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.ExecutionEvent;
import org.netbeans.core.execution.ExecutionListener;
import org.netbeans.core.execution.ProcessNodeItem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProcessNode
extends AbstractNode
implements Runnable {
    static final long serialVersionUID = 5090696227895147340L;
    private AbstractNode noProcesses;
    static ProcessNode processNode;
    static /* synthetic */ Class class$org$netbeans$core$execution$ProcessNode;

    static final ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$execution$ProcessNode == null ? (class$org$netbeans$core$execution$ProcessNode = ProcessNode.class$("org.netbeans.core.execution.ProcessNode")) : class$org$netbeans$core$execution$ProcessNode));
    }

    public ProcessNode() {
        super((Children)new Children.Array());
        processNode = this;
        this.setIconBase("org/netbeans/core/resources/processes");
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
                if (ProcessNode.this.getChildren().getNodesCount() == 0 && ev.getDelta().length > 0 && ev.getDelta()[0] != ProcessNode.this.noProcesses) {
                    RequestProcessor.postRequest((Runnable)ProcessNode.this);
                }
            }

            public void childrenReordered(NodeReorderEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent ev) {
            }
        });
        ExecutionEngine ee = ExecutionEngine.getExecutionEngine();
        if (ee == null) {
            throw new IllegalStateException("No ExecutionEngine");
        }
        ee.addExecutionListener(this.createListener());
        this.setName(ProcessNode.getBundle().getString("Processes"));
        this.setShortDescription(ProcessNode.getBundle().getString("Processes_HINT"));
        this.addNoProcessNode();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$execution$ProcessNode == null ? (class$org$netbeans$core$execution$ProcessNode = ProcessNode.class$("org.netbeans.core.execution.ProcessNode")) : class$org$netbeans$core$execution$ProcessNode);
    }

    public Node.Handle getHandle() {
        return new ProcessHandle();
    }

    private ExecutionListener createListener() {
        return new ExecutionListener(){

            public void startedExecution(ExecutionEvent ev) {
                DefaultSysProcess proc = ev.getProcess();
                ProcessNodeItem item = new ProcessNodeItem(proc);
                ProcessNode.this.removeNoProcessNode();
                ProcessNode.this.getChildren().add(new Node[]{item});
            }

            public void finishedExecution(ExecutionEvent ev) {
            }
        };
    }

    void addNoProcessNode() {
        if (this.getChildren().getNodesCount() == 0) {
            this.getChildren().add(new Node[]{this.getNoProcessesNode()});
        }
    }

    void removeNoProcessNode() {
        this.getChildren().remove(new Node[]{this.getNoProcessesNode()});
    }

    public static Node getExecutionNode() {
        if (processNode == null) {
            processNode = new ProcessNode();
        }
        return processNode;
    }

    private Node getNoProcessesNode() {
        if (this.noProcesses == null) {
            this.noProcesses = new AbstractNode(Children.LEAF);
            this.noProcesses.setName(ProcessNode.getBundle().getString("CTL_No_processes"));
            this.noProcesses.setShortDescription(ProcessNode.getBundle().getString("HINT_No_processes"));
            this.noProcesses.setIconBase("org/netbeans/core/resources/noProcesses");
        }
        return this.noProcesses;
    }

    public void run() {
        this.addNoProcessNode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ProcessHandle
    implements Node.Handle {
        static final long serialVersionUID = -6979883764640743928L;

        ProcessHandle() {
        }

        public Node getNode() {
            return ProcessNode.getExecutionNode();
        }
    }
}

