/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Window;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.netbeans.core.execution.AccController;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.ExitSecurityException;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.TaskThreadGroup;

public class SecMan
extends SecurityManager {
    public static SecurityManager DEFAULT = new SecMan();
    private static Class nbClassLoaderClass = class$org$openide$execution$NbClassLoader == null ? (class$org$openide$execution$NbClassLoader = SecMan.class$("org.openide.execution.NbClassLoader")) : class$org$openide$execution$NbClassLoader;
    private ThreadGroup base = ExecutionEngine.base;
    static /* synthetic */ Class class$org$openide$execution$NbClassLoader;

    public void checkExit(int status) throws SecurityException {
        PrivilegedCheck.checkExit(status, this);
    }

    final void checkExitImpl(int status, AccessControlContext acc) throws SecurityException {
        IOPermissionCollection iopc = AccController.getIOPermissionCollection(acc);
        if (iopc != null && iopc.grp != null) {
            ExecutionEngine.getTaskIOs().free(iopc.grp, iopc.getIO());
            ExecutionEngine.closeGroup(iopc.grp);
            this.stopTaskThreadGroup(iopc.grp);
            throw new ExitSecurityException("Exit from within execution engine, normal");
        }
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        if (g instanceof TaskThreadGroup) {
            throw new ExitSecurityException("Exit from within execution engine, normal");
        }
        if (this.isNbClassLoader()) {
            throw new ExitSecurityException("Exit from within user-loaded code");
        }
    }

    private void stopTaskThreadGroup(TaskThreadGroup old) {
        TaskThreadGroup taskThreadGroup = old;
        synchronized (taskThreadGroup) {
            int count = old.activeCount();
            int icurrent = -1;
            Thread current = Thread.currentThread();
            Thread[] thrs = new Thread[count];
            old.enumerate(thrs, true);
            int i = 0;
            while (i < thrs.length) {
                if (thrs[i] == null) break;
                if (thrs[i] == current) {
                    icurrent = i;
                } else {
                    thrs[i].stop();
                }
                ++i;
            }
            if (icurrent != -1) {
                thrs[icurrent].stop();
            }
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        IOPermissionCollection iopc = AccController.getIOPermissionCollection();
        if (iopc != null && iopc.grp != null && window instanceof Window) {
            ExecutionEngine.putWindow((Window)window, iopc.grp);
        }
        return true;
    }

    protected boolean isNbClassLoader() {
        Class<?>[] ctx = this.getClassContext();
        int i = 0;
        while (i < ctx.length) {
            if (nbClassLoaderClass.isInstance(ctx[i].getClassLoader()) && ctx[i].getProtectionDomain().getCodeSource() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class PrivilegedCheck
    implements PrivilegedExceptionAction {
        private final int action;
        private final SecMan sm;
        private int status;
        private AccessControlContext acc;

        public PrivilegedCheck(int action, SecMan sm) {
            this.action = action;
            this.sm = sm;
            if (action == 0) {
                this.acc = AccessController.getContext();
            }
        }

        public Object run() throws Exception {
            switch (this.action) {
                case 0: {
                    this.sm.checkExitImpl(this.status, this.acc);
                    break;
                }
            }
            return null;
        }

        static void checkExit(int status, SecMan sm) {
            PrivilegedCheck pea = new PrivilegedCheck(0, sm);
            pea.status = status;
            PrivilegedCheck.check(pea);
        }

        private static void check(PrivilegedCheck action) {
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Exception orig = e.getException();
                if (orig instanceof RuntimeException) {
                    throw (RuntimeException)orig;
                }
                orig.printStackTrace();
            }
        }
    }
}

