/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.ErrorManager;
import org.openide.execution.NbClassLoader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListener;

class ClassLoaderSupport
extends NbClassLoader
implements FileChangeListener,
PropertyChangeListener {
    private FileChangeListener listener;
    private PropertyChangeListener propListener;
    private static ClassLoaderSupport current;
    private static PermissionCollection allPermission;
    private static boolean firstTime;
    private ClassPath classPath;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    static synchronized ClassLoader currentClassLoader() {
        if (current == null) {
            current = new ClassLoaderSupport(ClassPath.getClassPath(null, "classpath/execute"));
            if (firstTime) {
                firstTime = false;
                Lookup.getDefault().lookup(new Lookup.Template(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoaderSupport.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent e) {
                        if (current != null) {
                            current.reset();
                        }
                    }
                });
            }
        }
        return current;
    }

    private static FileSystem[] getFileSystems(FileObject[] roots) {
        ArrayList<FileSystem> fss = new ArrayList<FileSystem>(roots.length);
        int i = 0;
        while (i < roots.length) {
            try {
                fss.add(roots[i].getFileSystem());
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            ++i;
        }
        return fss.toArray(new FileSystem[fss.size()]);
    }

    ClassLoaderSupport(ClassPath cp) {
        super(ClassLoaderSupport.getFileSystems(cp.getRoots()));
        this.classPath = cp;
        this.setDefaultPermissions(ClassLoaderSupport.getAllPermissions());
        this.listener = WeakListener.fileChange((FileChangeListener)this, null);
        this.propListener = WeakListener.propertyChange((PropertyChangeListener)this, null);
        cp.addPropertyChangeListener(this.propListener);
    }

    protected void finalize() {
        ErrorManager.getDefault().getInstance("org.netbeans.api.java").log("Collected currentClassLoader");
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String resName;
        FileObject fo;
        Class c = super.findClass(name);
        if (c != null && (fo = this.classPath.findResource(resName = name.replace('.', '/') + ".class")) != null) {
            fo.addFileChangeListener(this.listener);
        }
        return c;
    }

    private void test(FileObject fo) {
        this.classPath.resetClassLoader((ClassLoader)((Object)this));
        fo.removeFileChangeListener(this.listener);
    }

    private void reset() {
        this.classPath.resetClassLoader((ClassLoader)((Object)this));
    }

    private void testRemove(FileObject fo) {
        if (current != this) {
            fo.removeFileChangeListener(this.listener);
        }
    }

    public void fileFolderCreated(FileEvent fe) {
        this.testRemove(fe.getFile());
    }

    public void fileDataCreated(FileEvent fe) {
        this.testRemove(fe.getFile());
    }

    public void fileChanged(FileEvent fe) {
        this.test(fe.getFile());
    }

    public void fileDeleted(FileEvent fe) {
        this.test(fe.getFile());
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.test(fe.getFile());
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.testRemove(fe.getFile());
    }

    static synchronized PermissionCollection getAllPermissions() {
        if (allPermission == null) {
            allPermission = new Permissions();
            allPermission.add(new AllPermission());
        }
        return allPermission;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.reset();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        firstTime = true;
    }
}

