/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassLoaderSupport;
import org.netbeans.api.java.classpath.RepositoryL;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

public abstract class ClassPath {
    public static final String EXECUTE = "classpath/execute";
    public static final String DEBUG = "classpath/debug";
    public static final String COMPILE = "classpath/compile";
    public static final String PROP_ROOTS = "roots";
    public static final String PROP_ENTRIES = "entries";
    private static final String REGISTRATION_PREFIX = "org-netbeans-modules-java/";
    private PropertyChangeSupport propSupport;
    private static final Reference EMPTY_REF = new SoftReference<Object>(null);
    private Reference refClassLoader = EMPTY_REF;

    public abstract FileObject[] getRoots();

    public abstract List entries();

    ClassPath() {
    }

    public final FileObject findResource(String resourceName) {
        FileObject[] roots = this.getRoots();
        return ClassPath.findResourceImpl(roots, new int[]{0}, ClassPath.parseResourceName(resourceName));
    }

    public final List findAllResources(String resourceName) {
        FileObject[] roots = this.getRoots();
        ArrayList<FileObject> l = new ArrayList<FileObject>(roots.length);
        int[] idx = new int[]{0};
        String[] namec = ClassPath.parseResourceName(resourceName);
        while (idx[0] < roots.length) {
            FileObject f = ClassPath.findResourceImpl(roots, idx, namec);
            if (f == null) continue;
            l.add(f);
        }
        return l;
    }

    public final String getResourceName(FileObject f) {
        return this.getResourceName(f, '/', true);
    }

    public final String getResourceName(FileObject f, char dirSep, boolean includeExt) {
        FileObject owner = this.findOwnerRoot(f);
        if (owner == null) {
            return null;
        }
        if (owner == f) {
            return "";
        }
        String ownerName = owner.toString();
        int onl = ownerName.length();
        String partName = includeExt ? f.getPackageNameExt(dirSep, '.') : f.getPackageName(dirSep);
        return onl == 0 ? partName : partName.substring(onl + 1);
    }

    public final FileObject findOwnerRoot(FileObject resource) {
        FileObject[] roots = this.getRoots();
        LinkedList<FileObject> parts = new LinkedList<FileObject>();
        FileObject f = resource;
        while (f != null) {
            parts.add(f);
            f = f.getParent();
        }
        int i = 0;
        while (i < roots.length) {
            block6: {
                FileObject rc;
                block5: {
                    rc = roots[i];
                    try {
                        if (rc.getFileSystem() == resource.getFileSystem()) break block5;
                        break block6;
                    }
                    catch (FileStateInvalidException ex) {
                        // empty catch block
                    }
                }
                if (parts.contains(rc)) {
                    return rc;
                }
            }
            ++i;
        }
        return null;
    }

    public final boolean contains(FileObject f) {
        return this.findOwnerRoot(f) != null;
    }

    public final boolean isResourceVisible(FileObject resource) {
        String resourceName = this.getResourceName(resource);
        if (resourceName == null) {
            return false;
        }
        return this.findResource(resourceName) == resource;
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        this.propSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propSupport != null) {
            this.propSupport.removePropertyChangeListener(l);
        }
    }

    public static ClassPath getClassPath(FileObject f, String id) {
        return ClassPath.getClassPathImpl(id);
    }

    final void firePropertyChange(String what, Object oldV, Object newV) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.firePropertyChange(what, oldV, newV);
    }

    private static ClassPath getClassPathImpl(String id) {
        return RepositoryL.get().getClassPath(id);
    }

    private static String[] parseResourceName(String name) {
        ArrayList<String> parsed = new ArrayList<String>(name.length() / 4);
        char[] chars = name.toCharArray();
        int pos = 0;
        int dotPos = -1;
        int startPos = 0;
        while (pos < chars.length) {
            char ch = chars[pos];
            switch (ch) {
                case '.': {
                    dotPos = pos;
                    break;
                }
                case '/': {
                    if (dotPos != -1) {
                        parsed.add(name.substring(startPos, dotPos));
                        parsed.add(name.substring(dotPos + 1, pos));
                    } else {
                        parsed.add(name.substring(startPos, pos));
                        parsed.add(null);
                    }
                    startPos = pos + 1;
                    dotPos = -1;
                }
            }
            ++pos;
        }
        if (pos > startPos) {
            if (dotPos != -1) {
                parsed.add(name.substring(startPos, dotPos));
                parsed.add(name.substring(dotPos + 1, pos));
            } else {
                parsed.add(name.substring(startPos, pos));
                parsed.add(null);
            }
        }
        if (parsed.size() % 2 != 0) {
            System.err.println("parsed size is not even!!");
            System.err.println("input = " + name);
        }
        return parsed.toArray(new String[parsed.size()]);
    }

    private static FileObject findPath(FileObject parent, String[] nameParts) {
        int i = 0;
        while (i < nameParts.length && parent != null) {
            FileObject child = parent.getFileObject(nameParts[i], nameParts[i + 1]);
            i += 2;
            parent = child;
        }
        return parent;
    }

    private static FileObject findResourceImpl(FileObject[] roots, int[] rootIndex, String[] nameComponents) {
        FileObject f = null;
        int ridx = rootIndex[0];
        while (ridx < roots.length && f == null) {
            f = ClassPath.findPath(roots[ridx], nameComponents);
            ++ridx;
        }
        rootIndex[0] = ridx;
        return f;
    }

    synchronized void resetClassLoader(ClassLoader cl) {
        if (this.refClassLoader.get() == cl) {
            this.refClassLoader = EMPTY_REF;
        }
    }

    public final synchronized ClassLoader getClassLoader(boolean cache) {
        Object o = this.refClassLoader.get();
        if (!cache || o == null) {
            o = new ClassLoaderSupport(this);
            this.refClassLoader = new SoftReference(o);
        }
        return (ClassLoader)o;
    }

    public abstract class Entry {
        public abstract ClassPath getDefiningClassPath();

        public abstract FileObject getRoot();

        public abstract boolean isValid();

        public abstract IOException getError();

        Entry() {
        }
    }
}

