/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;

class RepositoryCP
extends ClassPath {
    FileSystemCapability filterCap;
    Collection roots;
    List entries;
    Map capMap;

    public RepositoryCP(FileSystemCapability cap) {
        this.filterCap = cap;
    }

    public List entries() {
        List l = this.entries;
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            if (l != null) {
                List list = this.entries;
                return list;
            }
            Enumeration en = this.filterCap.fileSystems();
            LinkedList<CPEntry> ll = new LinkedList<CPEntry>();
            this.capMap = new HashMap(5);
            while (en.hasMoreElements()) {
                FileSystem fs = (FileSystem)en.nextElement();
                CPEntry entry = new CPEntry(fs);
                this.capMap.put(fs.getCapability(), entry);
                ll.add(entry);
            }
            this.entries = Collections.unmodifiableList(ll);
        }
        return this.entries;
    }

    void resetEntries() {
        this.roots = null;
        this.entries = null;
    }

    public final synchronized FileObject[] getRoots() {
        ArrayList<FileObject> r = this.roots;
        if (r == null) {
            List l = this.entries();
            r = new ArrayList<FileObject>(l.size());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ClassPath.Entry en = (ClassPath.Entry)it.next();
                FileObject fo = en.getRoot();
                if (fo == null) continue;
                r.add(fo);
            }
            this.roots = r;
        }
        return r.toArray(new FileObject[r.size()]);
    }

    boolean accept(FileSystem fs) {
        return fs.getCapability().capableOf(this.filterCap);
    }

    public synchronized void resetRoots() {
        this.entries = null;
        this.roots = null;
    }

    void capsChanged(FileSystem fs) {
        boolean capable;
        FileObject previousFO = null;
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            CPEntry haveEntry = this.find(fs);
            capable = fs.getCapability().capableOf(this.filterCap);
            if (haveEntry != null == capable) {
                return;
            }
            if (capable) {
                CPEntry prev = null;
                List<FileSystem> repo = Arrays.asList(Repository.getDefault().toArray());
                ListIterator<FileSystem> iter = repo.listIterator(repo.indexOf(fs));
                while (previousFO != null && iter.hasPrevious()) {
                    FileSystem s2 = iter.previous();
                    prev = this.find(s2);
                    if (prev == null) continue;
                    previousFO = prev.getRoot();
                }
                repo = new ArrayList<FileSystem>(this.entries);
                if (previousFO == null) {
                    repo.add(0, (FileSystem)new CPEntry(fs));
                } else {
                    repo.add(repo.indexOf(prev), (FileSystem)new CPEntry(fs));
                }
            }
        }
        if (!capable) {
            this.fileSystemRemoved(fs);
        }
    }

    CPEntry find(FileSystem fs) {
        if (this.capMap == null) {
            return null;
        }
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            CPEntry cPEntry = (CPEntry)this.capMap.get(fs.getCapability());
            return cPEntry;
        }
    }

    void fileSystemsReordered(int[] perm) {
        FileSystem[] fss = Repository.getDefault().toArray();
        RepositoryCP repositoryCP = this;
        synchronized (repositoryCP) {
            List en = this.entries;
            if (en != null) {
                ArrayList<CPEntry> x = new ArrayList<CPEntry>(en.size());
                perm = new int[en.size()];
                boolean changed = false;
                int i = 0;
                while (i < fss.length) {
                    FileSystem fs = fss[i];
                    if (this.accept(fs)) {
                        CPEntry entry = (CPEntry)this.capMap.get(fs.getCapability());
                        int idx = en.indexOf(entry);
                        if (idx == -1) {
                            perm = null;
                            changed = true;
                            break;
                        }
                        perm[idx] = x.size();
                        changed |= idx != perm[idx];
                        x.add(entry);
                    }
                    ++i;
                }
                if (!changed) {
                    return;
                }
                if (perm != null) {
                    this.changeEntries(x);
                } else {
                    this.entries = null;
                }
            }
        }
        this.firePropertyChange("entries", null, null);
        this.firePropertyChange("roots", null, null);
    }

    private void changeEntries(List l) {
        this.entries = Collections.unmodifiableList(l);
        this.roots = null;
    }

    private void addEntry(CPEntry en) {
        ArrayList<CPEntry> l = this.entries == null ? new ArrayList<CPEntry>() : new ArrayList(this.entries);
        l.add(en);
        this.capMap.put(en.getFileSystem().getCapability(), en);
        this.changeEntries(l);
    }

    private void removeEntry(CPEntry en) {
        ArrayList l = new ArrayList(this.entries);
        l.remove(en);
        this.capMap.remove(en.getFileSystem().getCapability());
        this.changeEntries(l);
    }

    void fileSystemAdded(FileSystem fs) {
        if (!this.accept(fs)) {
            return;
        }
        boolean needsUpdate = this.initializeEntries();
        if (needsUpdate) {
            this.addEntry(new CPEntry(fs));
        }
        this.firePropertyChange("entries", null, null);
        if (this.isValid(fs)) {
            this.rootsChanged();
        }
    }

    void rootsChanged() {
        this.roots = null;
        this.firePropertyChange("roots", null, null);
    }

    void fileSystemRemoved(FileSystem fs) {
        boolean entriesChanged;
        boolean bl = entriesChanged = this.entries == null;
        if (!entriesChanged) {
            RepositoryCP repositoryCP = this;
            synchronized (repositoryCP) {
                CPEntry en = null;
                Iterator it = this.entries.iterator();
                while (it.hasNext()) {
                    en = (CPEntry)it.next();
                    if (en.getFileSystem() != fs) continue;
                    entriesChanged = true;
                    break;
                }
                if (entriesChanged) {
                    this.removeEntry(en);
                }
            }
        }
        if (entriesChanged) {
            this.firePropertyChange("entries", null, null);
        }
        if (this.isValid(fs)) {
            this.rootsChanged();
        }
    }

    boolean isValid(FileSystem fs) {
        return fs.getRoot().isValid();
    }

    synchronized boolean initializeEntries() {
        if (this.entries != null) {
            return true;
        }
        FileSystem[] fss = RepositoryCP.getRepository().toArray();
        ArrayList<FileSystem> r = new ArrayList<FileSystem>(fss.length);
        int i = 0;
        while (i < fss.length) {
            FileSystemCapability fscap = fss[i].getCapability();
            if (fscap.capableOf(this.filterCap)) {
                r.add(fss[i]);
            }
            ++i;
        }
        this.changeEntries(r);
        return false;
    }

    static Repository getRepository() {
        return Repository.getDefault();
    }

    class CPEntry
    extends ClassPath.Entry {
        FileSystem fs;
        boolean active;

        CPEntry(FileSystem fs) {
            this.fs = fs;
        }

        final FileSystem getFileSystem() {
            return this.fs;
        }

        public ClassPath getDefiningClassPath() {
            return RepositoryCP.this;
        }

        public IOException getError() {
            try {
                URL dummy = this.fs.getRoot().getURL();
                return null;
            }
            catch (IOException ex) {
                return ex;
            }
        }

        public FileObject getRoot() {
            if (!this.isValid()) {
                return null;
            }
            return this.fs.getRoot();
        }

        public boolean isValid() {
            return this.fs.getRoot().isValid();
        }
    }
}

