/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.RepositoryCP;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.WeakListener;

class RepositoryL
implements RepositoryListener,
PropertyChangeListener {
    Map classpathMap;
    Map capMap;
    PropertyChangeListener wL;
    static RepositoryL instance;

    public static synchronized RepositoryL get() {
        if (instance != null) {
            return instance;
        }
        instance = new RepositoryL();
        return instance;
    }

    private RepositoryL() {
        this.initialize();
    }

    void initialize() {
        FileSystem[] lst = Repository.getDefault().toArray();
        this.capMap = new HashMap(lst.length);
        int i = 0;
        while (i < lst.length) {
            this.capMap.put(lst[i].getCapability(), lst[i]);
            ++i;
        }
        this.wL = WeakListener.propertyChange((PropertyChangeListener)this, null);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            Repository.getDefault().addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)Repository.getDefault()));
            Iterator it = this.capMap.keySet().iterator();
            while (it.hasNext()) {
                ((FileSystemCapability)it.next()).addPropertyChangeListener(this.wL);
            }
        }
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        FileSystem nue = ev.getFileSystem();
        Collection affected = this.findAffectedPaths(nue);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            this.capMap.put(nue.getCapability(), nue);
        }
        Iterator it = affected.iterator();
        while (it.hasNext()) {
            ((RepositoryCP)it.next()).fileSystemAdded(nue);
        }
        nue.getCapability().addPropertyChangeListener(this.wL);
    }

    synchronized Collection findAffectedPaths(FileSystem fs) {
        FileSystemCapability newCap = fs.getCapability();
        if (this.classpathMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList affected = new ArrayList(this.classpathMap.size());
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            Iterator it = this.classpathMap.entrySet().iterator();
            while (it.hasNext()) {
                Object o;
                Map.Entry e = it.next();
                FileSystemCapability cap = (FileSystemCapability)e.getKey();
                if (!newCap.capableOf(cap) || (o = ((Reference)e.getValue()).get()) == null) continue;
                affected.add(o);
            }
        }
        return affected;
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
        ArrayList cps;
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            if (this.classpathMap == null) {
                return;
            }
            cps = new ArrayList(this.classpathMap.values());
        }
        Iterator it = cps.iterator();
        while (it.hasNext()) {
            Reference cpref = (Reference)it.next();
            RepositoryCP cp = (RepositoryCP)cpref.get();
            if (cp == null) continue;
            cp.fileSystemsReordered(ev.getPermutation());
        }
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        FileSystem old = ev.getFileSystem();
        old.getCapability().removePropertyChangeListener(this.wL);
        Collection affected = this.findAffectedPaths(old);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            this.capMap.remove(old.getCapability());
        }
        Iterator it = affected.iterator();
        while (it.hasNext()) {
            ((RepositoryCP)it.next()).fileSystemRemoved(old);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        ArrayList paths;
        FileSystemCapability fscap = (FileSystemCapability)e.getSource();
        FileSystem fs = (FileSystem)this.capMap.get(fscap);
        RepositoryL repositoryL = this;
        synchronized (repositoryL) {
            paths = new ArrayList(this.classpathMap.values());
        }
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            RepositoryCP rcp = (RepositoryCP)((Reference)it.next()).get();
            if (rcp == null) continue;
            rcp.capsChanged(fs);
        }
    }

    synchronized ClassPath createClassPath(FileSystemCapability cap) {
        ClassPath cp;
        Reference cpref;
        if (this.classpathMap != null) {
            cpref = (Reference)this.classpathMap.get(cap);
        } else {
            cpref = null;
            this.classpathMap = new HashMap(4);
        }
        if (cpref != null && (cp = (ClassPath)cpref.get()) != null) {
            return cp;
        }
        cp = new RepositoryCP(cap);
        this.classpathMap.put(cap, new WeakReference<ClassPath>(cp));
        return cp;
    }

    public ClassPath getClassPath(String id) {
        if ("classpath/compile".equals(id)) {
            return this.createClassPath(FileSystemCapability.COMPILE);
        }
        if ("classpath/execute".equals(id)) {
            return this.createClassPath(FileSystemCapability.EXECUTE);
        }
        if ("classpath/debug".equals(id)) {
            return this.createClassPath(FileSystemCapability.DEBUG);
        }
        return null;
    }
}

