/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2003 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.vcs.profiles.commands;

import java.util.Hashtable;


import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.cmdline.RelativeMountDialog;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.openide.DialogDisplayer;

/**
 * This is a selector of relative mount point.
 * It can be used as a selector in the configuration variable input descriptor
 * in mount wizard and filesystem customizer.
 *
 * @author  Martin Entlicher
 */
public class RelativeMountPointSelector implements VcsAdditionalCommand, Runnable {
    
    private VcsFileSystem fileSystem = null;
    private String work;
    //private String dir;
    private String relMountPoint = null;

    /** Creates a new instance of RelativeMountPointSelector */
    public RelativeMountPointSelector() {
    }
    
    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }
    
    /**
     * This method is used to execute the command.
     * @param vars the variables that can be passed to the command
     * @param args the command line parametres passed to it in properties
     * @param stdoutListener listener of the standard output of the command
     * @param stderrListener listener of the error output of the command
     * @param stdoutDataListener listener of the standard output of the command which
     *                          satisfies regex <CODE>dataRegex</CODE>
     * @param dataRegex the regular expression for parsing the standard output
     * @param stderrDataListener listener of the error output of the command which
     *                          satisfies regex <CODE>errorRegex</CODE>
     * @param errorRegex the regular expression for parsing the error output
     * @return true if the command was succesfull
     *        false if some error occured.
     */
    public boolean exec(Hashtable vars, String[] args,
                        CommandOutputListener stdoutListener,
                        CommandOutputListener stderrListener,
                        CommandDataOutputListener stdoutDataListener, String dataRegex,
                        CommandDataOutputListener stderrDataListener, String errorRegex) {
        work = VcsFileSystem.substractRootDir(fileSystem.getRootDirectory().toString(), fileSystem.getRelativeMountPoint());
        //dir = work + java.io.File.separator + fileSystem.getRelativeMountPoint();
        try {
            javax.swing.SwingUtilities.invokeAndWait(this);
        } catch (InterruptedException iex) {
        } catch (java.lang.reflect.InvocationTargetException itex) {}
        if (relMountPoint != null) {
            stdoutDataListener.outputData(new String[] { relMountPoint });
        }
        return true;
    }
    
    /**
     * Acually show the relative mount point dialog in the AWT thread.
     */
    public void run() {
        RelativeMountDialog mountDlg = new RelativeMountDialog();
        mountDlg.setDir(work, fileSystem.getRelativeMountPoint());
        java.awt.Dialog dlg = DialogDisplayer.getDefault().createDialog(mountDlg);
        dlg.setVisible(true);
        relMountPoint = mountDlg.getRelMount();
    }
    
}
