/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class ColumnManager
implements LayoutManager,
Serializable {
    static final long serialVersionUID = -5706896066699438744L;
    private ColumnManager columnManager;
    private int height;
    private static float CRUCIAL_RATIO = 0.3f;

    public ColumnManager() {
        this(null);
    }

    public ColumnManager(LayoutManager layoutManager) {
        if (layoutManager instanceof ColumnManager) {
            this.columnManager = (ColumnManager)layoutManager;
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        if (n < 1) {
            return new Dimension(1, 1);
        }
        int n2 = 1;
        if (this.columnManager != null) {
            this.height = this.columnManager.getComponentHeight();
        } else {
            this.height = container.getComponent((int)0).getPreferredSize().height;
            int n3 = 0;
            while (n3 < n) {
                n2 = Math.max(n2, container.getComponent((int)n3).getPreferredSize().width);
                ++n3;
            }
            int n4 = container.getParent().getWidth();
            int n5 = (int)((float)n4 * CRUCIAL_RATIO);
            n2 = Math.max(Math.min(n2, n4 - n5), n5);
        }
        return new Dimension(n2, this.height * n);
    }

    public int getComponentHeight() {
        return this.height;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        if (container.getComponentCount() < 1) {
            return;
        }
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = container.getSize().width - (insets.left + insets.right);
        int n4 = this.columnManager != null ? this.columnManager.getComponentHeight() : container.getComponent((int)0).getPreferredSize().height;
        int n5 = 0;
        while (n5 < n) {
            container.getComponent(n5).setBounds(0, n2, n3, n4);
            n2 += n4;
            ++n5;
        }
    }
}

