/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.netbeans.nbbuild.Issue;
import org.netbeans.nbbuild.Issuezilla;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PlansPreprocess
extends Task {
    private String urlBase = "http://www.netbeans.org/issues/";
    private File src;
    private File target;
    private String proxyHost;
    private int proxyPort = -1;
    private File nicknames;
    private int maxIOFailures = 5;
    private HashMap issues = new HashMap(101);
    private Properties names = new Properties();
    private HashMap owners;
    private HashSet components;
    private HashSet subcomponents;

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String string) {
        this.urlBase = string;
    }

    public File getSrc() {
        return this.src;
    }

    public void setSrc(File file) {
        this.src = file;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File file) {
        this.target = file;
    }

    public File getNicknames() {
        return this.nicknames;
    }

    public void setNicknames(File file) {
        this.nicknames = file;
    }

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        block28: {
            Object object;
            block27: {
                if (this.getTarget() == null) {
                    throw new BuildException("Must set target");
                }
                if (this.getSrc() == null) {
                    throw new BuildException("Must set target");
                }
                object = null;
                Object object2 = null;
                if (this.proxyPort != -1) {
                    object = System.getProperties().put("http.proxyPort", new Integer(this.proxyPort).toString());
                }
                if (this.proxyHost != null) {
                    object2 = System.getProperties().put("http.proxyHost", this.proxyHost);
                }
                this.log("Reading: " + this.getSrc());
                try {
                    NamedNodeMap namedNodeMap;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Node node;
                    Object object7;
                    Issue[] issueArray;
                    Issuezilla issuezilla = new Issuezilla(new URL(this.getUrlBase()));
                    this.log("Searching for issue references");
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getSrc());
                    this.components = new HashSet();
                    this.subcomponents = new HashSet();
                    this.owners = new HashMap();
                    NodeList nodeList = document.getElementsByTagName("requirement");
                    ArrayList<Issue[]> arrayList = new ArrayList<Issue[]>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    int n = nodeList.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        issueArray = nodeList.item(n2);
                        object7 = issueArray.getAttributes();
                        node = object7.getNamedItem("issue");
                        if (node != null) {
                            arrayList.add(issueArray);
                            arrayList2.add(node.getNodeValue());
                        }
                        ++n2;
                    }
                    if (arrayList2.size() > 0) {
                        this.log("Retrieving issues " + arrayList2 + " from " + this.getUrlBase());
                        issueArray = this.findIssues(issuezilla, arrayList2.toArray(new String[0]));
                        if (issueArray.length != arrayList.size()) {
                            throw new BuildException("Error: issues = " + issueArray.length + " requested: " + arrayList.size());
                        }
                        this.log("Updating the issues");
                        if (this.getNicknames() != null) {
                            object7 = new FileInputStream(this.getNicknames());
                            this.names.load((InputStream)object7);
                            ((InputStream)object7).close();
                        }
                        int n3 = 0;
                        while (n3 < issueArray.length) {
                            node = (Node)arrayList.get(n3);
                            object6 = issueArray[n3];
                            this.fillRequirement(issuezilla, document, (Issue)object6, node, new HashSet());
                            ++n3;
                        }
                        this.log("Writing result to " + this.getTarget());
                    } else {
                        this.log("No issues to synchronize. Copying file to " + this.getTarget());
                    }
                    issueArray = document.createElement("components");
                    Iterator<Object> iterator = this.components.iterator();
                    while (iterator.hasNext()) {
                        issueArray.appendChild(PlansPreprocess.createComponent(document, false, (String)iterator.next()));
                    }
                    iterator = this.subcomponents.iterator();
                    while (iterator.hasNext()) {
                        issueArray.appendChild(PlansPreprocess.createComponent(document, true, (String)iterator.next()));
                    }
                    document.getDocumentElement().appendChild((Node)issueArray);
                    node = document.createElement("owners");
                    iterator = this.owners.keySet().iterator();
                    while (iterator.hasNext()) {
                        object6 = (String)iterator.next();
                        object5 = (String)this.owners.get(object6);
                        object4 = document.createElement("owner");
                        object4.setAttribute("nickname", (String)object5);
                        object4.setAttribute("e-mail", (String)object6);
                        node.appendChild((Node)object4);
                    }
                    document.getDocumentElement().appendChild(node);
                    document.getDocumentElement().appendChild(node);
                    object6 = document.createElement("other");
                    object5 = document.createElement("today");
                    object5.setAttribute("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                    object4 = Calendar.getInstance();
                    ((Calendar)object4).add(5, 7);
                    object5.setAttribute("nextweek", new SimpleDateFormat("yyyy-MM-dd").format(((Calendar)object4).getTime()));
                    object6.appendChild((Node)object5);
                    document.getDocumentElement().appendChild((Node)object6);
                    nodeList = document.getElementsByTagName("requirement");
                    HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
                    n = nodeList.getLength();
                    int n4 = 0;
                    while (n4 < n) {
                        object3 = nodeList.item(n4);
                        namedNodeMap = object3.getAttributes();
                        Node node2 = namedNodeMap.getNamedItem("issue");
                        if (node2 != null) {
                            int n5;
                            Integer n6 = Integer.valueOf(node2.getNodeValue());
                            int[] nArray = (int[])hashMap.get(n6);
                            if (nArray == null) {
                                n5 = 1;
                                hashMap.put(n6, new int[]{1});
                            } else {
                                n5 = nArray[0] = nArray[0] + 1;
                            }
                            Attr attr = document.createAttribute("appearance");
                            attr.setNodeValue(String.valueOf(n5));
                            namedNodeMap.setNamedItem(attr);
                        }
                        ++n4;
                    }
                    object3 = new BufferedOutputStream(new FileOutputStream(this.getTarget()));
                    namedNodeMap = new XMLSerializer((OutputStream)object3, new OutputFormat("UTF-8", "UTF-8", true));
                    namedNodeMap.serialize(document);
                    ((OutputStream)object3).close();
                    Object var26_30 = null;
                    if (object2 == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var26_31 = null;
                    if (object2 != null) {
                        System.setProperty("http.proxyHost", (String)object2);
                    }
                    if (object != null) {
                        System.setProperty("http.proxy", (String)object);
                    }
                    throw throwable;
                }
                System.setProperty("http.proxyHost", (String)object2);
            }
            if (object != null) {
                System.setProperty("http.proxy", (String)object);
            }
            break block28;
            {
                catch (IOException iOException) {
                    throw new BuildException((Throwable)iOException);
                }
                catch (SAXException sAXException) {
                    throw new BuildException((Throwable)sAXException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new BuildException((Throwable)parserConfigurationException);
                }
            }
        }
    }

    private void fillRequirement(Issuezilla issuezilla, Document document, Issue issue, Node node, HashSet hashSet) throws SAXException, IOException {
        if (!hashSet.add(issue)) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.fillMissingAttribute(document, issue.getTargetMilestone(), namedNodeMap, "target");
        this.fillMissingAttribute(document, String.valueOf(issue.getPriority()), namedNodeMap, "issue-priority");
        this.fillMissingAttribute(document, this.mapPriority(issue.getPriority()), namedNodeMap, "priority");
        this.fillMissingAttribute(document, this.mapPercentage(issuezilla, issue), namedNodeMap, "percentage-complete");
        this.fillMissingAttribute(document, issue.getSummary(), namedNodeMap, "name");
        this.fillMissingAttribute(document, String.valueOf(issue.getVotes()), namedNodeMap, "votes");
        this.fillMissingAttribute(document, String.valueOf(issue.getKeywords()), namedNodeMap, "keywords");
        this.fillMissingAttribute(document, this.mapUserImpact(issue.getType()), namedNodeMap, "user-impact");
        String string = String.valueOf(issue.getComponent());
        this.components.add(string);
        String string2 = String.valueOf(issue.getSubcomponent());
        this.subcomponents.add(string2);
        this.fillMissingAttribute(document, string, namedNodeMap, "component");
        this.fillMissingAttribute(document, string2, namedNodeMap, "subcomponent");
        PlansPreprocess.checkPersons(document, issue, node, this.names, this.owners);
        this.checkRequirements(issuezilla, document, issue, node, hashSet);
        PlansPreprocess.checkLongDescription(document, issue, node);
    }

    private void checkRequirements(Issuezilla issuezilla, Document document, Issue issue, Node node, HashSet hashSet) throws SAXException, IOException {
        Node node2;
        Object object;
        int[] nArray = issue.getDependsOn();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Object object2 = new TreeSet();
        this.addDependencies(issuezilla, issue, (Set)object2);
        ((TreeSet)object2).remove(issue);
        Object object3 = ((TreeSet)object2).iterator();
        while (object3.hasNext()) {
            object = (Issue)object3.next();
            Element element = document.createElement("req-link");
            element.setAttribute("href", this.urlBase + "show_bug.cgi?id=" + ((Issue)object).getId());
            element.appendChild(document.createTextNode(((Issue)object).getSummary() + " (" + PlansPreprocess.mapFinished((Issue)object) + ")"));
            node.appendChild(element);
        }
        object2 = null;
        object3 = new HashSet();
        object = node.getChildNodes();
        int n = object.getLength();
        int n2 = 0;
        while (n2 < n) {
            node2 = object.item(n2);
            if (node2.getNodeName().equals("requirements") && node2 instanceof Element) {
                object2 = (Element)node2;
                break;
            }
            ++n2;
        }
        if (object2 == null) {
            object2 = document.createElement("requirements");
            node.appendChild((Node)object2);
        } else {
            object = object2.getChildNodes();
            n = object.getLength();
            n2 = 0;
            while (n2 < n) {
                String string;
                Node node3;
                node2 = object.item(n2);
                if (node2.getNodeName().equals("requirement") && (node3 = node2.getAttributes().getNamedItem("issue")) != null && (string = node3.getNodeValue()) != null) {
                    ((HashSet)object3).add(Integer.valueOf(string));
                }
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            Integer n4 = new Integer(nArray[n3]);
            if (!((HashSet)object3).contains(n4)) {
                Issue issue2 = issuezilla.getBug(nArray[n3]);
                node2 = document.createElement("requirement");
                node2.setAttribute("issue", n4.toString());
                this.fillRequirement(issuezilla, document, issue2, node2, hashSet);
                object2.appendChild(node2);
            }
            ++n3;
        }
    }

    private static void checkLongDescription(Document document, Issue issue, Node node) throws IOException {
        Object object;
        Object object2;
        if (issue.getDescriptions().length == 0) {
            return;
        }
        Issue.Description description = issue.getDescriptions()[0];
        if ("".equals(description.getBody())) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            object2 = nodeList.item(n2);
            if (object2.getNodeName().equals("long-description")) {
                return;
            }
            ++n2;
        }
        object2 = new StringBuffer(1024);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(description.getBody()));
        Element element = document.createElement("body");
        while (true) {
            if ((object = bufferedReader.readLine()) == null || ((String)object).length() == 0) {
                Element element2 = document.createElement("P");
                element2.appendChild(document.createTextNode(((StringBuffer)object2).toString()));
                element.appendChild(element2);
                ((StringBuffer)object2).setLength(0);
            }
            if (object == null) break;
            if (((String)object).length() <= 0) continue;
            ((StringBuffer)object2).append((String)object);
            ((StringBuffer)object2).append("\n");
        }
        object = document.createElement("long-description");
        object.appendChild(element);
        node.appendChild((Node)object);
    }

    private static void checkPersons(Document document, Issue issue, Node node, Properties properties, HashMap hashMap) {
        Node node2;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            node2 = nodeList.item(n2);
            if (node2.getNodeName().equals("roles")) {
                return;
            }
            ++n2;
        }
        node2 = document.createElement("roles");
        node2.appendChild(PlansPreprocess.createPerson(document, issue.getAssignedTo(), "responsible", properties));
        node2.appendChild(PlansPreprocess.createPerson(document, issue.getReportedBy(), "initiator", properties));
        hashMap.put(issue.getAssignedTo(), PlansPreprocess.findNickname(issue.getAssignedTo(), properties));
        String[] stringArray = issue.getObservedBy();
        int n3 = 0;
        while (n3 < stringArray.length) {
            node2.appendChild(PlansPreprocess.createPerson(document, stringArray[n3], "consultant", properties));
            ++n3;
        }
        node.appendChild(node2);
    }

    private static Element createPerson(Document document, String string, String string2, Properties properties) {
        Element element = document.createElement("person");
        String string3 = PlansPreprocess.findNickname(string, properties);
        element.setAttribute("nickname", string3);
        Element element2 = document.createElement("e-mail");
        element2.appendChild(document.createTextNode(string));
        Element element3 = document.createElement("role");
        element3.setAttribute("name", string2);
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }

    private static Element createComponent(Document document, boolean bl, String string) {
        Element element = document.createElement(bl ? "subcomponent" : "component");
        element.setAttribute("name", string);
        return element;
    }

    private void fillMissingAttribute(Document document, String string, NamedNodeMap namedNodeMap, String string2) {
        if (namedNodeMap.getNamedItem(string2) == null) {
            Attr attr = document.createAttribute(string2);
            attr.setValue(string);
            namedNodeMap.setNamedItem(attr);
        }
    }

    private String mapUserImpact(String string) {
        if ("FEATURE".equals(string)) {
            return "high";
        }
        if ("ENHANCEMENT".equals(string)) {
            return "low";
        }
        return "medium";
    }

    private String mapPercentage(Issuezilla issuezilla, Issue issue) throws SAXException, IOException {
        HashSet hashSet = new HashSet();
        int n = this.countFinished(issuezilla, issue, hashSet);
        int n2 = hashSet.size();
        if (PlansPreprocess.isFinished(issue)) {
            return "100";
        }
        return n + " of " + hashSet.size();
    }

    private int countFinished(Issuezilla issuezilla, Issue issue, HashSet hashSet) throws SAXException, IOException {
        this.addDependencies(issuezilla, issue, hashSet);
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Issue issue2 = (Issue)iterator.next();
            if (!PlansPreprocess.isFinished(issue2)) continue;
            ++n;
        }
        return n;
    }

    private void addDependencies(Issuezilla issuezilla, Issue issue, Set set) throws SAXException, IOException {
        if (set.contains(issue)) {
            return;
        }
        set.add(issue);
        int[] nArray = issue.getDependsOn();
        int n = 0;
        while (n < nArray.length) {
            Issue issue2 = this.findIssue(issuezilla, nArray[n]);
            this.addDependencies(issuezilla, issue2, set);
            ++n;
        }
    }

    private static String mapFinished(Issue issue) {
        if (PlansPreprocess.isFinished(issue)) {
            return "Done";
        }
        return issue.getStatus().toLowerCase();
    }

    private static boolean isFinished(Issue issue) {
        if ("NEW".equals(issue.getStatus())) {
            return false;
        }
        if ("STARTED".equals(issue.getStatus())) {
            return false;
        }
        if ("FIXED".equals(issue.getResolution())) {
            return true;
        }
        return "VERIFIED".equals(issue.getStatus());
    }

    private String mapPriority(int n) {
        String string = "issue.priority." + n;
        String string2 = this.getProject().getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (n == 1) {
            return "high";
        }
        if (n == 2) {
            return "medium";
        }
        return "small";
    }

    private Issue[] findIssues(Issuezilla issuezilla, String[] stringArray) throws SAXException, IOException {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Integer.parseInt(stringArray[n]);
            ++n;
        }
        Issue[] issueArray = issuezilla.getBugs(nArray);
        int n2 = 0;
        while (n2 < nArray.length) {
            this.issues.put(new Integer(nArray[n2]), issueArray[n2]);
            ++n2;
        }
        return issueArray;
    }

    private Issue findIssue(Issuezilla issuezilla, int n) throws SAXException, IOException {
        Integer n2 = new Integer(n);
        Issue issue = (Issue)this.issues.get(n2);
        if (issue != null) {
            return issue;
        }
        this.log("Retrieving issue " + n);
        issue = issuezilla.getBug(n);
        this.issues.put(n2, issue);
        return issue;
    }

    private static String findNickname(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        int n = string.indexOf(64);
        if (n != -1) {
            String string3 = string.substring(0, n);
            string2 = properties.getProperty(string3);
            if (string2 != null) {
                return string2;
            }
            return string3;
        }
        return string;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.proxyHost = string;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }
}

