/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: inheritnode.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:53:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_INHERITNODE_HXX
#define ARY_INHERITNODE_HXX

// USED SERVICES
	// BASE CLASSES
#include <ary/ids.hxx>
	// COMPONENTS
	// PARAMETERS


namespace ary
{
namespace n22
{
    class Repository;
    class RepositoryEntity;
}

namespace inherit
{


/**	@resp

	@descr
*/
class Node
{
  public:
    typedef std::vector< Node* >            List;
    typedef std::vector< Node* >::iterator  Iterator;

    // LIFECYCLE
                        Node(
                            const String &      i_name,
                            Rid                 i_ce );
                        ~Node();

    // OPERATIONS
    static void         Join(
                            DYN Node &          io_base,
                            DYN Node &          io_derived );
    // INQUIRY
    const String &      Name() const            { return sName; }
    Rid                 RelatedCe() const       { return nCodeEntity; }

    const List &        Bases() const           { return aBases; }
    const List &        Derivates() const       { return aDerivates; }
    intt                Count_AllBases() const  { return nCountBases; }
    intt                Count_AllDerivates() const
                                                { return nCountDerivates; }
  private:
    typedef std::vector< Node* >            NodeList;
    typedef std::vector< Node* >::iterator  NodeIterator;

    void                UpdateBasesCount(
                            intt                i_difference );
    void                UpdateDerivatesCount(
                            intt                i_difference );


    // DATA
    List                aBases;
    intt                nCountBases;
    List                aDerivates;
    intt                nCountDerivates;

    String              sName;
    Rid                 nCodeEntity;
};


// IMPLEMENTATION


}   // namespace inherit
}   // namespace ary

#endif
