/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: process.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:18:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifdef WNT
#include    <tools/prewin.h>
#include "winbase.h"
#include    <tools/postwin.h>
#endif

#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif
#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif
#ifndef _SBXCORE_HXX
#include <sbxcore.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _BASIC_TTRESHLP_HXX
#include "ttstrhlp.hxx"
#endif

//#ifndef _BYTE_STRING_LIST
//DECLARE_LIST( ByteStringList, ByteString * );
//#define _BYTE_STRING_LIST
//#endif

#include "process.hxx"

// Konstruktor fr den Process
Process::Process()
: bWasGPF( FALSE )
, pArgumentList( NULL )
, pEnvList( NULL )
, pProcess( NULL )
, bHasBeenStarted( FALSE )
{
}

// Destruktor
Process::~Process()
{
//    delete pArgumentList;
//    delete pEnvList;
	delete pProcess;
}


BOOL Process::ImplIsRunning()
{
	if ( pProcess && bHasBeenStarted )
	{
		NAMESPACE_VOS(OProcess::TProcessInfo) aProcessInfo;
		pProcess->getInfo( NAMESPACE_VOS(OProcess::TData_ExitCode), &aProcessInfo );
		if ( !(aProcessInfo.Fields & NAMESPACE_VOS(OProcess::TData_ExitCode)) )
			return TRUE;
		else
			return FALSE;
	}
	else
		return FALSE;
}

long Process::ImplGetExitCode()
{
	if ( pProcess )
	{
		NAMESPACE_VOS(OProcess::TProcessInfo) aProcessInfo;
		pProcess->getInfo( NAMESPACE_VOS(OProcess::TData_ExitCode), &aProcessInfo );
		if ( !(aProcessInfo.Fields & NAMESPACE_VOS(OProcess::TData_ExitCode)) )
			SbxBase::SetError( SbxERR_NO_ACTIVE_OBJECT );
		return aProcessInfo.Code;
	}
	else
		SbxBase::SetError( SbxERR_NO_ACTIVE_OBJECT );
		return 0;
}


////////////////////////////////////////////////////////////////////////////

// Die Methoden:
void Process::SetImage( const String &aAppPath, const String &aAppParams, const Environment *pEnv )
{ // Imagedatei des Executables
	if ( pProcess && ImplIsRunning() )
		SbxBase::SetError( SbxERR_NO_ACTIVE_OBJECT );
	else
	{
		delete pArgumentList; pArgumentList = NULL;
		delete pEnvList; pEnvList = NULL;
		delete pProcess; pProcess = NULL;

		xub_StrLen i, nCount = aAppParams.GetQuotedTokenCount( CUniString("\"\"" ), ' ' );
		::rtl::OUString *pParamList = new ::rtl::OUString[nCount];

        xub_StrLen nParamCount = 0;
		for ( i = 0 ; i < nCount ; i++ )
		{
			::rtl::OUString aTemp = ::rtl::OUString(aAppParams.GetQuotedToken( i, CUniString("\"\"''" ), ' ' ));
			if ( aTemp.getLength() )
            {
				pParamList[nParamCount] = aTemp;
                nParamCount++;
            }
		}
		pArgumentList = new NAMESPACE_VOS(OArgumentList)( pParamList, nCount );


        ::rtl::OUString *pEnvArray = NULL;
        if ( pEnv )
        {

            nCount = pEnv->size();
		    pEnvArray = new ::rtl::OUString[nCount];

            xub_StrLen nEnvCount = 0;
            Environment::const_iterator aIter = pEnv->begin();
		    while ( aIter != pEnv->end() )
		    {
			    ::rtl::OUString aTemp = ::rtl::OUString( (*aIter).first );
                aTemp += ::rtl::OUString::createFromAscii( "=" );
			    aTemp += ::rtl::OUString( (*aIter).second );
			    pEnvArray[nEnvCount] = aTemp;
                nEnvCount++;
                aIter++;
		    }
		    pEnvList = new NAMESPACE_VOS(OEnvironment)( pEnvArray, nEnvCount );
        }

        ::rtl::OUString aNormalizedAppPath;
		osl::FileBase::getFileURLFromSystemPath( ::rtl::OUString(aAppPath), aNormalizedAppPath );
		pProcess = new NAMESPACE_VOS(OProcess)( aNormalizedAppPath );
		bHasBeenStarted = FALSE;

        delete [] pParamList;
        delete [] pEnvArray;
	}
}

BOOL Process::Start()
{ // Programm wird gestartet
	BOOL bSuccess=FALSE;
	if ( pProcess && !ImplIsRunning() )
	{
		bWasGPF = FALSE;
#ifdef WNT
//		sal_uInt32 nErrorMode = SetErrorMode(SEM_NOOPENFILEERRORBOX | SEM_NOALIGNMENTFAULTEXCEPT | SEM_FAILCRITICALERRORS | SEM_NOGPFAULTERRORBOX);
		sal_uInt32 nErrorMode = SetErrorMode(SEM_NOOPENFILEERRORBOX | SEM_NOALIGNMENTFAULTEXCEPT | SEM_NOGPFAULTERRORBOX);
		try
		{
#endif
            if ( pEnvList )
            {
                bSuccess = pProcess->execute( (NAMESPACE_VOS(OProcess)::TProcessOption)
						    ( NAMESPACE_VOS(OProcess)::TOption_SearchPath
						    /*| NAMESPACE_VOS(OProcess)::TOption_Detached*/
						    /*| NAMESPACE_VOS(OProcess)::TOption_Wait*/ ),
						    *pArgumentList, 
						    *pEnvList ) == NAMESPACE_VOS(OProcess)::E_None;
            }
            else
            {
                bSuccess = pProcess->execute( (NAMESPACE_VOS(OProcess)::TProcessOption)
						    ( NAMESPACE_VOS(OProcess)::TOption_SearchPath
						    /*| NAMESPACE_VOS(OProcess)::TOption_Detached*/
						    /*| NAMESPACE_VOS(OProcess)::TOption_Wait*/ ),
						    *pArgumentList ) == NAMESPACE_VOS(OProcess)::E_None;
            }
#ifdef WNT
		}
		catch( ... ) 
		{
			bWasGPF = TRUE;
		}
		nErrorMode = SetErrorMode(nErrorMode);
#endif
		bHasBeenStarted = bSuccess;
	}
	else
		SbxBase::SetError( SbxERR_NO_ACTIVE_OBJECT );
	return bSuccess;
}

ULONG Process::GetExitCode()
{ // ExitCode des Programms(nachdem es beendet ist)
	return ImplGetExitCode();
}

BOOL Process::IsRunning()
{ // Programm luft noch
	return ImplIsRunning();
}

BOOL Process::WasGPF()
{ // Programm mit GPF o.. abgebrochen
#ifdef WNT
	return ImplGetExitCode() == 3221225477;
#else
	return bWasGPF;
#endif
}

BOOL Process::Terminate()
{
    if ( ImplIsRunning() )
        return pProcess->terminate() == vos::OProcess::E_None;
    return TRUE;
}

