/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: marshal.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2006/01/10 15:49:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <com/sun/star/uno/Sequence.hxx>
#ifndef INCLUDED_CPPU_UNOTYPE_HXX
#include "cppu/unotype.hxx"
#endif

typedef struct _uno_Environment uno_Environment;	
struct remote_Interface;
//struct rtl_String;

typedef void ( SAL_CALL * extractOidCallback ) (
	remote_Interface *pRemoteI,
	rtl_uString **ppOid ,
	rtl_uString **ppType );

namespace bridges_remote
{	
class Marshal
{
public:
	Marshal( sal_Bool bIsLittleEndian,
			 uno_Environment *pEnvRemote = 0,
			 extractOidCallback callback= 0 ,
			 sal_Int32 nStartMarshalingAt = 0 );
	Marshal(
		sal_Bool bIsLittleEndian ,
		const ::com::sun::star::uno::Sequence< sal_Int8 > &seqFixedSized );

	void pack( void *pSource , const ::com::sun::star::uno::Type &rType );
	void pack( void *pSource , typelib_TypeDescription *pType );

	// Used only to pack protocol dependend 
	void packByteSequence( sal_Int8 *pBuffer , sal_Int32 nSize );
	
	::com::sun::star::uno::Sequence < sal_Int8 > remove();

	inline sal_Int32 getPos()
		{ return m_pos - m_base; }
	
private:
	inline void align( sal_Int32 nToAlign );
	inline void ensureAdditionalMem( sal_Int32 nMemToAdd );
	
	::com::sun::star::uno::Sequence < sal_Int8 > m_seqData;
	sal_Bool m_nStartMarshalingAt;
	sal_Bool m_bIsLittleEndian;
	sal_Int8 *m_pos;
	sal_Int8 *m_base;
	extractOidCallback m_callback;
	uno_Environment *m_pEnvRemote;
};


template < class C >
inline void operator <<= (Marshal & r,  C& value)
{
	r.pack( &value, cppu::getTypeFavourUnsigned( &value ) );
}

}
