/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ChildHelper.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/10/19 11:51:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef DBA_COREDATAACCESS_CHILDHELPER_HXX
#define DBA_COREDATAACCESS_CHILDHELPER_HXX

#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

//........................................................................
namespace dbaccess
{
//........................................................................

class OChildHelper_Impl : public ::cppu::WeakImplHelper1 < ::com::sun::star::container::XChild >
{
	::osl::Mutex m_aMutex;
	::com::sun::star::uno::WeakReference< ::com::sun::star::container::XChild> m_xChild;

public:
    OChildHelper_Impl( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XChild>& _xChild ) : m_xChild(_xChild)
    {
    }

    virtual ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > SAL_CALL getParent(  ) throw (::com::sun::star::uno::RuntimeException)
    {
        ::com::sun::star::uno::Reference< ::com::sun::star::container::XChild> xChild(m_xChild.get(),::com::sun::star::uno::UNO_QUERY);
        return xChild.is() ? xChild->getParent() : ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >();
    }
    virtual void SAL_CALL setParent( const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _Parent ) throw (::com::sun::star::lang::NoSupportException, ::com::sun::star::uno::RuntimeException)
    {
        ::com::sun::star::uno::Reference< ::com::sun::star::container::XChild> xChild(m_xChild.get(),::com::sun::star::uno::UNO_QUERY);
        if ( xChild.is() )
            xChild->setParent(_Parent);
    }

};
//........................................................................
}	// namespace dbaccess
//........................................................................
#endif // DBA_COREDATAACCESS_CHILDHELPER_HXX

