/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pkgchk_app.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 17:44:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "unopkg_shared.h"
#include "rtl/ustrbuf.hxx"
#include "osl/thread.h"
#include "osl/process.h"
#include "cppuhelper/exc_hlp.hxx"
#include "comphelper/anytostring.hxx"
#include <stdio.h>
#include <vector>

#define APP_NAME "pkgchk"


using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::unopkg;
using ::rtl::OUString;

namespace {

//------------------------------------------------------------------------------
const char s_usingText [] =
"\n"
"WARNING: This tool is deprecated!  Please use unopkg instead!\n"
"\n"
"using: " APP_NAME " <switches> [package1] [package2] ...\n"
"\n"
"switches:\n"
" -s, --shared            check/install shared components; default: user\n"
" -f, --force_overwrite   force overwriting existing packages\n"
" -v, --verbose           verbose output to stdout\n"
" -q, --quiet             no output except for errors\n"
" -l, --log <file>        custom log file; default: <cache-dir>/log.txt\n"
" -r, --renewal           export feature: reinstall all deployed packages\n"
" -h, --help              this help\n"
"\n"
APP_NAME " looks for UNO packages in the UNO_USER_PACKAGES or"
" UNO_SHARED_PACKAGES\n"
"directory (see option -s) which are specified in the "
SAL_CONFIGFILE("uno") ".\n"
"It registers and revokes packages from a cache directory specified via the\n"
"corresponding UNO_USER_PACKAGES_CACHE or UNO_SHARED_PACKAGES_CACHE "
"(option -s)\n"
"variables.\n"
"If any packages (ordinary files, .zip files) are given via command "
"line,\n"
"then these are copied into the packages directory in advance.\n"
"For details concerning package structure, please read the developer's guide:\n"
"http://api.openoffice.org/DevelopersGuide/" APP_NAME ".html\n";

//------------------------------------------------------------------------------
const OptionInfo s_option_infos [] = {
    { RTL_CONSTASCII_STRINGPARAM("shared"), 's', false },
    { RTL_CONSTASCII_STRINGPARAM("renewal"), 'r', false },
    { RTL_CONSTASCII_STRINGPARAM("force_overwrite"), 'f', false },
    { RTL_CONSTASCII_STRINGPARAM("verbose"), 'v', false },
    { RTL_CONSTASCII_STRINGPARAM("quiet"), 'q', false },
    { RTL_CONSTASCII_STRINGPARAM("log"), 'l', true },
    { RTL_CONSTASCII_STRINGPARAM("strict_error_handling"), '\0', false },
    { RTL_CONSTASCII_STRINGPARAM("supersede_basic_libs"), '\0', false },
    { RTL_CONSTASCII_STRINGPARAM("check_unorc_only"), '\0', false },
    { RTL_CONSTASCII_STRINGPARAM("no_unorc_patch"), '\0', false },
    { RTL_CONSTASCII_STRINGPARAM("help"), 'h', false },
    { 0, 0, '\0', false }
};

} // anon namespace

//==============================================================================
void pkgchk_copyAndBalance(
    ::std::vector<OUString> const & cmd_packages,
    bool option_shared, bool option_renewal,
    Reference< ::com::sun::star::ucb::XCommandEnvironment > const & xCmdEnv,
    Reference<XComponentContext> const & xComponentContext );

//##############################################################################
int SAL_CALL main (int argc, char ** argv)
{
	osl_setCommandArgs (argc, argv);

    DisposeGuard disposeGuard;
    rtl_TextEncoding textenc = osl_getThreadTextEncoding();
    
    bool option_shared = false;
    bool option_renewal = false;
    bool option_force_overwrite = false;
    bool option_verbose = false;
    bool option_quiet = false;
    OUString log_file;
    OUString cmd_arg;
    ::std::vector< OUString > cmd_packages;
    
    OptionInfo const * info_shared = getOptionInfo(
        s_option_infos, OUSTR("shared") );
    OptionInfo const * info_renewal = getOptionInfo(
        s_option_infos, OUSTR("renewal") );
    OptionInfo const * info_force_overwrite = getOptionInfo(
        s_option_infos, OUSTR("force_overwrite") );
    OptionInfo const * info_verbose = getOptionInfo(
        s_option_infos, OUSTR("verbose") );
    OptionInfo const * info_quiet = getOptionInfo(
        s_option_infos, OUSTR("quiet") );
    OptionInfo const * info_log = getOptionInfo(
        s_option_infos, OUSTR("log") );
    OptionInfo const * info_strict_error_handling = getOptionInfo(
        s_option_infos, OUSTR("strict_error_handling") );
    OptionInfo const * info_supersede_basic_libs = getOptionInfo(
        s_option_infos, OUSTR("supersede_basic_libs") );
    OptionInfo const * info_check_unorc_only = getOptionInfo(
        s_option_infos, OUSTR("check_unorc_only") );
    OptionInfo const * info_no_unorc_patch = getOptionInfo(
        s_option_infos, OUSTR("no_unorc_patch") );
    OptionInfo const * info_help = getOptionInfo(
        s_option_infos, OUSTR("help") );
    OptionInfo const * info;
    
    try {
        sal_uInt32 nCount = osl_getCommandArgCount();
        for ( sal_uInt32 nPos = 0; nPos < nCount; )
        {
            // options
            if (isOption( info_help, &nPos ))
            {
                printf( "%s\n", s_usingText );
                return 0;
            }
            else if (isOption( info = info_check_unorc_only, &nPos ) ||
                     isOption( info = info_no_unorc_patch, &nPos ) ||
                     isOption( info = info_strict_error_handling, &nPos ) ||
                     isOption( info = info_supersede_basic_libs, &nPos ))
            {
                fprintf( stderr, "WARNING: ignoring deprecated option %s!",
                         toString( info ).getStr() );
            }
            else if (readArgument( &cmd_arg, info_log, &nPos ))
            {
                log_file = makeAbsoluteFileUrl(
                    cmd_arg.trim(), getProcessWorkingDir() );
            }
            else if (!readOption( &option_verbose, info_verbose, &nPos ) &&
                     !readOption( &option_quiet, info_quiet, &nPos ) &&
                     !readOption( &option_renewal, info_renewal, &nPos ) &&
                     !readOption( &option_shared, info_shared, &nPos ) &&
                     !readOption( &option_force_overwrite,
                                  info_force_overwrite, &nPos ))
            {
                oslProcessError rc = osl_getCommandArg( nPos, &cmd_arg.pData );
                OSL_ASSERT( rc == osl_Process_E_None );
                ++nPos;
                cmd_arg = cmd_arg.trim();
                if (cmd_arg.getLength() > 0)
                {
                    if (cmd_arg[ 0 ] == '-') // is option
                    {
                        fprintf( stderr, "ERROR: unknown option %s!  Use "
                                 APP_NAME " %s to print all options.",
                                 ::rtl::OUStringToOString(
                                     cmd_arg, textenc ).getStr(),
                                 toString( info_help ).getStr() );
                        return 1;
                    }
                    else // package
                    {
                        cmd_packages.push_back(
                            makeAbsoluteFileUrl( cmd_arg,
                                                 getProcessWorkingDir() ) );
                    }
                }
            }
        }
        
        if (! option_quiet)
            fprintf( stderr, "\n"
                     "WARNING: This tool is deprecated!  "
                     "Please use unopkg instead!\n" );
        
        Reference<XComponentContext> xComponentContext(
            getUNO( disposeGuard, !option_quiet && option_verbose ) );
        
        Reference< ::com::sun::star::ucb::XCommandEnvironment > xCmdEnv(
            createCmdEnv( xComponentContext, log_file,
                          option_force_overwrite,
                          !option_quiet && option_verbose ) );
        
        pkgchk_copyAndBalance( cmd_packages, option_shared, option_renewal,
                               xCmdEnv, xComponentContext );

        if (! option_quiet)
            printf( "\n%s done.\n", APP_NAME );
        return 0;
    }
    catch (ucb::CommandFailedException &) {
        // already handled by cmdenv
    }
    catch (ucb::CommandAbortedException &) {
        fprintf( stderr, "\n%s aborted!\n", APP_NAME );
    }
    catch (deployment::DeploymentException & exc) {
        fprintf( stderr,
                 "\nERROR: %s\n"
                 "       Cause: %s\n",
                 ::rtl::OUStringToOString(
                     exc.Message, textenc ).getStr(),
                 ::rtl::OUStringToOString(
                     option_verbose
                     ? ::comphelper::anyToString(exc.Cause)
                     : reinterpret_cast<
                     ::com::sun::star::uno::Exception const *>(
                         exc.Cause.getValue())->Message, textenc).getStr() );
    }
    catch (::com::sun::star::uno::Exception &) {
        Any exc( ::cppu::getCaughtException() );
        fprintf( stderr, "\nERROR: %s\n", ::rtl::OUStringToOString(
                     ::comphelper::anyToString(exc), textenc ).getStr() );
    }
    fprintf( stderr, "\n%s failed.\n", APP_NAME );
    return 1;
}

