/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: typedetection.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:34:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_
#define __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_

//_______________________________________________
// my own includes

#ifndef __FRAMEWORK_CLASSES_FILTERCACHE_HXX_
#include <classes/filtercache.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XSERVICEINFO_HXX_
#include <macros/xserviceinfo.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_______________________________________________
// interface includes

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_NOSUCHELEMENTEXCEPTION_HPP_
#include <com/sun/star/container/NoSuchElementException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XEXTENDEDFILTERDETECTION_HPP_
#include <com/sun/star/document/XExtendedFilterDetection.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XTYPEDETECTION_HPP_
#include <com/sun/star/document/XTypeDetection.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XFLUSHABLE_HPP_
#include <com/sun/star/util/XFlushable.hpp>
#endif

//_______________________________________________
// other includes

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_H_
#include <cppuhelper/interfacecontainer.h>
#endif

//_______________________________________________
// namespace

namespace framework{

//_______________________________________________
// exported const

//_______________________________________________
// exported definitions

/// @HTML
/** @short  implements flat/deep detection of file/stream formats and provides
            further read/write access to the global office type configuration.

    @descr  Using of this class makes it possible to get information about the
            format type of a given URL or stream. The returned internal type name
            can be used to get more informations about this format. Further this
            class provides full access to the configuration data and following
            implementations will support some special query modes.

    @author     as96863

    @docdate    10.03.2003 by as96863

    @todo       <ul>
                    <li>implementation of query mode</li>
                    <li>simple restore mechanism of last consistent cache state,
                        if flush failed</li>
                </ul>
 */
/// @NOHTML

class TypeDetection :   // interfaces
                        public css::lang::XTypeProvider             ,
						public css::lang::XServiceInfo				,
						public css::document::XTypeDetection		,
                        public css::container::XNameContainer       ,       // => XNameReplace => XNameAccess => XElementAccess
                        public css::util::XFlushable                ,
                        // baseclasses (order important for initialization!)
                        // Struct for right initalization of mutex member! Must be the first one of baseclasses!
                        private ThreadHelpBase                      ,
                        public  ::cppu::OWeakObject
{
    //-------------------------------------------
    // member

    private:

        /** reference to the uno service manager, which created this service.
            It can be used to create own needed helper services. */
        css::uno::Reference< css::lang::XMultiServiceFactory > m_xSMGR;

        /** shared singleton cache, which contains all needed configuration items.
            It's shared between services FilterFactory/TypeDetection/ContentHandlerFactory ...
            and it lives/dies by using a ref count mechanism. So this TypeDetection class
            is an interface wrapper on top of this cache. */
        FilterCache m_aCache;

        /** contains all registered flush listener for this service instance. */
        ::cppu::OMultiTypeInterfaceContainerHelper m_aListenerContainer;

    //-------------------------------------------
    // interface

	public:

        //---------------------------------------
        // XInterface, XTypeProvider, XServiceInfo

        DECLARE_XINTERFACE
        DECLARE_XTYPEPROVIDER
        DECLARE_XSERVICEINFO

        #ifdef ENABLE_AUTODOC_FIX
        ;
        #endif

        //---------------------------------------

        /** @short  initialize new instance of this class.

            @param  xSMGR
                    reference to the global uno service manager, which created this new
                    factory instance. It must be used during runtime to create own
                    needed services.
         */

        TypeDetection( const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR );

        //---------------------------------------

        /** @short  release internal structures.
         */

        virtual ~TypeDetection();

        //---------------------------------------
        // XTypeDetection

        /** @short  search first suitable type for given URL in cache.

            @descr  It will be a flat detection only - means detection based on internal
                    configuration data only. This method return first matching type
                    everytime ... There is no chance to search following type entries!

            @param  sURL
                    URL of the content, which should be detected.

            @return An internal type name if detection was successfully.
                    Ths return value will be empty if the underlying document format
                    is unknown or the given URL seams to be invalid.
         */

        virtual ::rtl::OUString SAL_CALL queryTypeByURL( const ::rtl::OUString& sURL )
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XTypeDetection

        /** @short  search first suitable type for the file described by the given descriptor.

            @descr  It will do a flat and/or deep detection, which can be regulated by the second parameter
                    nDeep. Means detection based on the internal configuration data set and/or
                    looking into the storage will be possible. So the detection rate can be
                    improved against the method queryTypeByURL().
                    On the other side the file content can be described a little bit better.
                    E.g. it would be possible to use an open stream directly for detection
                    instead of the URL.
                    This method return first matching type everytime ...
                    There is no chance to search following type entries!

            @param  lDescriptor
                    describe the content for detection in its details.
                    Note. Because it's an in/out parameter it can be adjusted internaly.
                    So the descriptor will correspond to the return value everytime.

            @param  bDeep
                    enable/disable deep detection mode.

            @return An internal type name if detection was successfully.
                    Ths return value will be empty if the underlying document format
                    is unknown or the given descriptor contains invalid data.
         */

        virtual ::rtl::OUString SAL_CALL queryTypeByDescriptor( css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                                                                sal_Bool                                         bDeep       )
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XNameContainer

        /** @short  add a new entry to this container.

            @descr  This will change all internal structures only!
                    Updating of the configuration layer and notify of all registered
                    listener will be done inside API call XFlushable::flush() on this
                    container.

            @param  sName
                    means the internal name for a new type entry.

            @param  aPropertySet [sequence< com::sun::star::beans::PropertyValue >!]
                    describe this new entry. For a list of all supported properties
                    have a look on method >>getByName()<<.
                    Note: Missing values will be created with defaults!

            @exception  com::sun::star::lang::IllegalArgumentException
                        if one of the incoming parameters seams to be invalid.
                        That doesn't include the check, if this item already exist!

            @exception  com::sun::star::container::ElementExistException
                        if this item already exist inside this container.

            @exception  com::sun::star::lang::WrappedTargetException
                        f creation of the internal structures failed.
         */
        virtual void SAL_CALL insertByName( const ::rtl::OUString& sName        ,
                                            const css::uno::Any&   aPropertySet )
            throw(css::lang::IllegalArgumentException  ,
                  css::container::ElementExistException,
                  css::lang::WrappedTargetException    ,
                  css::uno::RuntimeException           );

        //---------------------------------------
        // XNameContainer

        /** @short  remove an existing entry from this container.

            @descr  This will change all internal structures only!
                    Updating of the configuration layer and notify of all registered
                    listener will be done inside API call XFlushable::flush() on this
                    container.

            @param  sName
                    means the internal name of a type entry.

            @exception  com::sun::star::container::NoSuchElementException
                        if the requested item does not exist inside this container.

            @exception  com::sun::star::lang::WrappedTargetException
                        if creation of the internal structures failed.
         */
        virtual void SAL_CALL removeByName( const ::rtl::OUString& sName )
            throw(css::container::NoSuchElementException,
                  css::lang::WrappedTargetException     ,
                  css::uno::RuntimeException            );

        //---------------------------------------
        // XNameReplace

        /** @short  change an existing entry inside this container.

            @descr  This will change all internal structures only!
                    Updating of the configuration layer and notify of all registered
                    listener will be done inside API call XFlushable::flush() on this
                    container.

            @param  sName
                    means the internal name of a type entry.

            @param  aPropertySet [sequence< com::sun::star::beans::PropertyValue >!]
                    describe the changes on this entry. For a list of all supported properties
                    have a look on method getByName().
                    Note: Missing properties will be untouched.

            @exception  com::sun::star::lang::IllegalArgumentException
                        if one of the incoming parameters seams to be invalid.
                        That doesn't include the check, if this item exist!

            @exception  com::sun::star::container::NoSuchElementException
                        if the requested item does not exist inside this container.

            @exception  com::sun::star::lang::WrappedTargetException
                        if updating of the internal structures failed.
         */
        virtual void SAL_CALL replaceByName( const ::rtl::OUString& sName        ,
                                             const css::uno::Any&   aPropertySet )
            throw(css::lang::IllegalArgumentException   ,
                  css::container::NoSuchElementException,
                  css::lang::WrappedTargetException     ,
                  css::uno::RuntimeException            );

        //---------------------------------------
        // XNameAccess

        /// @HTML
        /** @short  return properties of queried container item.

            @descr  Use this method to get all informations about a type item of this cache.
                    A sequence< com::sun::star::beans::PropertyValue > packed inside an Any will be returned.
                    Following properties are defined:
                    <table border=1>
                    <tr>
                        <td><b>Property</b></td>
                        <td><b>Value<b></td>
                        <td><b>Description<b></td>
                    </tr>
                    <tr>
                        <td>Name</td>
                        <td>[string]</td>
                            <td>the internal name for this type</td>
                    </tr>
                    <tr>
                        <td>Preferred</td>
                        <td>[boolean]</td>
                            <td>mark this type as preferred one, if ambigities exist in type configuration exist</td>
                    </tr>
                    <tr>
                        <td>UIName</td>
                        <td>[string]</td>
                            <td>the localized name for this type corresponding to the current office locale</td>
                    </tr>
                    <tr>
                        <td>UINames</td>
                        <td>[sequence< com::sun::star::beans::PropertyValue >]</td>
                            <td>list of all localized names for this type. The name of such PropertyValue item
                                represent the locale - it's value contains the localized name.</td>
                    </tr>
                    <tr>
                        <td>MediaType</td>
                        <td>[string]</td>
                            <td>contains the mime or content type of this format.</td>
                    </tr>
                    <tr>
                        <td>ClipboardFormat</td>
                        <td>[string]</td>
                            <td>contains special content identifier, which can be searched inside the stream.</td>
                    </tr>
                    <tr>
                        <td>DocumentIconID</td>
                        <td>[integer]</td>
                            <td>assign an icon by using an index into a global icon cache.</td>
                    </tr>
                    <tr>
                        <td>URLPattern</td>
                        <td>[sequence< string >]</td>
                            <td>list of URL pattern, which bind this type to special formated URL's.
                                e.g. "private:factory/*"</td>
                    </tr>
                    <tr>
                        <td>Extensions</td>
                        <td>[sequence< string >]</td>
                            <td>list of URL extensions, which bind this type to special formated URL's.
                                e.g. "html"</td>
                    </tr>
                    </table>

            @param  sName
                    the internal name the requested type.

            @return A property set, which describe this detect service.
                    It uses a sequence< com::sun::star::beans::PropertyValue > internaly.

            @exception  com::sun::star::container::NoSuchElementException
                        if the requested entry does not exist inside this container.
         */
        /// @NOHTML

        virtual css::uno::Any SAL_CALL getByName( const ::rtl::OUString& sName )
            throw(css::container::NoSuchElementException,
                  css::lang::WrappedTargetException     ,
                  css::uno::RuntimeException            );

        //---------------------------------------
        // XNameAccess

        /** @short  return list of all well know container entries available on this container.

            @attention  Because this service implements read/write access to the configuration too,
                        this list is dynamic. Means: in multithreaded environments some items of this
                        return list could be invalid next time!

            @return A list of all well known container items.
         */

        virtual css::uno::Sequence< ::rtl::OUString > SAL_CALL getElementNames()
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XNameAccess

        /** @short  check if searched entry exist inside this container.

            @attention  In multithreaded environments it's not guaranteed, that a
                        queried item exist next time realy! It can be deleted by
                        another thread ...

            @param  sName
                    the name of the queried container entry.

            @return TRUE if the requested item exist; FALSE otherwise.
         */

        virtual sal_Bool SAL_CALL hasByName( const ::rtl::OUString& sName )
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XElementAccess

        /** @short  return the uno type, which is used for all container items.

            @return Type of sequence< com::sun::star::beans::PropertyValue > everytime - because it's fix.
         */

        virtual css::uno::Type SAL_CALL getElementType()
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XElementAccess

        /** @short  return fill state of this cache.

            @return TRUE if any item exist inside this conatiner; FALSE otherwhise.
         */

        virtual sal_Bool SAL_CALL hasElements()
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XFlushable

        /** @short  update the configuration layer and notify all registered listener.

            @descr  All container interface methods update the internal structures of
                    this container only. But the underlying configuration layer and
                    may some possible other caches was not updated.
                    Calling of flush() will do that.
                    At the same time all currently registered flush listener will be informed,
                    so they can update her structures too.
                    Note: Before all these operations are started realy, all changes will be
                    verified and if neccessary some corrections will be done.
                    In case the cache will be invalid and could not be repaired an exception is thrown!
                    Normaly this container will not work correctly afterwards ...

            @exception  com::sun::star::uno::RuntimeException
                        if the changes on this container was invald and could not be repaired.
         */

        virtual void SAL_CALL flush()
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XFlushable

        /** @short  register listener for container updates.

            @param  xListener
                    reference to listener, which wish to be registered.

            @exception  com::sun::star::uno::RuntimeException
                        if the given listener is an invalid reference.
                        Note: multiple calls of this method for the same listener won't be checked!
         */

        virtual void SAL_CALL addFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener )
            throw(css::uno::RuntimeException);

        //---------------------------------------
        // XFlushable

        /** @short  deregister listener for container updates.

            @param  xListener
                    reference to listener, which wish to be deregistered.

            @exception  com::sun::star::uno::RuntimeException
                        if the given listener is an invalid reference.
                        Note: multiple calls of this method for the same listener won't be checked!
         */

        virtual void SAL_CALL removeFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener )
            throw(css::uno::RuntimeException);

    //-------------------------------------------
    // helper

    private:

        /** @short  make a deep type detection and return different states.

            @descr  First it try to use only deep detection services, which are registered
                    for the already flat detected and as parameter given type.
                    If no such type name exist, all well known detect service are used!
                    If detection was successfully the internal type will be returned as
                    an additional out parameter. So the outside code can find out, if deep
                    detection is different from a flat detection.
                    Further the given MediaDescriptor (wrapped by the ArgumentAnalyer argument)
                    is adjusted to represent the content right.
                    Last but not least the return value indicates, if deep detection was made
                    in general. Because; if no detection service could be located or created
                    the flat detection must be enough and loading a document must be tried.
                    In case a deep detection says: "no: this format is unknown!" ... loading of
                    the document must be cancelled!

            @param  sFlatType
                    the flat detected internal type name, whch must be used to search registered
                    detect services. Can be an empty value to use all well known detect services,
                    till a valid result exist!

            @param  rAnalyzer
                    wrapp the MediaDescriptor and can be used directly to adjust it, if the results
                    needs that.

            @param  pDeepType
                    used to return the deep detected internal type name to the calli.
                    It must be a valid pointer - because it won't be checked!

            @return TRUE if any detection service could be located and was used.
                    In this case the value for pDeepType can be an empty one (if the format is
                    unknown) or a valid internal type name (if detection was successfully).
                    FALSE if no detect service was used in general. In such case the values
                    of pDeepType and sFlatType will be the same!
         */

        sal_Bool impl_checkDeepForType( const ::rtl::OUString&  sFlatType ,
                                              ArgumentAnalyzer& rAnalyzer ,
                                              ::rtl::OUString*  pDeepType );

        //---------------------------------------
        // helper

        /** @short  update the given MediaDescriptor.

            @descr  The MediaDescriptor is passed due to many interfaces during loading/detection/saving
                    a document. Every instance of this operation stack can add own or change/remove
                    invalid items of this descriptor. This helper method modify the given descriptor
                    so it will be consistent to the given type. Note: If the type name is empty
                    all corresponding values will be removed from the descriptor.

            @param  sType
                    an internal type name or an empty value.

            @param  pAnalyzer
                    wrapp the MediaDescriptor and provide easy read/write access on it.
         */

        void impl_updateDescriptorForType( const ::rtl::OUString&  sType     ,
                                                 ArgumentAnalyzer* pAnalyzer );

}; // class TypeDetection

} // namespace framework

#endif // #ifndef __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_
