/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mailbook.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:17:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _MAILBOOK_HXX
#define _MAILBOOK_HXX

// include ---------------------------------------------------------------

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

// forward ---------------------------------------------------------------

class MailAddressList;
struct AddressBookImpl;

// enum ------------------------------------------------------------------

enum MailAddressLocation
{
	MAIL_LOCATION_UNKNOWN = 0,
	MAIL_LOCATION_LOCAL,
	MAIL_LOCATION_DIALIN,
	MAIL_LOCATION_POSTOFFICE
};

// structs ---------------------------------------------------------------

struct MailAddress
{
	String				aName;
	String				aAddress;
	String				aComment;
	MailAddressLocation	eLocation;
};

// define ----------------------------------------------------------------

#define DIRECTORY			((USHORT)1)
#define PUBLIC_MAIL_LIST	((USHORT)2)
#define PRIVATE_MAIL_LIST	((USHORT)3)

// class MailAddressBook -------------------------------------------------

class MailAddressBook
{
private:
	AddressBookImpl*	pImpl;

public:
						MailAddressBook();
						MailAddressBook( const MailAddressBook &rBook );
	MailAddressBook&	operator =( const MailAddressBook &rBook );
						~MailAddressBook();

	USHORT				GetAddressCount();
	String				GetName( USHORT nNo );
	String				GetAddress( USHORT nNo );
	MailAddressLocation GetLocation( USHORT nNo );
	void				SetAddressList( const MailAddressList& rList );
};


#endif



















