package org.netbeans.modules.openoffice;


import java.io.File;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintStream;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Manifest;
import java.util.StringTokenizer;
import java.util.Vector;

//import org.apache.regexp.RESyntaxException;

//import org.netbeans.modules.editor.java.JCUpdater;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.DataObjectList;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.REFilter;
import org.netbeans.modules.openoffice.wizard.IDLInterface;
import org.netbeans.modules.openoffice.wizard.OOServiceData;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
//import org.openide.nodes.Node;
import org.openide.NotifyDescriptor;
import org.openide.src.Identifier;
import org.openide.TopManager;

/** The class provides some static methods (among other things creation of Jar
 * contents).
 * @author Bertram Nolte, Michael Bohn
 */
public class OOTools {
//    final static String stringManifestFile = "MANIFEST.TXT";
    
    public static void installFiles( String stringSDKDirectory,
    String stringOfficeDirectory ) {
        
        org.openide.filesystems.FileSystemCapability.Bean aBean =
        new org.openide.filesystems.FileSystemCapability.Bean();
        aBean.setDoc( true );
        aBean.setExecute( false );
        aBean.setCompile( false );
        aBean.setExecute( false );
        
        try {
            Repository repo = TopManager.getDefault().getRepository();
            LocalFileSystem fsl = new LocalFileSystem( aBean );
            
            // Get the file of the documentation directory.
            File fileDocumentation = 
            new File( stringSDKDirectory + System.getProperty(
            "file.separator" ) + "docs" + System.getProperty( "file.separator" )
            + "common" + System.getProperty( "file.separator" ) + "ref" );

            if ( fileDocumentation.exists() ) {
                fsl.setRootDirectory( fileDocumentation );
                if ( repo.findFileSystem( fsl.getSystemName() ) == null ) {
                    fsl.setHidden( true );
                    repo.addFileSystem( fsl );
                }
            }
            
            LocalFileSystem localfilesystem = new LocalFileSystem( aBean );
            
            // Get the file of the helper documentation directory.
            File fileDocumentationHelper = 
            new File( stringSDKDirectory + System.getProperty(
            "file.separator" ) + "docs" + System.getProperty( "file.separator" )
            + "java" + System.getProperty( "file.separator" ) + "ref" );

            if ( fileDocumentationHelper.exists() ) {
                localfilesystem.setRootDirectory( fileDocumentationHelper );
                if ( repo.findFileSystem( 
                localfilesystem.getSystemName() ) == null ) {
                    localfilesystem.setHidden( true );
                    repo.addFileSystem( localfilesystem );
                }
            }
            
            File aFile = new File( stringOfficeDirectory + System.getProperty(
            "file.separator") + "program" + System.getProperty(
            "file.separator") + "classes" );
            String [] aList = aFile.list( new OOExtensionFilter( ".jar" ) );
            
            for(int i = 0; i < aList.length; i++ ) {
                JarFileSystem fs = new JarFileSystem();
                fs.setJarFile( new File( stringOfficeDirectory
                + System.getProperty(
                "file.separator") + "program" + System.getProperty(
                "file.separator" ) +"classes"
                + System.getProperty( "file.separator" ) + aList[ i ] ) );
                
//                System.out.println( stringOfficeDirectory
//                + System.getProperty(
//                "file.separator") + "program" + System.getProperty(
//                "file.separator" ) +"classes"
//                + System.getProperty( "file.separator" ) + aList[ i ] );
                
                // Set hidden state of the JAR filesystem.
                fs.setHidden( true );
                    
                if ( repo.findFileSystem( fs.getSystemName() ) == null ) {
                    repo.addFileSystem( fs );
                }
                
//                FileObject fileobject = repo.findResource( "jurt.jar" );
//                FileObject fileobject = fs.getRoot();
//                
//                if ( fileobject == null ) {
//                    System.out.println( "fileobject is null." );
//                    return;
//                }
//                
//                Node node = DataObject.find( fileobject ).getNodeDelegate();
//                
//                System.out.println( "Node: " + node );
//                
//                org.openide.nodes.Children children = node.getChildren();
//                Enumeration enumerationNodes = children.nodes();
//                while ( enumerationNodes.hasMoreElements() ) {
//                    Node nodeChild = ( Node ) enumerationNodes.nextElement();
//                    System.out.println( "Node: " + nodeChild.toString() );
//                }
//                
//                org.openide.util.actions.SystemAction[] systemactions = node.getActions();
//                
//                for ( int intIndex = 0; intIndex < systemactions.length; intIndex++  ) {
//                    System.out.println( systemactions[ intIndex ] );
//                }
//                
//                System.out.println( "3" );
//                JCUpdater jcupdater = new JCUpdater();
//                System.out.println( "4" );
//                jcupdater.run();
//                System.out.println( "5" );
//                jcupdater.processNode( node, null );
//                System.out.println( "6" );
//                jcupdater.run();
            }
        }
        catch( Exception e ) {
            e.printStackTrace( System.out );
        }
        
        // Get the user directory from the environment variable.
        String stringUserDirectory = System.getProperty( "netbeans.user" );
    }
    
    public static void uninstallFiles( String stringSDKDirectory,
    String stringOfficeDirectory ) {
        
        try {
            Repository repo=TopManager.getDefault().getRepository();
            LocalFileSystem fsl=new LocalFileSystem();
            fsl.setRootDirectory( new File( stringSDKDirectory
            + System.getProperty("file.separator") + "docs"
            + System.getProperty("file.separator") +"common"
            + System.getProperty("file.separator") +"ref"));
            if (repo.findFileSystem(fsl.getSystemName()) != null) {
                repo.removeFileSystem(repo.findFileSystem(fsl.getSystemName()));
            }
            
            File aFile = new File( stringOfficeDirectory + System.getProperty(
            "file.separator" ) + "program" + System.getProperty(
            "file.separator" ) + "classes" );
            String [] aList = aFile.list( new OOExtensionFilter( ".jar" ) );
            
            for( int i = 0; i < aList.length; i++ ) {
                JarFileSystem fs = new JarFileSystem();
                fs.setJarFile( new File( stringOfficeDirectory
                + System.getProperty( "file.separator" ) + "program"
                + System.getProperty( "file.separator" ) + "classes"
                + System.getProperty( "file.separator" ) + aList[ i ] ) );
                if ( repo.findFileSystem( fs.getSystemName() ) != null ) {
                    repo.removeFileSystem( repo.findFileSystem(
                    fs.getSystemName() ) );
                }
            }
        }
        catch(Exception e){
            e.printStackTrace(System.out);
        }
    }
    
    public static String replaceSubStrings(String Source,String remove, String replace)
    {  String helpstring = "";
       StringTokenizer st = new StringTokenizer(Source,remove);
       while (st.hasMoreTokens()) {
           helpstring = helpstring + st.nextToken();
           if (st.hasMoreTokens()) {helpstring = helpstring + replace;}
       }
       return helpstring;
    }
    
    /** Creates a manifest with the registration class name.
     * @param stringDirectory Output directory.
     * @param stringRegistrationClassName Service name.
     */
    public final static void writeManifest( String stringDirectory,
    String stringRegistrationClassName) {
        PrintStream printstream = null;
        
        try {
            // There is exactly one manifest file in the archive, with pathname
            // META-INF/MANIFEST.MF
            printstream = new PrintStream(
            new FileOutputStream(
            ( stringDirectory.equals( "." ) ) ? ( "" ) : ( stringDirectory )
            //            + File.separator + "META-INF"
            + File.separator + "MANIFEST_" + stringRegistrationClassName
            + ".TXT",
//            + File.separator + stringManifestFile,
            false));
        }
        catch( FileNotFoundException filenotfoundexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            filenotfoundexception.toString() ) );
        }
        
        // A preliminary section appears at the top of the file containing,
        // at minimum, this standard's version number.
        printstream.println( "Manifest-Version: 1.0" );
        
        printstream.println( "RegistrationClassName: "
        + stringRegistrationClassName );
        printstream.close();
    }
    
    
    /** Creates a Basic file, which contains code for registering a component
     * and showing all properties, methods, and interfaces of the component.
     * @param stringDirectory Output directory.
     * @param stringFullServiceName Fully qualified service name.
     */
    public final static void writeBasicCode( String stringDirectory,
    String stringFullServiceName, String stringComponentName ) {
        PrintStream printstream = null;
        try {
            printstream = new PrintStream( new FileOutputStream(
            stringDirectory + File.separator + "register_"
            + stringComponentName + ".bas", false ) );
        }
        catch( FileNotFoundException filenotfoundexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            filenotfoundexception.toString() ) );
        }
        
        printstream.println( "REM Please notice: before running this function, "
        + "you have to merge the" );
        
        printstream.println( "REM generated registry (e.g. types.rdb) to your "
        + "favorite registry," );
        
        printstream.println( "REM for example "
        + "<OFFICE_PROGRAMM_PATH>/applicat.rdb ." );
        
        printstream.println();
        
        printstream.println( "REM You have to customize and execute the "
        + "following command lines: " );

        if ( getODKSystemDirectory().toLowerCase().equals( "windows" ) ) {
            printstream.println( "REM LIB=%LIB%;" 
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory() 
            + "\\program" );
        }
        else {
            printstream.println( "REM LD_LIBRARY_PATH=$LD_LIBRARY_PATH:" 
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory() 
            + "/program" );
        }
        
        printstream.println( "REM " 
        + OOIDLGlobalSettings.getDefault().getSDKDirectory() 
        + System.getProperty( "file.separator" ) 
        + getODKSystemDirectory() 
        + System.getProperty( "file.separator" ) 
        + "bin"
        + System.getProperty( "file.separator" ) 
        + "regmerge " + OOIDLGlobalSettings.getDefault().getOfficeDirectory() 
        + System.getProperty( "file.separator" ) 
        + "program"
        + System.getProperty( "file.separator" ) 
        + "applicat.rdb / " 
        + stringComponentName + ".rdb" );
        
        printstream.println( "Sub InsertServiceImplementation" );
        
        printstream.println();
        
        printstream.println( "  REM Get the service ImplementationRegistration."
        + " This service allows the" );
        
        printstream.println( "  REM installation or deinstallation of "
        + "implementations." );
        
        printstream.println( "  implementationRegistration = createUnoService("
        + "\"com.sun.star.registry.ImplementationRegistration\")" );
        
        printstream.println();
        
        printstream.println( "  REM Please notice that you have to change "
        + "the path and the file name" );
        
        printstream.println( "  REM in the next line, so that it fits to your "
        + "needs." );
        
        printstream.println( "  stringJarFileURL = "
        + "\"file://"
        + ( ( stringDirectory.charAt( 0 ) == '/' ) ? ( "" ) : ( "/" ) )
        + stringDirectory + File.separator
        + stringComponentName + ".jar\"" );
        
        printstream.println();
        
        printstream.println( "  REM Register one or more implementations. The "
        + "location of the" );
        
        printstream.println( "  REM implementation is specified with the "
        + "URL." );
        
        printstream.println( "  implementationRegistration.register"
        + "Implementation("
        + "\"com.sun.star.loader.Java2\", stringJarFileURL, null )" );
        
        printstream.println();
        
        printstream.println( "  REM Create your new service." );
        
        printstream.println( "  object = createUnoService( "
        + stringFullServiceName + " )" );
        
        printstream.println();
        
        printstream.println( "  REM Show all implemented interfaces, "
        + "properties, and methods of your service." );
        
        printstream.println( "  msgbox( object.dbg_supportedInterfaces )" );
        
        printstream.println( "  msgbox( object.dbg_Properties )" );
        
        printstream.println( "  msgbox( object.dbg_Methods )" );
        
        printstream.println();
        
        printstream.println( "End Sub" );
        
        printstream.close();
    }
    
    // added on Sunday the 07/04/2002
    public final static String getODKSystemDirectory() {
        if (System.getProperty("os.name").indexOf("Windows") != -1)
        { return "Windows";}
        else if (System.getProperty("os.name").indexOf("Linux") != -1)
        {return "linux";}
        else if (System.getProperty("os.name").indexOf("SunOS") != -1)
        { if (System.getProperty("os.arch").indexOf("sparc") != -1)
          {return "solsparc";}
          else {return "solia";}
        }
        return "";
    }
    
    public final static String getFilesystemName(File aFile) {
        Repository Repository = TopManager.getDefault().getRepository();
        Enumeration eFilesystems = Repository.getFileSystems();
        while (eFilesystems.hasMoreElements())
        { FileSystem aFileSystem = (FileSystem) eFilesystems.nextElement();
          
          if (aFile.getPath().indexOf(aFileSystem.getDisplayName()) != -1) {
              return aFileSystem.getDisplayName();
          }
        }
        return "";
    }
    public final static String getTargetElementName(File aFile) {
        String aDir = OOTools.getFilesystemName(aFile);
        String aPath = aFile.getPath();
        String aName = aPath.substring(aDir.length()+ 1,aPath.length()-4);
        
//        TopManager.getDefault().notify(new NotifyDescriptor.Message(aName));
        return OOTools.replaceSubStrings(aName,System.getProperty("file.separator"),".");
        
    }
    // end addition
    
    /** Creates the Jar content in the output directory.
     * @param ooservicedata Provides the classes and IDL interfaces.
     * @param stringSystemDirectory Output directory.
     */
    public final static void createJarContent( OOServiceData ooservicedata,
    String stringSystemDirectory, FileSystem filesystemOutput ) {
        // Get the default repository.
        Repository repository = TopManager.getDefault().getRepository();
        
        // Get file object of the service implementation.
        FileObject fileobject = filesystemOutput.find(
        ooservicedata.getPackage(),
//        ooservicedata.getOuterClass().getName().getQualifier(),
        ooservicedata.getOuterClass().getName().getName(),
        "java" );
        
        // Could the service implementation not be found?
        if ( fileobject == null ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            "Error: No file found. Package:" +
//            ooservicedata.getOuterClass().getName().getQualifier()
            ooservicedata.getPackage()
            + ", Name:"
            + ooservicedata.getOuterClass().getName().getName() ) );
            
            // Exit the method.
            return;
        }
        
        // Create an empty data object.
        DataObject dataobject = null;
        
        try {
            // Find the data object of the file object.
            dataobject = DataObject.find( fileobject );
        }
        catch( DataObjectNotFoundException dataobjectnotfoundexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            dataobjectnotfoundexception.toString() ) );
        }
        
        // Create an empty content member list for the jar content.
        ContentMemberList contentmemberlist = new ContentMemberList();
        
        
        
        
        //        // Get file object of the service implementation.
        //        FileObject fileobjectManifest = repository.find(
        //        ooservicedata.getOuterClass().getName().getQualifier(),
        //        "manifest",
        //        "mf" );
        //
        //        // Could the service implementation not be found?
        //        if ( fileobjectManifest == null ) {
        //            // Show message.
        //            TopManager.getDefault().notify(
        //            new NotifyDescriptor.Message(
        //            "Error: No file found. Package:" +
        //            ooservicedata.getOuterClass().getName().getQualifier()
        //            + ", Name:"
        //            + "manifest.mf" ) );
        //
        //            // Exit the method.
        //            return;
        //        }
        //
        //        // Create an empty data object.
        //        DataObject dataobjectManifest = null;
        //
        //        try {
        //            // Find the data object of the file object.
        //            dataobjectManifest = DataObject.find( fileobjectManifest );
        //        }
        //        catch( DataObjectNotFoundException dataobjectnotfoundexception ) {
        //            dataobjectnotfoundexception.printStackTrace();
        //        }
        //
        //        // Add the data object of the service implementation to the list.
        //        contentmemberlist.addMember( dataobjectManifest );
        
        
        // Create an empty manifest object.
        Manifest manifest = null;
        
        try {
            // Create the manifest with a given system file.
            //            TopManager.getDefault().notify(
            //            new NotifyDescriptor.Message(
            //            stringSystemDirectory
            ////            + File.separator + "META-INF"
            //            + File.separator + stringManifestFile ) );
            
            manifest = new Manifest( new FileInputStream(
            stringSystemDirectory
            //            + File.separator + "META-INF"
            + File.separator + "MANIFEST_" + ooservicedata.getClassName()
            + ".TXT" ) );
            
            //            Iterator iterator =
            //            manifest.getMainAttributes().values().iterator();
            //
            //            for ( int intIndexAttributes = 0;
            //            iterator.hasNext();
            //            intIndexAttributes++ ) {
            //                TopManager.getDefault().notify(
            //                new NotifyDescriptor.Message(
            //                "Attribute: " + iterator.next().toString() + "\n" ) );
            //            }
            
        }
        catch( FileNotFoundException filenotfoundexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            filenotfoundexception.toString() ) );
        }
        catch( IOException ioexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            ioexception.toString() ) );
        }
        
        // Get the vector containing the interfaces.
        Vector vectorInterfaces = ooservicedata.getIDLInterfaces();
        
        // Add all Java interfaces to the content list.
        for ( int intIndexInterfaces = 0;
        intIndexInterfaces < vectorInterfaces.size();
        intIndexInterfaces++ ) {
            // Get the interface.
            IDLInterface idlinterface = ( IDLInterface )
            vectorInterfaces.elementAt( intIndexInterfaces );
            
            // Get the interface name.
            String stringInterfaceName =
            idlinterface.getIdentifierName().getName();
            
            // Get the package.
            String stringPackage =
            idlinterface.getIdentifierName().getQualifier();
            
//            // Get index of first package separator.
//            int intIndexFirstPackageSeparator = stringPackage.indexOf( '.' );
//            
//            // Declare root package string.
//            String stringRootPackage = null;
//            
//            // Get root package.
//            if ( intIndexFirstPackageSeparator != -1 ) {
//                stringRootPackage = stringPackage.substring( 0,
//                intIndexFirstPackageSeparator );
//            }
//            else {
//                stringRootPackage = stringPackage;
//            }
////            String stringRootPackage = stringPackage.substring( 0,
////            intIndexFirstPackageSeparator );
            
            // Create an empty file object.
            FileObject fileobjectIDL = null;
            
            // Get directory.
//            fileobjectIDL = filesystemOutput.find( stringRootPackage, null, null );
            fileobjectIDL = filesystemOutput.find( stringPackage,
            stringInterfaceName, "idl" );
            
            //            // Get file object of the service implementation.
            //            fileobjectIDL = repository.find( stringPackage,
            //            stringInterfaceName, "java" );
            
            // Could the file object not be found?
            if ( fileobjectIDL == null ) {
                // Show message.
                TopManager.getDefault().notify(
                new NotifyDescriptor.Message(
//                "Error: No package found. Package:" + stringRootPackage ) );
                "Error: No file found. Package:" + stringPackage + ", Name:"
                + stringInterfaceName ) );
                
                continue;
            }
            
            // Create an empty data object.
            DataObject dataobjectIDL = null;
            
            try {
                // Find the data object of the file object.
                dataobjectIDL = DataObject.find( fileobjectIDL );
            }
            catch( DataObjectNotFoundException dataobjectnotfoundexception ) {
                // Show message.
                TopManager.getDefault().notify(
                new NotifyDescriptor.Message(
                dataobjectnotfoundexception.toString() ) );
            }
            
            // Add the data object of the service implementation to the list.
            contentmemberlist.addMember( dataobjectIDL );
        }
        
        // Add the data object of the service implementation to the list.
        contentmemberlist.addMember( dataobject );
        
        // Create an empty file output stream.
        FileOutputStream fileoutputstream = null;
        
        try {
            // Create a file output stream for the jar content.
            fileoutputstream =
            new FileOutputStream(
            stringSystemDirectory + File.separator
            + ooservicedata.getOuterClass().getName().getName()
            + ".jarContent" );
        }
        catch( FileNotFoundException filenotfoundexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            filenotfoundexception.toString() ) );
        }
        
        // Crete an empty object output stream.
        ObjectOutputStream objectoutputstream = null;
        
        // Create an empty jar content.
        JarContent jarcontent =
        new JarContent();
        
//        // Create an empty filter.
//        REFilter refilter = null;
//
//        try {
//            // Create a new regular expression filter.
//            refilter =
//            new REFilter( "(\\.idl$)|(\\.urd$)|(\\.java$)|(\\.jar$)" );
//        }
//        catch( Exception exception ) {
//            // Show message.
//            TopManager.getDefault().notify(
//            new NotifyDescriptor.Message(
//            exception.toString() ) );
//        }
//
//        // Sets type of how regular expression should be treated.
//        refilter.setNegative( true );
//
//        // Set filter.
//        jarcontent.setFilter( refilter );
        
        // Set current list of contents of the jar.
        jarcontent.setContentList( contentmemberlist );
        
        // Set the manifest for the jar content.
        jarcontent.setManifest( manifest );
        
        // Set the manifest.
        //        jarcontent.restoreManifest(
        //        "RegistrationClassName: "
        //        + ooservicedata.getOuterClass().getName().getName() );
        
        // Save the manifest.
        //        jarcontent.saveManifest();
        
        try {
            // Create a file output stream for the jar content.
            objectoutputstream =
            new ObjectOutputStream( fileoutputstream );
            
            // Write the content to a system file.
            jarcontent.writeContent( ( ObjectOutput ) objectoutputstream );
        }
        catch( IOException ioexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            ioexception.toString() ) );
        }
    }
    
    /** Create a ANT file for building the component.
     * @return true if the ANT build file could be written, otherwise false.
     */
    public static final boolean writeANTFile( OOServiceData ooservicedata,
    String stringSystemDirectory ) {
        // File successfully written?
        boolean booleanIsWritten = false;
        
        PrintStream printstream = null;
        try {
            printstream = new PrintStream( new FileOutputStream(
            stringSystemDirectory + File.separator
            + "Build_" + ooservicedata.getClassName() + ".xml", false ) );
        }
        catch( FileNotFoundException filenotfoundexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            filenotfoundexception.toString() ) );
        }
        
        // Create an empty data output stream.
//        DataOutputStream dataoutputstreamBuild = null;
        
        // Show message.
        //        TopManager.getDefault().notify(
        //        new NotifyDescriptor.Message(
        //        stringSystemDirectory + File.separator
        //        + "Build_" + ooservicedata.getClassName() + ".xml" ) );
        
//        try {
//            // Get data output stream.
//            dataoutputstreamBuild = new DataOutputStream(
//            new BufferedOutputStream(
//            new FileOutputStream( stringSystemDirectory + File.separator
//            + "Build_" + ooservicedata.getClassName() + ".xml" )));
//        }
//        catch( FileNotFoundException filenotfoundexception ) {
//            // Show message.
//            TopManager.getDefault().notify(
//            new NotifyDescriptor.Message(
//            filenotfoundexception.toString() ) );
//        }
        
        // Create an empty string for the properties.
        String stringPropertiesBuildFile = "";
        
        // Add XML version and project header.
        stringPropertiesBuildFile +=
        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
        + "<project basedir=\""
        + stringSystemDirectory
        + "\" default=\"createJavaArchive\" name=\"Build\">\n\n";
        
        // Add information for the ODK path.
        stringPropertiesBuildFile += "    <property name=\"ODKPath\" value=\""
        + OOIDLGlobalSettings.getDefault().getSDKDirectory()
        + "\"/>\n";
        
        // Add information for the ODK path.
        stringPropertiesBuildFile += "    <property name=\"OfficePath\" value=\""
        + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
        + "\"/>\n";
        
        // Add information for the output directory.
        stringPropertiesBuildFile +=
        "    <property name=\"OutputDirectory\" value=\""
        + stringSystemDirectory
        + "\"/>\n";
        
        // Add information for the component name.
        //        String stringServiceNameFullyQualified =
        //        ooservicedata.getServiceName();
        //        int intIndexLastDot =
        //        stringServiceNameFullyQualified.lastIndexOf( "." );
        //        String stringServiceName = "";
        //        if ( intIndexLastDot != -1 ) {
        //            stringServiceName = stringServiceNameFullyQualified.substring( intIndexLastDot );
        //        }
        //        else {
        //            stringServiceName = stringServiceNameFullyQualified;
        //        }
        stringPropertiesBuildFile +=
        "    <property name=\"ComponentName\" value=\""
        + ooservicedata.getClassName() + "\"/>\n";
        
        Vector vectorInterfaces = ooservicedata.getIDLInterfaces();
        
        String stringIDLFiles = "";
        String stringURDFiles = "";
        
        // Create an empty string of interface types.
        String stringInterfaceTypes = "";
        
        for ( int intIndexInterfaces = 0;
        intIndexInterfaces < vectorInterfaces.size();
        intIndexInterfaces++ ) {
            IDLInterface idlinterface =
            ( IDLInterface ) vectorInterfaces.elementAt( intIndexInterfaces );
            
            String stringIDLFullName =
            idlinterface.getIDLName().getFullName().replace( '.', '/' );
            
            String stringIDLName =
            idlinterface.getIDLName().getName();
            
            stringIDLFiles += "${OutputDirectory}/" + stringIDLFullName + ".idl ";
            stringURDFiles += "${OutputDirectory}/" + stringIDLName + ".urd ";
            
            // Get the full interface name.
            String stringFullName = idlinterface.getIDLName().getFullName();
            
            // Show message.
            //            TopManager.getDefault().notify(
            //            new NotifyDescriptor.Message(
            //            stringFullName ) );
            
            // Append full interface name to the types string.
            if ( stringInterfaceTypes.equals( "" ) ) {
                stringInterfaceTypes += stringFullName;
            }
            else {
                stringInterfaceTypes += ( ";" + stringFullName );
            }
        }
        
        // Add information for the IDL files.
        stringPropertiesBuildFile += "    <property name=\"IDLFiles\" value=\""
        + stringIDLFiles + "\"/>\n";
        
        // Add information for the URD files.
        stringPropertiesBuildFile += "    <property name=\"URDFiles\" value=\""
        + stringURDFiles + "\"/>\n";
        
        // Add information for the types.
        stringPropertiesBuildFile +=
        "    <property name=\"Types\" value=\"" + stringInterfaceTypes
        + "\"/>\n";
        
        // Get the name of the operation system.
        String stringOperationSystem =
        getODKSystemDirectory();
        //        System.getProperty( "os.name" ).toLowerCase();
        //
        //        // Get the operating system name.
        //        if ( stringOperationSystem.startsWith( "windows" ) ) {
        //            stringOperationSystem = "windows";
        //        }
        //        else if ( stringOperationSystem.startsWith( "sunos" )
        //        || stringOperationSystem.startsWith( "solaris" ) ) {
        //            stringOperationSystem = "solaris";
        //        }
        //        else if ( stringOperationSystem.startsWith( "linux" ) ) {
        //            stringOperationSystem = "linux";
        //        }
        //        else {
        //            // Show message.
        //            TopManager.getDefault().notify(
        //            new NotifyDescriptor.Message(
        //            "Error: Operating system \"" + stringOperationSystem
        //            + "\" is not supported." ) );
        //        }
        
        // Add information for the operating system.
        stringPropertiesBuildFile +=
        "    <property name=\"OperatingSystem\" value=\""
        + stringOperationSystem + "\"/>\n";
        
        // Add information for the applicat registry.
        stringPropertiesBuildFile +=
        "    <property name=\"ApplicatRegistry\" value=\"${OfficePath}"
        + "/program/applicat.rdb\"/>\n";
        
        // Add information for the manifest.
        stringPropertiesBuildFile +=
        "    <property name=\"Manifest\" value=\"${OutputDirectory}/"
        + "MANIFEST_" + ooservicedata.getClassName()
            + ".TXT" + "\"/>\n\n";
        
//        try {
        // Write properties to file.
        printstream.println( stringPropertiesBuildFile );
//            dataoutputstreamBuild.writeChars( stringPropertiesBuildFile );
//            dataoutputstreamBuild.writeUTF( stringPropertiesBuildFile );
            
        // Write static string to file.
        printstream.println( stringEndBuildFile );
//            dataoutputstreamBuild.writeChars( stringEndBuildFile );
//            dataoutputstreamBuild.writeUTF( stringEndBuildFile );
            
        // Close the file.
        printstream.close();
//            dataoutputstreamBuild.close();
            
        // File is written successfully.
        booleanIsWritten = true;
//        }
//        catch( IOException ioexception ) {
//            // Show message.
//            TopManager.getDefault().notify(
//            new NotifyDescriptor.Message(
//            ioexception.toString() ) );
//        }
        
        return booleanIsWritten;
    }
    
    static String stringEndBuildFile =
    "    <target name=\"compileIDL\">\n"
    + "        <exec dir=\"${OfficePath}/program\" failonerror=\"true\" executable=\"${ODKPath}/${OperatingSystem}/bin/idlc\">\n"
    + "            <arg line=\"-I${ODKPath}/idl -O${OutputDirectory} ${IDLFiles}\"/>\n"
//    + "            <env key=\"LD_LIBRARY_PATH\" path=\"${OfficePath}/program\"/>\n"
    + "        </exec>\n"
    + "    </target>\n\n"
    
    + "    <target name=\"mergeTypes\" depends=\"compileIDL\">\n"
    + "        <exec dir=\"${OfficePath}/program\" failonerror=\"true\" executable=\"${ODKPath}/${OperatingSystem}/bin/regmerge\">\n"
    + "            <arg line=\"${OutputDirectory}/${ComponentName}.rdb /UCR ${URDFiles}\"/>\n"
//    + "            <env key=\"LD_LIBRARY_PATH\" path=\"${OfficePath}/program\"/>\n"
    + "        </exec>\n"
    + "    </target>\n\n"
    
    + "    <target name=\"generateJava\" depends=\"mergeTypes\">\n"
    + "        <exec dir=\"${OfficePath}/program\" failonerror=\"true\" executable=\"${ODKPath}/${OperatingSystem}/bin/javamaker\">\n"
    + "            <arg line=\"-nD -T${Types} -BUCR -O${OutputDirectory} ${OutputDirectory}/${ComponentName}.rdb ${ApplicatRegistry}\"/>\n"
//    + "            <env key=\"LD_LIBRARY_PATH\" path=\"${OfficePath}/program\"/>\n"
    + "        </exec>\n"
    + "    </target>\n\n"
    
    + "    <target name=\"compileJava\" depends=\"generateJava\">\n"
    + "        <javac debug=\"true\" failonerror=\"true\" deprecation=\"true\" destdir=\"${OutputDirectory}\" srcdir=\"${OutputDirectory}\">\n"
    + "        <classpath>\n"
    + "            <pathelement path=\"${classpath}\"/>\n"
    + "            <fileset dir=\"${OfficePath}/program/classes\">\n"
    + "                <include name=\"**/*.jar\"/>\n"
    + "            </fileset>\n"
    + "        </classpath>\n"
    + "        </javac>\n"
    + "    </target>\n\n"
    
    + "    <target name=\"createJavaArchive\" depends=\"compileJava\">\n"
    + "        <jar basedir=\"${OutputDirectory}\" jarfile=\"${ComponentName}.jar\" manifest=\"${Manifest}\">\n"
    + "            <include name=\"**/*.class\"/>\n"
    + "        </jar>\n"
    + "    </target>\n\n"

    + "    <target name=\"deployComponent\" depends=\"createJavaArchive\">\n"
    + "        <zip zipfile=\"${ComponentName}.zip\">\n"
    + "            <fileset dir=\".\" includes=\"${ComponentName}.jar\"/>\n"
    + "            <fileset dir=\".\" includes=\"${ComponentName}.rdb\"/>\n"
    + "        </zip>\n"
//        <!--
//        <mkdir dir="${OfficePath}/user/uno_packages"/>
//                
//        <move file="${ComponentName}.zip" todir="${OfficePath}/user/uno_packages"/>
//        -->
    + "        <exec dir=\"${OfficePath}/program\" failonerror=\"true\" executable=\"${OfficePath}/program/pkgchk\">\n"
    + "            <arg line=\"file:///${OutputDirectory}/${ComponentName}.zip\"/>\n"
//    + "            <env key=\"LD_LIBRARY_PATH\" path=\"${OfficePath}/program\"/>\n"
    + "        </exec>\n"
    + "    </target>\n\n"

    + "    <target name=\"cleanComponent\">\n"
    + "        <delete>\n"
    + "            <fileset dir=\"${OutputDirectory}\" includes=\"*.urd\"/>\n"
    + "            <fileset dir=\"${OutputDirectory}\" includes=\"**/*.class\"/>\n"
    + "        </delete>\n"
    + "        <delete file=\"${OutputDirectory}/${ComponentName}.jar\"/>\n"
    + "        <delete file=\"${OutputDirectory}/${ComponentName}.rdb\"/>\n"
    + "        <delete file=\"${OutputDirectory}/${ComponentName}.zip\"/>\n"
    + "    </target>\n\n"
    
    + "</project>\n";
    
}
