

package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.ConstantsCreator;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateConstantsAction extends NodeAction implements Create
{

    public CreateConstantsAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((ConstantsCreator)anode[0].getCookie(ConstantsCreator.class)).createConstants();
    }

    protected boolean enable(Node anode[])
    {
        return anode.length == 1 && anode[0].getCookie(ConstantsCreator.class) != null;
    }

    public String getName()
    {
        return "Create Constants";
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_Constants");
    }

    protected String iconResource()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateConstants");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

        
}
