
package org.netbeans.modules.openoffice.wizard.nodes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.netbeans.modules.openoffice.wizard.actions.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.wizard.util.UnionDefaultCreator;
import org.netbeans.modules.openoffice.wizard.util.UnionMemberCreator;
import org.openide.TopManager;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;
import org.openide.DialogDescriptor;
import java.util.Vector;


public class UnionNode extends MovableNode
    implements org.openide.nodes.Node.Cookie, UnionMemberCreator, UnionDefaultCreator
{

    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/union";
    boolean canAdd;
        
    public UnionNode(NameKey namedkey)
    {
        super(namedkey);
        canAdd = true;
        getCookieSet().add(this);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/union");
    }

    public SystemAction[] createActions()
    {
        return (new SystemAction[] {
            SystemAction.get(CreateUnionMemberAction.class), 
            SystemAction.get(CreateUnionDefaultAction.class),
            SystemAction.get(DestroyAction.class),
            SystemAction.get(EditAction.class)
        });
    }

    public String generateSelf(int i)
    {
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
            s1 = s1 + "    ";

        s = s1 + "union " + getName() + " switch (" + ((AliasKey)key).getType() + ") {\n";
        Node anode[] = getChildren().getNodes();
        for(int k = 0; k < anode.length; k++)
            s = s + ((BaseNode)anode[k]).generateSelf(i + 1);

        s = s + s1 + "};\n";
        return s;
    }

    public void createUnionMember()
    {
        TopManager topmanager = TopManager.getDefault();
        final UnionMemberPanel unionmemberpanel = new UnionMemberPanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(unionmemberpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateMember"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = unionmemberpanel.getName();
                        String s1 = unionmemberpanel.getType();
                        String s3 = unionmemberpanel.getLabel();
                        UnionMemberKey unionmemberkey = new UnionMemberKey(11, s, s1, s3);
                        IDLBaseChildren mutablechildren = (IDLBaseChildren)getChildren();
                        int i = mutablechildren.getKeysCount();
                        if(i > 0)
                             {
                               BaseKey mutablekey = mutablechildren.getKey(i - 1);
                               if((mutablekey instanceof BaseKey) && ((UnionMemberKey)mutablekey).isDefaultValue()) i--;
                             }
                     mutablechildren.addKey(i, unionmemberkey);   
                   }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });              
        
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
    }

    public void createUnionDefault()
    {
        TopManager topmanager = TopManager.getDefault();
        AliasPanel aliaspanel = new AliasPanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(aliaspanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateUnionDefault"));
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        String s = aliaspanel.getName();
        String s1 = aliaspanel.getType();
        UnionMemberKey unionmemberkey = new UnionMemberKey(11, s, s1, null);
        ((IDLBaseChildren)getChildren()).addKey(unionmemberkey);
        canAdd = false;
 }

    public boolean canAdd()
    {
        return canAdd;
    }

    public BasePanel getEditPanel()
    {
        UnionPanel unionpanel = new UnionPanel();
        unionpanel.setName(getName());
        unionpanel.setType(((AliasKey)key).getType());
        return unionpanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof UnionPanel)
        {
            UnionPanel unionpanel = (UnionPanel)BasePanel;
            String s = unionpanel.getName();
            String s1 = unionpanel.getType();
            AliasKey aliaskey = (AliasKey)key;
            if(!aliaskey.getName().equals(s))
            {
                setName(s);
                aliaskey.setName(s);
            }
            if(!aliaskey.getType().equals(s1))
                aliaskey.setType(s1);
        }
    }

    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
      
}
