/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: rtfimp.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:45:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

#ifndef PCH
#include "global.hxx"
#include "document.hxx"
#include "filter.hxx"
#endif

#ifndef SC_EDITUTIL_HXX
#include "editutil.hxx"
#endif
#include "rtfimp.hxx"
#include "rtfparse.hxx"


FltError ScImportRTF( SvStream &rStream, const String& rBaseURL, ScDocument *pDoc, ScRange& rRange )
{
	ScRTFImport aImp( pDoc, rRange );
    FltError nErr = (FltError) aImp.Read( rStream, rBaseURL );
	ScRange aR = aImp.GetRange();
	rRange.aEnd = aR.aEnd;
	aImp.WriteToDocument();
	return nErr;
}


ScRTFImport::ScRTFImport( ScDocument* pDocP, const ScRange& rRange ) :
	ScEEImport( pDocP, rRange )
{
	pParser = new ScRTFParser( pEngine );
}


ScRTFImport::~ScRTFImport()
{
	// Reihenfolge wichtig, sonst knallt's irgendwann irgendwo in irgendeinem Dtor!
	// Ist gewaehrleistet, da ScEEImport Basisklasse ist
	delete (ScRTFParser*) pParser;		// vor EditEngine!
}



