/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tptable.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 22:22:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#undef SC_DLLIMPLEMENTATION

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"

#include "tptable.hxx"
#include "global.hxx"
#include "attrib.hxx"
#include "scresid.hxx"
#include "sc.hrc"
#include "pagedlg.hrc"

// =======================================================================

void EmptyNumericField::Modify()
{
    if( GetText().Len() )
        NumericField::Modify();
    else
        SetEmptyFieldValue();
}

void EmptyNumericField::SetValue( long nValue )
{
    if( nValue == 0 )
        SetEmptyFieldValue();
    else
        NumericField::SetValue( nValue );
}

long EmptyNumericField::GetValue() const
{
    return IsEmptyFieldValue() ? 0 : NumericField::GetValue();
}

// =======================================================================

// STATIC DATA -----------------------------------------------------------

static USHORT pPageTableRanges[] =
{
	ATTR_PAGE_NOTES, ATTR_PAGE_FIRSTPAGENO,
	0
};

BOOL lcl_PutVObjModeItem( USHORT			nWhich,
						  SfxItemSet&		rCoreSet,
						  const SfxItemSet&	rOldSet,
						  const CheckBox&	rBtn );

BOOL lcl_PutScaleItem( USHORT				nWhich,
					   SfxItemSet&			rCoreSet,
					   const SfxItemSet&	rOldSet,
                       const ListBox&       rListBox,
                       USHORT               nLBEntry,
                       const SpinField&     rEd,
                       UINT16               nValue );

BOOL lcl_PutScaleItem2( USHORT               nWhich,
                       SfxItemSet&          rCoreSet,
                       const SfxItemSet&    rOldSet,
                       const ListBox&       rListBox,
                       USHORT               nLBEntry,
                       const NumericField&  rEd1,
                       const NumericField&  rEd2 );

BOOL lcl_PutBoolItem( USHORT			nWhich,
					  SfxItemSet&		rCoreSet,
					  const SfxItemSet&	rOldSet,
					  BOOL				bIsChecked,
					  BOOL				bSavedValue );

//------------------------------------------------------------------------

#define PAGENO_HDL 			LINK(this,ScTablePage,PageNoHdl)
#define PAGEDIR_HDL 		LINK(this,ScTablePage,PageDirHdl)
#define SCALE_HDL			LINK(this,ScTablePage,ScaleHdl)

#define WAS_DEFAULT(w,s)    (SFX_ITEM_DEFAULT==(s).GetItemState((w),TRUE))
#define GET_BOOL(sid,set)	((const SfxBoolItem&)((set).Get(GetWhich((sid))))).GetValue()
#define GET_USHORT(sid,set)	(USHORT)((const SfxUInt16Item&)((set).Get(GetWhich((sid))))).GetValue()
#define GET_SHOW(sid,set) 	( ScVObjMode( ((const ScViewObjectModeItem&)((set).Get(GetWhich((sid))))).GetValue() ) \
							  == VOBJ_MODE_SHOW )

//========================================================================

ScTablePage::ScTablePage( Window* pParent, const SfxItemSet& rCoreAttrs ) :

        SfxTabPage( pParent, ScResId( RID_SCPAGE_TABLE ), rCoreAttrs ),

		aBtnHeaders 		( this, ScResId( BTN_HEADER ) ),
		aBtnGrid			( this, ScResId( BTN_GRID ) ),
		aBtnNotes			( this, ScResId( BTN_NOTES ) ),
		aBtnObjects 		( this, ScResId( BTN_OBJECTS ) ),
		aBtnCharts			( this, ScResId( BTN_CHARTS ) ),
		aBtnDrawings		( this, ScResId( BTN_DRAWINGS ) ),
		aBtnFormulas		( this, ScResId( BTN_FORMULAS ) ),
		aBtnNullVals		( this, ScResId( BTN_NULLVALS ) ),
        aFlPrint            ( this, ScResId( FL_PRINT ) ),
		aBtnTopDown 		( this, ScResId( BTN_TOPDOWN ) ),
		aBtnLeftRight		( this, ScResId( BTN_LEFTRIGHT ) ),
		aBmpPageDir 		( this, ScResId( BMP_PAGEDIR ) ),
		aImgTopDown 		( ScResId( IMG_TOPDOWN ) ),
		aImgLeftRight		( ScResId( IMG_LEFTRIGHT ) ),
        aImgTopDownHC       ( ScResId( IMG_TOPDOWN_H ) ),
        aImgLeftRightHC     ( ScResId( IMG_LEFTRIGHT_H ) ),
		aBtnPageNo			( this, ScResId( BTN_PAGENO ) ),
		aEdPageNo			( this, ScResId( ED_PAGENO ) ),
        aFlPageDir          ( this, ScResId( FL_PAGEDIR ) ),
        aFlScale            ( this, ScResId( FL_SCALE ) ),
        aFtScaleMode        ( this, ScResId( FT_SCALEMODE ) ),
        aLbScaleMode        ( this, ScResId( LB_SCALEMODE ) ),
        aFtScaleAll         ( this, ScResId( FT_SCALEFACTOR ) ),
		aEdScaleAll 		( this, ScResId( ED_SCALEALL ) ),
        aFtScalePageWidth   ( this, ScResId( FT_SCALEPAGEWIDTH ) ),
        aEdScalePageWidth   ( this, ScResId( ED_SCALEPAGEWIDTH ) ),
        aFtScalePageHeight  ( this, ScResId( FT_SCALEPAGEHEIGHT ) ),
        aEdScalePageHeight  ( this, ScResId( ED_SCALEPAGEHEIGHT ) ),
        aFtScalePageNum     ( this, ScResId( FT_SCALEPAGENUM ) ),
        aEdScalePageNum     ( this, ScResId( ED_SCALEPAGENUM ) )
{
	SetExchangeSupport();
    aBtnPageNo.SetClickHdl( PAGENO_HDL );
    aBtnTopDown.SetClickHdl( PAGEDIR_HDL );
    aBtnLeftRight.SetClickHdl( PAGEDIR_HDL );
    aLbScaleMode.SetSelectHdl( SCALE_HDL );

    Size aBmpSize = Image( IMG_LEFTRIGHT ).GetSizePixel();
    aBmpPageDir.SetOutputSizePixel( aBmpSize );

	FreeResource();
}

// -----------------------------------------------------------------------

void ScTablePage::ShowImage()
{
    bool bDark = GetDisplayBackground().GetColor().IsDark();
    bool bLeftRight = aBtnLeftRight.IsChecked();
    aBmpPageDir.SetImage( bDark ?
        (bLeftRight ? aImgLeftRightHC : aImgTopDownHC) :
        (bLeftRight ? aImgLeftRight : aImgTopDown) );
}

// -----------------------------------------------------------------------

ScTablePage::~ScTablePage()
{
}

//------------------------------------------------------------------------

USHORT* ScTablePage::GetRanges()
{
	return pPageTableRanges;
}

// -----------------------------------------------------------------------

SfxTabPage* ScTablePage::Create( Window* pParent, const SfxItemSet& rCoreSet )
{
	return ( new ScTablePage( pParent, rCoreSet ) );
}

// -----------------------------------------------------------------------

void ScTablePage::Reset( const SfxItemSet& rCoreSet )
{
	BOOL	bTopDown = GET_BOOL( SID_SCATTR_PAGE_TOPDOWN, rCoreSet );
	USHORT	nWhich   = 0;

	//-----------
	// BOOL-Flags
	//-----------
	aBtnNotes		.Check( GET_BOOL(SID_SCATTR_PAGE_NOTES,rCoreSet) );
	aBtnGrid		.Check( GET_BOOL(SID_SCATTR_PAGE_GRID,rCoreSet) );
	aBtnHeaders 	.Check( GET_BOOL(SID_SCATTR_PAGE_HEADERS,rCoreSet) );
	aBtnFormulas	.Check( GET_BOOL(SID_SCATTR_PAGE_FORMULAS,rCoreSet) );
	aBtnNullVals	.Check( GET_BOOL(SID_SCATTR_PAGE_NULLVALS,rCoreSet) );
	aBtnTopDown 	.Check( bTopDown );
	aBtnLeftRight	.Check( !bTopDown );

	//------------------
	// Erste Druckseite:
	//------------------
	USHORT nPage = GET_USHORT(SID_SCATTR_PAGE_FIRSTPAGENO,rCoreSet);
	aBtnPageNo.Check( nPage != 0 );
	aEdPageNo.SetValue( (nPage != 0) ? nPage : 1 );
	PageNoHdl( NULL );

	//-------------------
	// Objektdarstellung:
	//-------------------
	aBtnCharts		.Check( GET_SHOW( SID_SCATTR_PAGE_CHARTS, rCoreSet ) );
	aBtnObjects 	.Check( GET_SHOW( SID_SCATTR_PAGE_OBJECTS, rCoreSet ) );
	aBtnDrawings	.Check( GET_SHOW( SID_SCATTR_PAGE_DRAWINGS, rCoreSet ) );

	//------------
	// Skalierung:
	//------------

	nWhich = GetWhich(SID_SCATTR_PAGE_SCALE);
	if ( rCoreSet.GetItemState( nWhich, TRUE ) >= SFX_ITEM_AVAILABLE )
	{
		USHORT nScale = ((const SfxUInt16Item&)rCoreSet.Get(nWhich)).GetValue();
        if( nScale > 0 )
            aLbScaleMode.SelectEntryPos( SC_TPTABLE_SCALE_PERCENT );
        aEdScaleAll.SetValue( (nScale > 0) ? nScale : 100 );
	}

    nWhich = GetWhich(SID_SCATTR_PAGE_SCALETO);
    if ( rCoreSet.GetItemState( nWhich, TRUE ) >= SFX_ITEM_AVAILABLE )
    {
        const ScPageScaleToItem& rItem = static_cast< const ScPageScaleToItem& >( rCoreSet.Get( nWhich ) );
        USHORT nWidth = rItem.GetWidth();
        USHORT nHeight = rItem.GetHeight();

        /*  width==0 and height==0 is invalid state, used as "not selected".
            Dialog shows width=height=1 then. */
        bool bValid = nWidth || nHeight;
        if( bValid )
            aLbScaleMode.SelectEntryPos( SC_TPTABLE_SCALE_TO );
        aEdScalePageWidth.SetValue( bValid ? nWidth : 1 );
        aEdScalePageHeight.SetValue( bValid ? nHeight : 1 );
    }

	nWhich = GetWhich(SID_SCATTR_PAGE_SCALETOPAGES);
	if ( rCoreSet.GetItemState( nWhich, TRUE ) >= SFX_ITEM_AVAILABLE )
	{
		USHORT nPages = ((const SfxUInt16Item&)rCoreSet.Get(nWhich)).GetValue();
        if( nPages > 0 )
            aLbScaleMode.SelectEntryPos( SC_TPTABLE_SCALE_TO_PAGES );
        aEdScalePageNum.SetValue( (nPages > 0) ? nPages : 1 );
	}

    if( aLbScaleMode.GetSelectEntryCount() == 0 )
    {
        // fall back to 100%
        DBG_ERRORFILE( "ScTablePage::Reset - missing scaling item" );
        aLbScaleMode.SelectEntryPos( SC_TPTABLE_SCALE_PERCENT );
        aEdScaleAll.SetValue( 100 );
    }

	PageDirHdl( NULL );
	ScaleHdl( NULL );

	// merken fuer FillItemSet
	aBtnFormulas	.SaveValue();
	aBtnNullVals	.SaveValue();
	aBtnNotes		.SaveValue();
	aBtnGrid		.SaveValue();
	aBtnHeaders 	.SaveValue();
	aBtnTopDown 	.SaveValue();
	aBtnLeftRight	.SaveValue();
    aLbScaleMode    .SaveValue();
	aBtnCharts		.SaveValue();
	aBtnObjects 	.SaveValue();
	aBtnDrawings	.SaveValue();
	aBtnPageNo		.SaveValue();
	aEdPageNo		.SaveValue();
	aEdScaleAll		.SaveValue();
    aEdScalePageWidth.SaveValue();
    aEdScalePageHeight.SaveValue();
	aEdScalePageNum	.SaveValue();
}

// -----------------------------------------------------------------------

BOOL ScTablePage::FillItemSet( SfxItemSet& rCoreSet )
{
	const SfxItemSet&	rOldSet		 = GetItemSet();
	USHORT				nWhichPageNo = GetWhich(SID_SCATTR_PAGE_FIRSTPAGENO);
	BOOL				bDataChanged = FALSE;

	//-----------
	// BOOL-Flags
	//-----------

	bDataChanged |= lcl_PutBoolItem( GetWhich(SID_SCATTR_PAGE_NOTES),
									 rCoreSet, rOldSet,
									 aBtnNotes.IsChecked(),
									 aBtnNotes.GetSavedValue() );

	bDataChanged |= lcl_PutBoolItem( GetWhich(SID_SCATTR_PAGE_GRID),
									 rCoreSet, rOldSet,
									 aBtnGrid.IsChecked(),
									 aBtnGrid.GetSavedValue() );

	bDataChanged |= lcl_PutBoolItem( GetWhich(SID_SCATTR_PAGE_HEADERS),
									 rCoreSet, rOldSet,
									 aBtnHeaders.IsChecked(),
									 aBtnHeaders.GetSavedValue() );

	bDataChanged |= lcl_PutBoolItem( GetWhich(SID_SCATTR_PAGE_TOPDOWN),
									 rCoreSet, rOldSet,
									 aBtnTopDown.IsChecked(),
									 aBtnTopDown.GetSavedValue() );

	bDataChanged |= lcl_PutBoolItem( GetWhich(SID_SCATTR_PAGE_FORMULAS),
									 rCoreSet, rOldSet,
									 aBtnFormulas.IsChecked(),
									 aBtnFormulas.GetSavedValue() );

	bDataChanged |= lcl_PutBoolItem( GetWhich(SID_SCATTR_PAGE_NULLVALS),
									 rCoreSet, rOldSet,
									 aBtnNullVals.IsChecked(),
									 aBtnNullVals.GetSavedValue() );

	//------------------
	// Erste Druckseite:
	//------------------
	BOOL bUseValue = aBtnPageNo.IsChecked();

	if (   WAS_DEFAULT(nWhichPageNo,rOldSet)
		&& (	!bUseValue && bUseValue == aBtnPageNo.GetSavedValue()
			|| (   bUseValue && bUseValue == aBtnPageNo.GetSavedValue()
				&& aEdPageNo.GetText() == aEdPageNo.GetSavedValue() ) ) )
	{
			rCoreSet.ClearItem( nWhichPageNo );
	}
	else
	{
		UINT16 nPage = (UINT16)( aBtnPageNo.IsChecked()
									? aEdPageNo.GetValue()
									: 0 );

		rCoreSet.Put( SfxUInt16Item( nWhichPageNo, nPage ) );
		bDataChanged = TRUE;
	}

	//-------------------
	// Objektdarstellung:
	//-------------------

	bDataChanged |= lcl_PutVObjModeItem( GetWhich(SID_SCATTR_PAGE_CHARTS),
										 rCoreSet, rOldSet, aBtnCharts );

	bDataChanged |= lcl_PutVObjModeItem( GetWhich(SID_SCATTR_PAGE_OBJECTS),
										 rCoreSet, rOldSet, aBtnObjects );

	bDataChanged |= lcl_PutVObjModeItem( GetWhich(SID_SCATTR_PAGE_DRAWINGS),
										 rCoreSet, rOldSet, aBtnDrawings );

	//------------
	// Skalierung:
	//------------

    if( !aEdScalePageWidth.GetValue() && !aEdScalePageHeight.GetValue() )
    {
        aLbScaleMode.SelectEntryPos( SC_TPTABLE_SCALE_PERCENT );
        aEdScaleAll.SetValue( 100 );
    }

	bDataChanged |= lcl_PutScaleItem( GetWhich(SID_SCATTR_PAGE_SCALE),
									  rCoreSet, rOldSet,
                                      aLbScaleMode, SC_TPTABLE_SCALE_PERCENT,
                                      aEdScaleAll, (UINT16)aEdScaleAll.GetValue() );

    bDataChanged |= lcl_PutScaleItem2( GetWhich(SID_SCATTR_PAGE_SCALETO),
                                      rCoreSet, rOldSet,
                                      aLbScaleMode, SC_TPTABLE_SCALE_TO,
                                      aEdScalePageWidth, aEdScalePageHeight );

	bDataChanged |= lcl_PutScaleItem( GetWhich(SID_SCATTR_PAGE_SCALETOPAGES),
									  rCoreSet, rOldSet,
                                      aLbScaleMode, SC_TPTABLE_SCALE_TO_PAGES,
                                      aEdScalePageNum, (UINT16)aEdScalePageNum.GetValue() );

	return bDataChanged;
}

//------------------------------------------------------------------------

int ScTablePage::DeactivatePage( SfxItemSet* pSet )
{
	if ( pSet )
		FillItemSet( *pSet );

	return LEAVE_PAGE;
}

//------------------------------------------------------------------------

void ScTablePage::DataChanged( const DataChangedEvent& rDCEvt )
{
    if( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
        ShowImage();
    SfxTabPage::DataChanged( rDCEvt );
}

//------------------------------------------------------------------------
// Handler:
//------------------------------------------------------------------------

IMPL_LINK( ScTablePage, PageDirHdl, RadioButton*, EMPTYARG )
{
    ShowImage();
	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( ScTablePage, PageNoHdl, CheckBox*, pBtn )
{
	if ( aBtnPageNo.IsChecked() )
	{
		aEdPageNo.Enable();
		if ( pBtn )
			aEdPageNo.GrabFocus();
	}
	else
		aEdPageNo.Disable();

	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( ScTablePage, ScaleHdl, ListBox*, pListBox )
{
    // controls for "Reduce/enlarge"
    bool bPercent = (aLbScaleMode.GetSelectEntryPos() == SC_TPTABLE_SCALE_PERCENT);
    aFtScaleAll.Show( bPercent );
    aEdScaleAll.Show( bPercent );

    // controls for "Scale to width/height"
    bool bScaleTo = (aLbScaleMode.GetSelectEntryPos() == SC_TPTABLE_SCALE_TO);
    aFtScalePageWidth.Show( bScaleTo );
    aEdScalePageWidth.Show( bScaleTo );
    aFtScalePageHeight.Show( bScaleTo );
    aEdScalePageHeight.Show( bScaleTo );

    // controls for "Scale to pages"
    bool bScalePages = (aLbScaleMode.GetSelectEntryPos() == SC_TPTABLE_SCALE_TO_PAGES);
    aFtScalePageNum.Show( bScalePages );
    aEdScalePageNum.Show( bScalePages );

	return 0;
}

//========================================================================
// Hilfsfunktionen fuer FillItemSet:
//========================================================================

BOOL lcl_PutBoolItem( USHORT			nWhich,
					 SfxItemSet&		rCoreSet,
					 const SfxItemSet&	rOldSet,
					 BOOL				bIsChecked,
					 BOOL				bSavedValue )
{
	BOOL bDataChanged = (   bSavedValue == bIsChecked
						 && WAS_DEFAULT(nWhich,rOldSet) );

	if ( bDataChanged )
		rCoreSet.ClearItem(nWhich);
	else
		rCoreSet.Put( SfxBoolItem( nWhich, bIsChecked ) );

	return bDataChanged;
}

//------------------------------------------------------------------------

BOOL lcl_PutVObjModeItem( USHORT			nWhich,
						 SfxItemSet&		rCoreSet,
						 const SfxItemSet&	rOldSet,
						 const CheckBox&	rBtn )
{
	BOOL bIsChecked   = rBtn.IsChecked();
	BOOL bDataChanged = (   rBtn.GetSavedValue() == bIsChecked
						 && WAS_DEFAULT(nWhich,rOldSet) );

	if ( bDataChanged )
		rCoreSet.ClearItem( nWhich );

	else
		rCoreSet.Put( ScViewObjectModeItem( nWhich, bIsChecked
													? VOBJ_MODE_SHOW
													: VOBJ_MODE_HIDE ) );
	return bDataChanged;
}

//------------------------------------------------------------------------

BOOL lcl_PutScaleItem( USHORT				nWhich,
					  SfxItemSet&			rCoreSet,
					  const SfxItemSet&		rOldSet,
                      const ListBox&        rListBox,
                      USHORT                nLBEntry,
                      const SpinField&      rEd,
                      UINT16                nValue )
{
    BOOL bIsSel = (rListBox.GetSelectEntryPos() == nLBEntry);
    BOOL bDataChanged = (rListBox.GetSavedValue() != nLBEntry) ||
                        (rEd.GetSavedValue() != rEd.GetText()) ||
                        !WAS_DEFAULT( nWhich, rOldSet );

    if( bDataChanged )
        rCoreSet.Put( SfxUInt16Item( nWhich, bIsSel ? nValue : 0 ) );
    else
        rCoreSet.ClearItem( nWhich );

	return bDataChanged;
}


BOOL lcl_PutScaleItem2( USHORT               nWhich,
                      SfxItemSet&           rCoreSet,
                      const SfxItemSet&     rOldSet,
                      const ListBox&        rListBox,
                      USHORT                nLBEntry,
                      const NumericField&   rEd1,
                      const NumericField&   rEd2 )
{
    UINT16 nValue1 = (UINT16)rEd1.GetValue();
    UINT16 nValue2 = (UINT16)rEd2.GetValue();
    BOOL bIsSel = (rListBox.GetSelectEntryPos() == nLBEntry);
    BOOL bDataChanged = (rListBox.GetSavedValue() != nLBEntry) ||
                        (rEd1.GetSavedValue() != rEd1.GetText()) ||
                        (rEd2.GetSavedValue() != rEd2.GetText()) ||
                        !WAS_DEFAULT( nWhich, rOldSet );

    if( bDataChanged )
    {
        ScPageScaleToItem aItem;
        if( bIsSel )
            aItem.Set( nValue1, nValue2 );
        rCoreSet.Put( aItem );
    }
    else
        rCoreSet.ClearItem( nWhich );

    return bDataChanged;
}



