/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudgrtyp.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:22:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#pragma hdrstop

#include <svx/svxids.hrc>
#include "schdll.hxx"
#define ITEMID_CHARTSTYLE	CHATTR_DIAGRAM_STYLE
#include <svx/chrtitem.hxx>

#include "app.hrc"
#include "diagrtyp.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "schview.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "viewshel.hxx"
#include "undgrtyp.hxx"
#include "fudgrtyp.hxx"
#include "schattr.hxx"
#include "SchRangeChecker.hxx"
#include "glob.hrc"

TYPEINIT1(SchFuDiagramType, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuDiagramType::SchFuDiagramType(SchViewShell* pViewSh, SchWindow* pWin,
								   SchView* pView, ChartModel* pDoc,
								   SfxRequest& rReq) :
	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	SvxChartStyle eOldStyle	= pDoc->ChartStyle();

	const SfxItemSet* pArgs = rReq.GetArgs();
	SfxItemSet aAttr(pViewSh->GetPool(), CHATTR_DIAGRAM_START,
										 CHATTR_DIAGRAM_END,
										 SCHATTR_STYLE_SHAPE,
										 SCHATTR_STYLE_SHAPE,0);

	aAttr.Put(SfxInt32Item(SCHATTR_STYLE_SHAPE,pDoc->GetChartShapeType()));
	USHORT nSID = CHATTR_DIAGRAM_STYLE;
    long nOldNumLinesColChart = pDoc->GetNumLinesColChart();
    long nNumLinesColChart = nOldNumLinesColChart;

    if (!pArgs)
	{
		aAttr.Put(SvxChartStyleItem(eOldStyle));
//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
		SchDiagramTypeDlg* pDlg = new SchDiagramTypeDlg(NULL, aAttr);

		pDlg->SetDepth (pDoc->SplineDepth () - 1);
		pDlg->SetGranularity (pDoc->Granularity ());

        // for line/bar combination charts
        pDlg->SetNumberOfLines( nOldNumLinesColChart );
        pDlg->SetMaximumNumberOfLines( pDoc->GetRowCount() - 1 );

		if (pDlg->Execute() == RET_OK)
		{
			pDoc->SplineDepth () = pDlg->GetDepth() + 1;
			pDoc->Granularity ()  = pDlg->GetGranularity ();
            nNumLinesColChart = pDlg->GetNumberOfLines();

			pDlg->GetAttr(aAttr);
			rReq.Done(aAttr);
			pArgs = rReq.GetArgs();
			delete pDlg;

		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else
	{
		pChDoc->CanRebuild (FALSE);
		nSID = SID_DIAGRAM_TYPE;
	}

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	// Diagrammtyp (Basic)
	SFX_REQUEST_ARG( rReq, pDiagramTypeItem, SvxChartStyleItem, nSID, FALSE );
	SvxChartStyle eDiagramType = pDiagramTypeItem ? pDiagramTypeItem->GetValue() : eOldStyle;
	CheckRange (pDoc, eDiagramType);

	BOOL bBuild=FALSE;

	// erzwinge bei splines auf jeden fall den neuaufbau des charts
	switch (eDiagramType)
	{
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			bBuild=TRUE;//pDoc->ChartStyle() = CHSTYLE_2D_LINE;     // haesslicher hack //Das ist ja wohl grob untertrieben! Und warum????
			break;
		default :
			break;
	}

	const SfxPoolItem* pPoolItem;
	if (aAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem)== SFX_ITEM_SET)
	{
			pDoc->PutDataRowAttrAll(aAttr);
			bBuild=TRUE;
	}
	if( pDoc->ChangeChart( eDiagramType ) )
	{
		bBuild = TRUE;
		SchUndoDiagramType* pUndo =	new SchUndoDiagramType(*pDoc, eOldStyle,eDiagramType);
		pUndo->SetComment(String(SchResId(STR_UNDO_DIAGRAM_TYPE)));
		pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	}

    if( nNumLinesColChart > -1 &&
        ( eDiagramType == CHSTYLE_2D_LINE_COLUMN ||
          eDiagramType == CHSTYLE_2D_LINE_STACKEDCOLUMN ) &&
        ( nNumLinesColChart != nOldNumLinesColChart ))
    {
        pDoc->SetNumLinesColChart( nNumLinesColChart );
        bBuild = TRUE;
    }

	if( bBuild )
    {
        pDoc->BuildChart(FALSE);
    }
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramType::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramType::Deactivate()
{
}



void	SchFuDiagramType::CheckRange	(ChartModel * pChartModel,
										SvxChartStyle nStyle)
{
	SchRangeChecker	RangeChecker (pChartModel);
	
	if (RangeChecker.TestAbsoluteValues (nStyle))
	{
		InfoBox	aInfoBox (NULL, String(SchResId(STR_ONLY_ABS_VALUES)));
		aInfoBox.Execute();
	}
	else if (RangeChecker.TestNegativeValues (nStyle))
	{
		InfoBox	aInfoBox (NULL, String(SchResId(STR_NO_MIN_VALUES)));
		aInfoBox.Execute();
	}

	if (RangeChecker.TestLogarithmicValues ())
	{
		InfoBox	aInfoBox (NULL, String(SchResId(STR_NO_LOGARITHMIC_MIN_VALUES)));
		aInfoBox.Execute();
	}
}
