#!/bin/awk -f
BEGIN { 
	FS = "\n" # handle full line as single field
	for ( i=1; i<=255; ++i ) {
		hex[ sprintf ("%c", i) "" ] = sprintf ("%%%x", i) ""
	}
}  
{ 
	# usually uris are encoded segment by segment, but we make
	# an exception for file uri's here
	if ( $1 ~ /^file:\/\// ) {
		uri = "file://"
		for ( i=8; i<=length($1); ++i ) {
			c = substr($1,i,1)
			# valid RFC 2396 pchar characters + '/'
			if ( c ~ /[a-zA-Z0-9!$'()*+,\-.:=@_~\/]/ ) {
				uri = uri c
			} else {
				uri = uri hex[ c ]
			}
		}
		print uri
		exit 0
	} else {
		uri = ""
		for ( i=0; i<=length($1); ++i ) {
			c = substr($1,i,1)
			# valid RFC 2396 pchar characters
			if ( c ~ /[a-zA-Z0-9!$'()*+,\-.:=@_~]/ ) {
				uri = uri c
			} else {
				uri = uri hex[ c ]
			}
		}
		print uri
		exit 0
	} 
}
